import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudRunDomainMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#id GoogleCloudRunDomainMapping#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the cloud run instance. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#location GoogleCloudRunDomainMapping#location}
    */
    readonly location: string;
    /**
    * Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#name GoogleCloudRunDomainMapping#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#project GoogleCloudRunDomainMapping#project}
    */
    readonly project?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#metadata GoogleCloudRunDomainMapping#metadata}
    */
    readonly metadata: GoogleCloudRunDomainMappingMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#spec GoogleCloudRunDomainMapping#spec}
    */
    readonly spec: GoogleCloudRunDomainMappingSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#timeouts GoogleCloudRunDomainMapping#timeouts}
    */
    readonly timeouts?: GoogleCloudRunDomainMappingTimeouts;
}
export interface GoogleCloudRunDomainMappingStatusConditions {
}
export declare function googleCloudRunDomainMappingStatusConditionsToTerraform(struct?: GoogleCloudRunDomainMappingStatusConditions): any;
export declare class GoogleCloudRunDomainMappingStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunDomainMappingStatusConditions | undefined;
    set internalValue(value: GoogleCloudRunDomainMappingStatusConditions | undefined);
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class GoogleCloudRunDomainMappingStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunDomainMappingStatusConditionsOutputReference;
}
export interface GoogleCloudRunDomainMappingStatusResourceRecords {
}
export declare function googleCloudRunDomainMappingStatusResourceRecordsToTerraform(struct?: GoogleCloudRunDomainMappingStatusResourceRecords): any;
export declare class GoogleCloudRunDomainMappingStatusResourceRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunDomainMappingStatusResourceRecords | undefined;
    set internalValue(value: GoogleCloudRunDomainMappingStatusResourceRecords | undefined);
    get name(): string;
    get rrdata(): string;
    get type(): string;
}
export declare class GoogleCloudRunDomainMappingStatusResourceRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunDomainMappingStatusResourceRecordsOutputReference;
}
export interface GoogleCloudRunDomainMappingStatus {
}
export declare function googleCloudRunDomainMappingStatusToTerraform(struct?: GoogleCloudRunDomainMappingStatus): any;
export declare class GoogleCloudRunDomainMappingStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudRunDomainMappingStatus | undefined;
    set internalValue(value: GoogleCloudRunDomainMappingStatus | undefined);
    private _conditions;
    get conditions(): GoogleCloudRunDomainMappingStatusConditionsList;
    get mappedRouteName(): string;
    get observedGeneration(): number;
    private _resourceRecords;
    get resourceRecords(): GoogleCloudRunDomainMappingStatusResourceRecordsList;
}
export declare class GoogleCloudRunDomainMappingStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudRunDomainMappingStatusOutputReference;
}
export interface GoogleCloudRunDomainMappingMetadata {
    /**
    * Annotations is a key value map stored with a resource that
  may be set by external tools to store and retrieve arbitrary metadata. More
  info: http://kubernetes.io/docs/user-guide/annotations
  
  **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
  If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
  or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#annotations GoogleCloudRunDomainMapping#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize
  (scope and select) objects. May match selectors of replication controllers
  and routes.
  More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#labels GoogleCloudRunDomainMapping#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * In Cloud Run the namespace must be equal to either the
  project ID or project number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#namespace GoogleCloudRunDomainMapping#namespace}
    */
    readonly namespace: string;
}
export declare function googleCloudRunDomainMappingMetadataToTerraform(struct?: GoogleCloudRunDomainMappingMetadataOutputReference | GoogleCloudRunDomainMappingMetadata): any;
export declare class GoogleCloudRunDomainMappingMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunDomainMappingMetadata | undefined;
    set internalValue(value: GoogleCloudRunDomainMappingMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export interface GoogleCloudRunDomainMappingSpec {
    /**
    * The mode of the certificate. Default value: "AUTOMATIC" Possible values: ["NONE", "AUTOMATIC"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#certificate_mode GoogleCloudRunDomainMapping#certificate_mode}
    */
    readonly certificateMode?: string;
    /**
    * If set, the mapping will override any mapping set before this spec was set.
  It is recommended that the user leaves this empty to receive an error
  warning about a potential conflict and only set it once the respective UI
  has given such a warning.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#force_override GoogleCloudRunDomainMapping#force_override}
    */
    readonly forceOverride?: boolean | cdktf.IResolvable;
    /**
    * The name of the Cloud Run Service that this DomainMapping applies to.
  The route must exist.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#route_name GoogleCloudRunDomainMapping#route_name}
    */
    readonly routeName: string;
}
export declare function googleCloudRunDomainMappingSpecToTerraform(struct?: GoogleCloudRunDomainMappingSpecOutputReference | GoogleCloudRunDomainMappingSpec): any;
export declare class GoogleCloudRunDomainMappingSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunDomainMappingSpec | undefined;
    set internalValue(value: GoogleCloudRunDomainMappingSpec | undefined);
    private _certificateMode?;
    get certificateMode(): string;
    set certificateMode(value: string);
    resetCertificateMode(): void;
    get certificateModeInput(): string | undefined;
    private _forceOverride?;
    get forceOverride(): boolean | cdktf.IResolvable;
    set forceOverride(value: boolean | cdktf.IResolvable);
    resetForceOverride(): void;
    get forceOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _routeName?;
    get routeName(): string;
    set routeName(value: string);
    get routeNameInput(): string | undefined;
}
export interface GoogleCloudRunDomainMappingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#create GoogleCloudRunDomainMapping#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping#delete GoogleCloudRunDomainMapping#delete}
    */
    readonly delete?: string;
}
export declare function googleCloudRunDomainMappingTimeoutsToTerraform(struct?: GoogleCloudRunDomainMappingTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudRunDomainMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudRunDomainMappingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudRunDomainMappingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping google_cloud_run_domain_mapping}
*/
export declare class GoogleCloudRunDomainMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_domain_mapping";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloud_run_domain_mapping google_cloud_run_domain_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudRunDomainMappingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudRunDomainMappingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status;
    get status(): GoogleCloudRunDomainMappingStatusList;
    private _metadata;
    get metadata(): GoogleCloudRunDomainMappingMetadataOutputReference;
    putMetadata(value: GoogleCloudRunDomainMappingMetadata): void;
    get metadataInput(): GoogleCloudRunDomainMappingMetadata | undefined;
    private _spec;
    get spec(): GoogleCloudRunDomainMappingSpecOutputReference;
    putSpec(value: GoogleCloudRunDomainMappingSpec): void;
    get specInput(): GoogleCloudRunDomainMappingSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudRunDomainMappingTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudRunDomainMappingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudRunDomainMappingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
