import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudbuildBitbucketServerConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed.
  Changing this field will result in deleting/ recreating the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#api_key GoogleCloudbuildBitbucketServerConfig#api_key}
    */
    readonly apiKey: string;
    /**
    * The ID to use for the BitbucketServerConfig, which will become the final component of the BitbucketServerConfig's resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#config_id GoogleCloudbuildBitbucketServerConfig#config_id}
    */
    readonly configId: string;
    /**
    * Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed.
  If you need to change it, please create another BitbucketServerConfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#host_uri GoogleCloudbuildBitbucketServerConfig#host_uri}
    */
    readonly hostUri: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#id GoogleCloudbuildBitbucketServerConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of this bitbucket server config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#location GoogleCloudbuildBitbucketServerConfig#location}
    */
    readonly location: string;
    /**
    * The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private service connection.
  This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by public internet. If this field is left empty,
  no network peering will occur and calls to the Bitbucket Server instance will be made over the public internet. Must be in the format
  projects/{project}/global/networks/{network}, where {project} is a project number or id and {network} is the name of a VPC network in the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#peered_network GoogleCloudbuildBitbucketServerConfig#peered_network}
    */
    readonly peeredNetwork?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#project GoogleCloudbuildBitbucketServerConfig#project}
    */
    readonly project?: string;
    /**
    * SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of .pem, .cer, or .crt.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#ssl_ca GoogleCloudbuildBitbucketServerConfig#ssl_ca}
    */
    readonly sslCa?: string;
    /**
    * Username of the account Cloud Build will use on Bitbucket Server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#username GoogleCloudbuildBitbucketServerConfig#username}
    */
    readonly username: string;
    /**
    * connected_repositories block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#connected_repositories GoogleCloudbuildBitbucketServerConfig#connected_repositories}
    */
    readonly connectedRepositories?: GoogleCloudbuildBitbucketServerConfigConnectedRepositories[] | cdktf.IResolvable;
    /**
    * secrets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#secrets GoogleCloudbuildBitbucketServerConfig#secrets}
    */
    readonly secrets: GoogleCloudbuildBitbucketServerConfigSecrets;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#timeouts GoogleCloudbuildBitbucketServerConfig#timeouts}
    */
    readonly timeouts?: GoogleCloudbuildBitbucketServerConfigTimeouts;
}
export interface GoogleCloudbuildBitbucketServerConfigConnectedRepositories {
    /**
    * Identifier for the project storing the repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#project_key GoogleCloudbuildBitbucketServerConfig#project_key}
    */
    readonly projectKey: string;
    /**
    * Identifier for the repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#repo_slug GoogleCloudbuildBitbucketServerConfig#repo_slug}
    */
    readonly repoSlug: string;
}
export declare function googleCloudbuildBitbucketServerConfigConnectedRepositoriesToTerraform(struct?: GoogleCloudbuildBitbucketServerConfigConnectedRepositories | cdktf.IResolvable): any;
export declare class GoogleCloudbuildBitbucketServerConfigConnectedRepositoriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudbuildBitbucketServerConfigConnectedRepositories | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildBitbucketServerConfigConnectedRepositories | cdktf.IResolvable | undefined);
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    private _repoSlug?;
    get repoSlug(): string;
    set repoSlug(value: string);
    get repoSlugInput(): string | undefined;
}
export declare class GoogleCloudbuildBitbucketServerConfigConnectedRepositoriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudbuildBitbucketServerConfigConnectedRepositories[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudbuildBitbucketServerConfigConnectedRepositoriesOutputReference;
}
export interface GoogleCloudbuildBitbucketServerConfigSecrets {
    /**
    * The resource name for the admin access token's secret version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#admin_access_token_version_name GoogleCloudbuildBitbucketServerConfig#admin_access_token_version_name}
    */
    readonly adminAccessTokenVersionName: string;
    /**
    * The resource name for the read access token's secret version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#read_access_token_version_name GoogleCloudbuildBitbucketServerConfig#read_access_token_version_name}
    */
    readonly readAccessTokenVersionName: string;
    /**
    * Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed.
  Changing this field will result in deleting/ recreating the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#webhook_secret_version_name GoogleCloudbuildBitbucketServerConfig#webhook_secret_version_name}
    */
    readonly webhookSecretVersionName: string;
}
export declare function googleCloudbuildBitbucketServerConfigSecretsToTerraform(struct?: GoogleCloudbuildBitbucketServerConfigSecretsOutputReference | GoogleCloudbuildBitbucketServerConfigSecrets): any;
export declare class GoogleCloudbuildBitbucketServerConfigSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildBitbucketServerConfigSecrets | undefined;
    set internalValue(value: GoogleCloudbuildBitbucketServerConfigSecrets | undefined);
    private _adminAccessTokenVersionName?;
    get adminAccessTokenVersionName(): string;
    set adminAccessTokenVersionName(value: string);
    get adminAccessTokenVersionNameInput(): string | undefined;
    private _readAccessTokenVersionName?;
    get readAccessTokenVersionName(): string;
    set readAccessTokenVersionName(value: string);
    get readAccessTokenVersionNameInput(): string | undefined;
    private _webhookSecretVersionName?;
    get webhookSecretVersionName(): string;
    set webhookSecretVersionName(value: string);
    get webhookSecretVersionNameInput(): string | undefined;
}
export interface GoogleCloudbuildBitbucketServerConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#create GoogleCloudbuildBitbucketServerConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#delete GoogleCloudbuildBitbucketServerConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config#update GoogleCloudbuildBitbucketServerConfig#update}
    */
    readonly update?: string;
}
export declare function googleCloudbuildBitbucketServerConfigTimeoutsToTerraform(struct?: GoogleCloudbuildBitbucketServerConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudbuildBitbucketServerConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildBitbucketServerConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildBitbucketServerConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config google_cloudbuild_bitbucket_server_config}
*/
export declare class GoogleCloudbuildBitbucketServerConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudbuild_bitbucket_server_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_bitbucket_server_config google_cloudbuild_bitbucket_server_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudbuildBitbucketServerConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudbuildBitbucketServerConfigConfig);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    get apiKeyInput(): string | undefined;
    private _configId?;
    get configId(): string;
    set configId(value: string);
    get configIdInput(): string | undefined;
    private _hostUri?;
    get hostUri(): string;
    set hostUri(value: string);
    get hostUriInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _peeredNetwork?;
    get peeredNetwork(): string;
    set peeredNetwork(value: string);
    resetPeeredNetwork(): void;
    get peeredNetworkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _sslCa?;
    get sslCa(): string;
    set sslCa(value: string);
    resetSslCa(): void;
    get sslCaInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    get webhookKey(): string;
    private _connectedRepositories;
    get connectedRepositories(): GoogleCloudbuildBitbucketServerConfigConnectedRepositoriesList;
    putConnectedRepositories(value: GoogleCloudbuildBitbucketServerConfigConnectedRepositories[] | cdktf.IResolvable): void;
    resetConnectedRepositories(): void;
    get connectedRepositoriesInput(): cdktf.IResolvable | GoogleCloudbuildBitbucketServerConfigConnectedRepositories[] | undefined;
    private _secrets;
    get secrets(): GoogleCloudbuildBitbucketServerConfigSecretsOutputReference;
    putSecrets(value: GoogleCloudbuildBitbucketServerConfigSecrets): void;
    get secretsInput(): GoogleCloudbuildBitbucketServerConfigSecrets | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudbuildBitbucketServerConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudbuildBitbucketServerConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudbuildBitbucketServerConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
