import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudbuildWorkerPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * User specified annotations. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#annotations GoogleCloudbuildWorkerPool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * A user-specified, human-readable name for the `WorkerPool`. If provided, this value must be 1-63 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#display_name GoogleCloudbuildWorkerPool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#id GoogleCloudbuildWorkerPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#location GoogleCloudbuildWorkerPool#location}
    */
    readonly location: string;
    /**
    * User-defined name of the `WorkerPool`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#name GoogleCloudbuildWorkerPool#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#project GoogleCloudbuildWorkerPool#project}
    */
    readonly project?: string;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#network_config GoogleCloudbuildWorkerPool#network_config}
    */
    readonly networkConfig?: GoogleCloudbuildWorkerPoolNetworkConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#timeouts GoogleCloudbuildWorkerPool#timeouts}
    */
    readonly timeouts?: GoogleCloudbuildWorkerPoolTimeouts;
    /**
    * worker_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#worker_config GoogleCloudbuildWorkerPool#worker_config}
    */
    readonly workerConfig?: GoogleCloudbuildWorkerPoolWorkerConfig;
}
export interface GoogleCloudbuildWorkerPoolNetworkConfig {
    /**
    * Required. Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See [Understanding network configuration options](https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#peered_network GoogleCloudbuildWorkerPool#peered_network}
    */
    readonly peeredNetwork: string;
    /**
    * Optional. Immutable. Subnet IP range within the peered network. This is specified in CIDR notation with a slash and the subnet prefix size. You can optionally specify an IP address before the subnet prefix value. e.g. `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a prefix size of 29 bits. `/16` would specify a prefix size of 16 bits, with an automatically determined IP within the peered VPC. If unspecified, a value of `/24` will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#peered_network_ip_range GoogleCloudbuildWorkerPool#peered_network_ip_range}
    */
    readonly peeredNetworkIpRange?: string;
}
export declare function googleCloudbuildWorkerPoolNetworkConfigToTerraform(struct?: GoogleCloudbuildWorkerPoolNetworkConfigOutputReference | GoogleCloudbuildWorkerPoolNetworkConfig): any;
export declare class GoogleCloudbuildWorkerPoolNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildWorkerPoolNetworkConfig | undefined;
    set internalValue(value: GoogleCloudbuildWorkerPoolNetworkConfig | undefined);
    private _peeredNetwork?;
    get peeredNetwork(): string;
    set peeredNetwork(value: string);
    get peeredNetworkInput(): string | undefined;
    private _peeredNetworkIpRange?;
    get peeredNetworkIpRange(): string;
    set peeredNetworkIpRange(value: string);
    resetPeeredNetworkIpRange(): void;
    get peeredNetworkIpRangeInput(): string | undefined;
}
export interface GoogleCloudbuildWorkerPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#create GoogleCloudbuildWorkerPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#delete GoogleCloudbuildWorkerPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#update GoogleCloudbuildWorkerPool#update}
    */
    readonly update?: string;
}
export declare function googleCloudbuildWorkerPoolTimeoutsToTerraform(struct?: GoogleCloudbuildWorkerPoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudbuildWorkerPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildWorkerPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildWorkerPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleCloudbuildWorkerPoolWorkerConfig {
    /**
    * Size of the disk attached to the worker, in GB. See [Worker pool config file](https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#disk_size_gb GoogleCloudbuildWorkerPool#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Machine type of a worker, such as `n1-standard-1`. See [Worker pool config file](https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). If left blank, Cloud Build will use `n1-standard-1`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#machine_type GoogleCloudbuildWorkerPool#machine_type}
    */
    readonly machineType?: string;
    /**
    * If true, workers are created without any public address, which prevents network egress to public IPs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool#no_external_ip GoogleCloudbuildWorkerPool#no_external_ip}
    */
    readonly noExternalIp?: boolean | cdktf.IResolvable;
}
export declare function googleCloudbuildWorkerPoolWorkerConfigToTerraform(struct?: GoogleCloudbuildWorkerPoolWorkerConfigOutputReference | GoogleCloudbuildWorkerPoolWorkerConfig): any;
export declare class GoogleCloudbuildWorkerPoolWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildWorkerPoolWorkerConfig | undefined;
    set internalValue(value: GoogleCloudbuildWorkerPoolWorkerConfig | undefined);
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _noExternalIp?;
    get noExternalIp(): boolean | cdktf.IResolvable;
    set noExternalIp(value: boolean | cdktf.IResolvable);
    resetNoExternalIp(): void;
    get noExternalIpInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool google_cloudbuild_worker_pool}
*/
export declare class GoogleCloudbuildWorkerPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudbuild_worker_pool";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuild_worker_pool google_cloudbuild_worker_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudbuildWorkerPoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudbuildWorkerPoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    get deleteTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _networkConfig;
    get networkConfig(): GoogleCloudbuildWorkerPoolNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleCloudbuildWorkerPoolNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleCloudbuildWorkerPoolNetworkConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudbuildWorkerPoolTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudbuildWorkerPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudbuildWorkerPoolTimeouts | undefined;
    private _workerConfig;
    get workerConfig(): GoogleCloudbuildWorkerPoolWorkerConfigOutputReference;
    putWorkerConfig(value: GoogleCloudbuildWorkerPoolWorkerConfig): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): GoogleCloudbuildWorkerPoolWorkerConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
