import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudbuildv2ConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allows clients to store small amounts of arbitrary data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#annotations GoogleCloudbuildv2Connection#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * If disabled is set to true, functionality is disabled for this connection. Repository based API methods and webhooks processing for repositories in this connection will be disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#disabled GoogleCloudbuildv2Connection#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#id GoogleCloudbuildv2Connection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#location GoogleCloudbuildv2Connection#location}
    */
    readonly location: string;
    /**
    * Immutable. The resource name of the connection, in the format `projects/{project}/locations/{location}/connections/{connection_id}`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#name GoogleCloudbuildv2Connection#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#project GoogleCloudbuildv2Connection#project}
    */
    readonly project?: string;
    /**
    * github_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#github_config GoogleCloudbuildv2Connection#github_config}
    */
    readonly githubConfig?: GoogleCloudbuildv2ConnectionGithubConfig;
    /**
    * github_enterprise_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#github_enterprise_config GoogleCloudbuildv2Connection#github_enterprise_config}
    */
    readonly githubEnterpriseConfig?: GoogleCloudbuildv2ConnectionGithubEnterpriseConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#timeouts GoogleCloudbuildv2Connection#timeouts}
    */
    readonly timeouts?: GoogleCloudbuildv2ConnectionTimeouts;
}
export interface GoogleCloudbuildv2ConnectionInstallationState {
}
export declare function googleCloudbuildv2ConnectionInstallationStateToTerraform(struct?: GoogleCloudbuildv2ConnectionInstallationState): any;
export declare class GoogleCloudbuildv2ConnectionInstallationStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudbuildv2ConnectionInstallationState | undefined;
    set internalValue(value: GoogleCloudbuildv2ConnectionInstallationState | undefined);
    get actionUri(): string;
    get message(): string;
    get stage(): string;
}
export declare class GoogleCloudbuildv2ConnectionInstallationStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudbuildv2ConnectionInstallationStateOutputReference;
}
export interface GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredential {
    /**
    * A SecretManager resource containing the OAuth token that authorizes the Cloud Build connection. Format: `projects/*\/secrets/*\/versions/*`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#oauth_token_secret_version GoogleCloudbuildv2Connection#oauth_token_secret_version}
    */
    readonly oauthTokenSecretVersion?: string;
}
export declare function googleCloudbuildv2ConnectionGithubConfigAuthorizerCredentialToTerraform(struct?: GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredentialOutputReference | GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredential): any;
export declare class GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredential | undefined;
    set internalValue(value: GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredential | undefined);
    private _oauthTokenSecretVersion?;
    get oauthTokenSecretVersion(): string;
    set oauthTokenSecretVersion(value: string);
    resetOauthTokenSecretVersion(): void;
    get oauthTokenSecretVersionInput(): string | undefined;
    get username(): string;
}
export interface GoogleCloudbuildv2ConnectionGithubConfig {
    /**
    * GitHub App installation id.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#app_installation_id GoogleCloudbuildv2Connection#app_installation_id}
    */
    readonly appInstallationId?: number;
    /**
    * authorizer_credential block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#authorizer_credential GoogleCloudbuildv2Connection#authorizer_credential}
    */
    readonly authorizerCredential?: GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredential;
}
export declare function googleCloudbuildv2ConnectionGithubConfigToTerraform(struct?: GoogleCloudbuildv2ConnectionGithubConfigOutputReference | GoogleCloudbuildv2ConnectionGithubConfig): any;
export declare class GoogleCloudbuildv2ConnectionGithubConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildv2ConnectionGithubConfig | undefined;
    set internalValue(value: GoogleCloudbuildv2ConnectionGithubConfig | undefined);
    private _appInstallationId?;
    get appInstallationId(): number;
    set appInstallationId(value: number);
    resetAppInstallationId(): void;
    get appInstallationIdInput(): number | undefined;
    private _authorizerCredential;
    get authorizerCredential(): GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredentialOutputReference;
    putAuthorizerCredential(value: GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredential): void;
    resetAuthorizerCredential(): void;
    get authorizerCredentialInput(): GoogleCloudbuildv2ConnectionGithubConfigAuthorizerCredential | undefined;
}
export interface GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfig {
    /**
    * Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#service GoogleCloudbuildv2Connection#service}
    */
    readonly service: string;
}
export declare function googleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfigToTerraform(struct?: GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfigOutputReference | GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfig): any;
export declare class GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfig | undefined;
    set internalValue(value: GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfig | undefined);
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export interface GoogleCloudbuildv2ConnectionGithubEnterpriseConfig {
    /**
    * Id of the GitHub App created from the manifest.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#app_id GoogleCloudbuildv2Connection#app_id}
    */
    readonly appId?: number;
    /**
    * ID of the installation of the GitHub App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#app_installation_id GoogleCloudbuildv2Connection#app_installation_id}
    */
    readonly appInstallationId?: number;
    /**
    * The URL-friendly name of the GitHub App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#app_slug GoogleCloudbuildv2Connection#app_slug}
    */
    readonly appSlug?: string;
    /**
    * Required. The URI of the GitHub Enterprise host this connection is for.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#host_uri GoogleCloudbuildv2Connection#host_uri}
    */
    readonly hostUri: string;
    /**
    * SecretManager resource containing the private key of the GitHub App, formatted as `projects/*\/secrets/*\/versions/*`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#private_key_secret_version GoogleCloudbuildv2Connection#private_key_secret_version}
    */
    readonly privateKeySecretVersion?: string;
    /**
    * SSL certificate to use for requests to GitHub Enterprise.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#ssl_ca GoogleCloudbuildv2Connection#ssl_ca}
    */
    readonly sslCa?: string;
    /**
    * SecretManager resource containing the webhook secret of the GitHub App, formatted as `projects/*\/secrets/*\/versions/*`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#webhook_secret_secret_version GoogleCloudbuildv2Connection#webhook_secret_secret_version}
    */
    readonly webhookSecretSecretVersion?: string;
    /**
    * service_directory_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#service_directory_config GoogleCloudbuildv2Connection#service_directory_config}
    */
    readonly serviceDirectoryConfig?: GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfig;
}
export declare function googleCloudbuildv2ConnectionGithubEnterpriseConfigToTerraform(struct?: GoogleCloudbuildv2ConnectionGithubEnterpriseConfigOutputReference | GoogleCloudbuildv2ConnectionGithubEnterpriseConfig): any;
export declare class GoogleCloudbuildv2ConnectionGithubEnterpriseConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildv2ConnectionGithubEnterpriseConfig | undefined;
    set internalValue(value: GoogleCloudbuildv2ConnectionGithubEnterpriseConfig | undefined);
    private _appId?;
    get appId(): number;
    set appId(value: number);
    resetAppId(): void;
    get appIdInput(): number | undefined;
    private _appInstallationId?;
    get appInstallationId(): number;
    set appInstallationId(value: number);
    resetAppInstallationId(): void;
    get appInstallationIdInput(): number | undefined;
    private _appSlug?;
    get appSlug(): string;
    set appSlug(value: string);
    resetAppSlug(): void;
    get appSlugInput(): string | undefined;
    private _hostUri?;
    get hostUri(): string;
    set hostUri(value: string);
    get hostUriInput(): string | undefined;
    private _privateKeySecretVersion?;
    get privateKeySecretVersion(): string;
    set privateKeySecretVersion(value: string);
    resetPrivateKeySecretVersion(): void;
    get privateKeySecretVersionInput(): string | undefined;
    private _sslCa?;
    get sslCa(): string;
    set sslCa(value: string);
    resetSslCa(): void;
    get sslCaInput(): string | undefined;
    private _webhookSecretSecretVersion?;
    get webhookSecretSecretVersion(): string;
    set webhookSecretSecretVersion(value: string);
    resetWebhookSecretSecretVersion(): void;
    get webhookSecretSecretVersionInput(): string | undefined;
    private _serviceDirectoryConfig;
    get serviceDirectoryConfig(): GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfigOutputReference;
    putServiceDirectoryConfig(value: GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfig): void;
    resetServiceDirectoryConfig(): void;
    get serviceDirectoryConfigInput(): GoogleCloudbuildv2ConnectionGithubEnterpriseConfigServiceDirectoryConfig | undefined;
}
export interface GoogleCloudbuildv2ConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#create GoogleCloudbuildv2Connection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#delete GoogleCloudbuildv2Connection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection#update GoogleCloudbuildv2Connection#update}
    */
    readonly update?: string;
}
export declare function googleCloudbuildv2ConnectionTimeoutsToTerraform(struct?: GoogleCloudbuildv2ConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudbuildv2ConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildv2ConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildv2ConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection google_cloudbuildv2_connection}
*/
export declare class GoogleCloudbuildv2Connection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudbuildv2_connection";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudbuildv2_connection google_cloudbuildv2_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudbuildv2ConnectionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudbuildv2ConnectionConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _installationState;
    get installationState(): GoogleCloudbuildv2ConnectionInstallationStateList;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get updateTime(): string;
    private _githubConfig;
    get githubConfig(): GoogleCloudbuildv2ConnectionGithubConfigOutputReference;
    putGithubConfig(value: GoogleCloudbuildv2ConnectionGithubConfig): void;
    resetGithubConfig(): void;
    get githubConfigInput(): GoogleCloudbuildv2ConnectionGithubConfig | undefined;
    private _githubEnterpriseConfig;
    get githubEnterpriseConfig(): GoogleCloudbuildv2ConnectionGithubEnterpriseConfigOutputReference;
    putGithubEnterpriseConfig(value: GoogleCloudbuildv2ConnectionGithubEnterpriseConfig): void;
    resetGithubEnterpriseConfig(): void;
    get githubEnterpriseConfigInput(): GoogleCloudbuildv2ConnectionGithubEnterpriseConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudbuildv2ConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudbuildv2ConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudbuildv2ConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
