import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudfunctions2FunctionIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#cloud_function GoogleCloudfunctions2FunctionIamBinding#cloud_function}
    */
    readonly cloudFunction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#id GoogleCloudfunctions2FunctionIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#location GoogleCloudfunctions2FunctionIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#members GoogleCloudfunctions2FunctionIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#project GoogleCloudfunctions2FunctionIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#role GoogleCloudfunctions2FunctionIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#condition GoogleCloudfunctions2FunctionIamBinding#condition}
    */
    readonly condition?: GoogleCloudfunctions2FunctionIamBindingCondition;
}
export interface GoogleCloudfunctions2FunctionIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#description GoogleCloudfunctions2FunctionIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#expression GoogleCloudfunctions2FunctionIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding#title GoogleCloudfunctions2FunctionIamBinding#title}
    */
    readonly title: string;
}
export declare function googleCloudfunctions2FunctionIamBindingConditionToTerraform(struct?: GoogleCloudfunctions2FunctionIamBindingConditionOutputReference | GoogleCloudfunctions2FunctionIamBindingCondition): any;
export declare class GoogleCloudfunctions2FunctionIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudfunctions2FunctionIamBindingCondition | undefined;
    set internalValue(value: GoogleCloudfunctions2FunctionIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding google_cloudfunctions2_function_iam_binding}
*/
export declare class GoogleCloudfunctions2FunctionIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudfunctions2_function_iam_binding";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudfunctions2_function_iam_binding google_cloudfunctions2_function_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudfunctions2FunctionIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudfunctions2FunctionIamBindingConfig);
    private _cloudFunction?;
    get cloudFunction(): string;
    set cloudFunction(value: string);
    get cloudFunctionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleCloudfunctions2FunctionIamBindingConditionOutputReference;
    putCondition(value: GoogleCloudfunctions2FunctionIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleCloudfunctions2FunctionIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
