import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudiotDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
    * If a device is blocked, connections or requests from this device will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#blocked GoogleCloudiotDevice#blocked}
    */
    readonly blocked?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#id GoogleCloudiotDevice#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The logging verbosity for device activity. Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#log_level GoogleCloudiotDevice#log_level}
    */
    readonly logLevel?: string;
    /**
    * The metadata key-value pairs assigned to the device.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#metadata GoogleCloudiotDevice#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * A unique name for the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#name GoogleCloudiotDevice#name}
    */
    readonly name: string;
    /**
    * The name of the device registry where this device should be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#registry GoogleCloudiotDevice#registry}
    */
    readonly registry: string;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#credentials GoogleCloudiotDevice#credentials}
    */
    readonly credentials?: GoogleCloudiotDeviceCredentials[] | cdktf.IResolvable;
    /**
    * gateway_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#gateway_config GoogleCloudiotDevice#gateway_config}
    */
    readonly gatewayConfig?: GoogleCloudiotDeviceGatewayConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#timeouts GoogleCloudiotDevice#timeouts}
    */
    readonly timeouts?: GoogleCloudiotDeviceTimeouts;
}
export interface GoogleCloudiotDeviceConfigA {
}
export declare function googleCloudiotDeviceConfigAToTerraform(struct?: GoogleCloudiotDeviceConfigA): any;
export declare class GoogleCloudiotDeviceConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudiotDeviceConfigA | undefined;
    set internalValue(value: GoogleCloudiotDeviceConfigA | undefined);
    get binaryData(): string;
    get cloudUpdateTime(): string;
    get deviceAckTime(): string;
    get version(): string;
}
export declare class GoogleCloudiotDeviceConfigAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudiotDeviceConfigAOutputReference;
}
export interface GoogleCloudiotDeviceLastErrorStatus {
}
export declare function googleCloudiotDeviceLastErrorStatusToTerraform(struct?: GoogleCloudiotDeviceLastErrorStatus): any;
export declare class GoogleCloudiotDeviceLastErrorStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudiotDeviceLastErrorStatus | undefined;
    set internalValue(value: GoogleCloudiotDeviceLastErrorStatus | undefined);
    private _details;
    get details(): cdktf.StringMapList;
    get message(): string;
    get number(): number;
}
export declare class GoogleCloudiotDeviceLastErrorStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudiotDeviceLastErrorStatusOutputReference;
}
export interface GoogleCloudiotDeviceState {
}
export declare function googleCloudiotDeviceStateToTerraform(struct?: GoogleCloudiotDeviceState): any;
export declare class GoogleCloudiotDeviceStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudiotDeviceState | undefined;
    set internalValue(value: GoogleCloudiotDeviceState | undefined);
    get binaryData(): string;
    get updateTime(): string;
}
export declare class GoogleCloudiotDeviceStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudiotDeviceStateOutputReference;
}
export interface GoogleCloudiotDeviceCredentialsPublicKey {
    /**
    * The format of the key. Possible values: ["RSA_PEM", "RSA_X509_PEM", "ES256_PEM", "ES256_X509_PEM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#format GoogleCloudiotDevice#format}
    */
    readonly format: string;
    /**
    * The key data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#key GoogleCloudiotDevice#key}
    */
    readonly key: string;
}
export declare function googleCloudiotDeviceCredentialsPublicKeyToTerraform(struct?: GoogleCloudiotDeviceCredentialsPublicKeyOutputReference | GoogleCloudiotDeviceCredentialsPublicKey): any;
export declare class GoogleCloudiotDeviceCredentialsPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudiotDeviceCredentialsPublicKey | undefined;
    set internalValue(value: GoogleCloudiotDeviceCredentialsPublicKey | undefined);
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export interface GoogleCloudiotDeviceCredentials {
    /**
    * The time at which this credential becomes invalid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#expiration_time GoogleCloudiotDevice#expiration_time}
    */
    readonly expirationTime?: string;
    /**
    * public_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#public_key GoogleCloudiotDevice#public_key}
    */
    readonly publicKey: GoogleCloudiotDeviceCredentialsPublicKey;
}
export declare function googleCloudiotDeviceCredentialsToTerraform(struct?: GoogleCloudiotDeviceCredentials | cdktf.IResolvable): any;
export declare class GoogleCloudiotDeviceCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudiotDeviceCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudiotDeviceCredentials | cdktf.IResolvable | undefined);
    private _expirationTime?;
    get expirationTime(): string;
    set expirationTime(value: string);
    resetExpirationTime(): void;
    get expirationTimeInput(): string | undefined;
    private _publicKey;
    get publicKey(): GoogleCloudiotDeviceCredentialsPublicKeyOutputReference;
    putPublicKey(value: GoogleCloudiotDeviceCredentialsPublicKey): void;
    get publicKeyInput(): GoogleCloudiotDeviceCredentialsPublicKey | undefined;
}
export declare class GoogleCloudiotDeviceCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudiotDeviceCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudiotDeviceCredentialsOutputReference;
}
export interface GoogleCloudiotDeviceGatewayConfig {
    /**
    * Indicates whether the device is a gateway. Possible values: ["ASSOCIATION_ONLY", "DEVICE_AUTH_TOKEN_ONLY", "ASSOCIATION_AND_DEVICE_AUTH_TOKEN"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#gateway_auth_method GoogleCloudiotDevice#gateway_auth_method}
    */
    readonly gatewayAuthMethod?: string;
    /**
    * Indicates whether the device is a gateway. Default value: "NON_GATEWAY" Possible values: ["GATEWAY", "NON_GATEWAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#gateway_type GoogleCloudiotDevice#gateway_type}
    */
    readonly gatewayType?: string;
}
export declare function googleCloudiotDeviceGatewayConfigToTerraform(struct?: GoogleCloudiotDeviceGatewayConfigOutputReference | GoogleCloudiotDeviceGatewayConfig): any;
export declare class GoogleCloudiotDeviceGatewayConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudiotDeviceGatewayConfig | undefined;
    set internalValue(value: GoogleCloudiotDeviceGatewayConfig | undefined);
    private _gatewayAuthMethod?;
    get gatewayAuthMethod(): string;
    set gatewayAuthMethod(value: string);
    resetGatewayAuthMethod(): void;
    get gatewayAuthMethodInput(): string | undefined;
    private _gatewayType?;
    get gatewayType(): string;
    set gatewayType(value: string);
    resetGatewayType(): void;
    get gatewayTypeInput(): string | undefined;
    get lastAccessedGatewayId(): string;
    get lastAccessedGatewayTime(): string;
}
export interface GoogleCloudiotDeviceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#create GoogleCloudiotDevice#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#delete GoogleCloudiotDevice#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device#update GoogleCloudiotDevice#update}
    */
    readonly update?: string;
}
export declare function googleCloudiotDeviceTimeoutsToTerraform(struct?: GoogleCloudiotDeviceTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudiotDeviceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudiotDeviceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudiotDeviceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device google_cloudiot_device}
*/
export declare class GoogleCloudiotDevice extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudiot_device";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_device google_cloudiot_device} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudiotDeviceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudiotDeviceConfig);
    private _blocked?;
    get blocked(): boolean | cdktf.IResolvable;
    set blocked(value: boolean | cdktf.IResolvable);
    resetBlocked(): void;
    get blockedInput(): boolean | cdktf.IResolvable | undefined;
    private _config;
    get config(): GoogleCloudiotDeviceConfigAList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastConfigAckTime(): string;
    get lastConfigSendTime(): string;
    private _lastErrorStatus;
    get lastErrorStatus(): GoogleCloudiotDeviceLastErrorStatusList;
    get lastErrorTime(): string;
    get lastEventTime(): string;
    get lastHeartbeatTime(): string;
    get lastStateTime(): string;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get numId(): string;
    private _registry?;
    get registry(): string;
    set registry(value: string);
    get registryInput(): string | undefined;
    private _state;
    get state(): GoogleCloudiotDeviceStateList;
    private _credentials;
    get credentials(): GoogleCloudiotDeviceCredentialsList;
    putCredentials(value: GoogleCloudiotDeviceCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | GoogleCloudiotDeviceCredentials[] | undefined;
    private _gatewayConfig;
    get gatewayConfig(): GoogleCloudiotDeviceGatewayConfigOutputReference;
    putGatewayConfig(value: GoogleCloudiotDeviceGatewayConfig): void;
    resetGatewayConfig(): void;
    get gatewayConfigInput(): GoogleCloudiotDeviceGatewayConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudiotDeviceTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudiotDeviceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudiotDeviceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
