import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudiotRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Activate or deactivate HTTP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#http_config GoogleCloudiotRegistry#http_config}
    */
    readonly httpConfig?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#id GoogleCloudiotRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The default logging verbosity for activity from devices in this
  registry. Specifies which events should be written to logs. For
  example, if the LogLevel is ERROR, only events that terminate in
  errors will be logged. LogLevel is inclusive; enabling INFO logging
  will also enable ERROR logging. Default value: "NONE" Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#log_level GoogleCloudiotRegistry#log_level}
    */
    readonly logLevel?: string;
    /**
    * Activate or deactivate MQTT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#mqtt_config GoogleCloudiotRegistry#mqtt_config}
    */
    readonly mqttConfig?: {
        [key: string]: string;
    };
    /**
    * A unique name for the resource, required by device registry.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#name GoogleCloudiotRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#project GoogleCloudiotRegistry#project}
    */
    readonly project?: string;
    /**
    * The region in which the created registry should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#region GoogleCloudiotRegistry#region}
    */
    readonly region?: string;
    /**
    * A PubSub topic to publish device state updates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#state_notification_config GoogleCloudiotRegistry#state_notification_config}
    */
    readonly stateNotificationConfig?: {
        [key: string]: string;
    };
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#credentials GoogleCloudiotRegistry#credentials}
    */
    readonly credentials?: GoogleCloudiotRegistryCredentials[] | cdktf.IResolvable;
    /**
    * event_notification_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#event_notification_configs GoogleCloudiotRegistry#event_notification_configs}
    */
    readonly eventNotificationConfigs?: GoogleCloudiotRegistryEventNotificationConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#timeouts GoogleCloudiotRegistry#timeouts}
    */
    readonly timeouts?: GoogleCloudiotRegistryTimeouts;
}
export interface GoogleCloudiotRegistryCredentials {
    /**
    * A public key certificate format and data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#public_key_certificate GoogleCloudiotRegistry#public_key_certificate}
    */
    readonly publicKeyCertificate: {
        [key: string]: string;
    };
}
export declare function googleCloudiotRegistryCredentialsToTerraform(struct?: GoogleCloudiotRegistryCredentials | cdktf.IResolvable): any;
export declare class GoogleCloudiotRegistryCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudiotRegistryCredentials | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudiotRegistryCredentials | cdktf.IResolvable | undefined);
    private _publicKeyCertificate?;
    get publicKeyCertificate(): {
        [key: string]: string;
    };
    set publicKeyCertificate(value: {
        [key: string]: string;
    });
    get publicKeyCertificateInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class GoogleCloudiotRegistryCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudiotRegistryCredentials[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudiotRegistryCredentialsOutputReference;
}
export interface GoogleCloudiotRegistryEventNotificationConfigs {
    /**
    * PubSub topic name to publish device events.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#pubsub_topic_name GoogleCloudiotRegistry#pubsub_topic_name}
    */
    readonly pubsubTopicName: string;
    /**
    * If the subfolder name matches this string exactly, this
  configuration will be used. The string must not include the
  leading '/' character. If empty, all strings are matched. Empty
  value can only be used for the last 'event_notification_configs'
  item.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#subfolder_matches GoogleCloudiotRegistry#subfolder_matches}
    */
    readonly subfolderMatches?: string;
}
export declare function googleCloudiotRegistryEventNotificationConfigsToTerraform(struct?: GoogleCloudiotRegistryEventNotificationConfigs | cdktf.IResolvable): any;
export declare class GoogleCloudiotRegistryEventNotificationConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudiotRegistryEventNotificationConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudiotRegistryEventNotificationConfigs | cdktf.IResolvable | undefined);
    private _pubsubTopicName?;
    get pubsubTopicName(): string;
    set pubsubTopicName(value: string);
    get pubsubTopicNameInput(): string | undefined;
    private _subfolderMatches?;
    get subfolderMatches(): string;
    set subfolderMatches(value: string);
    resetSubfolderMatches(): void;
    get subfolderMatchesInput(): string | undefined;
}
export declare class GoogleCloudiotRegistryEventNotificationConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudiotRegistryEventNotificationConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudiotRegistryEventNotificationConfigsOutputReference;
}
export interface GoogleCloudiotRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#create GoogleCloudiotRegistry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#delete GoogleCloudiotRegistry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry#update GoogleCloudiotRegistry#update}
    */
    readonly update?: string;
}
export declare function googleCloudiotRegistryTimeoutsToTerraform(struct?: GoogleCloudiotRegistryTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudiotRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudiotRegistryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudiotRegistryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry google_cloudiot_registry}
*/
export declare class GoogleCloudiotRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudiot_registry";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_cloudiot_registry google_cloudiot_registry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudiotRegistryConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudiotRegistryConfig);
    private _httpConfig?;
    get httpConfig(): {
        [key: string]: string;
    };
    set httpConfig(value: {
        [key: string]: string;
    });
    resetHttpConfig(): void;
    get httpConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _mqttConfig?;
    get mqttConfig(): {
        [key: string]: string;
    };
    set mqttConfig(value: {
        [key: string]: string;
    });
    resetMqttConfig(): void;
    get mqttConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _stateNotificationConfig?;
    get stateNotificationConfig(): {
        [key: string]: string;
    };
    set stateNotificationConfig(value: {
        [key: string]: string;
    });
    resetStateNotificationConfig(): void;
    get stateNotificationConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _credentials;
    get credentials(): GoogleCloudiotRegistryCredentialsList;
    putCredentials(value: GoogleCloudiotRegistryCredentials[] | cdktf.IResolvable): void;
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | GoogleCloudiotRegistryCredentials[] | undefined;
    private _eventNotificationConfigs;
    get eventNotificationConfigs(): GoogleCloudiotRegistryEventNotificationConfigsList;
    putEventNotificationConfigs(value: GoogleCloudiotRegistryEventNotificationConfigs[] | cdktf.IResolvable): void;
    resetEventNotificationConfigs(): void;
    get eventNotificationConfigsInput(): cdktf.IResolvable | GoogleCloudiotRegistryEventNotificationConfigs[] | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudiotRegistryTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudiotRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudiotRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
