import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeAutoscalerConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#description GoogleComputeAutoscaler#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#id GoogleComputeAutoscaler#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. The name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#name GoogleComputeAutoscaler#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#project GoogleComputeAutoscaler#project}
    */
    readonly project?: string;
    /**
    * URL of the managed instance group that this autoscaler will scale.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#target GoogleComputeAutoscaler#target}
    */
    readonly target: string;
    /**
    * URL of the zone where the instance group resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#zone GoogleComputeAutoscaler#zone}
    */
    readonly zone?: string;
    /**
    * autoscaling_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#autoscaling_policy GoogleComputeAutoscaler#autoscaling_policy}
    */
    readonly autoscalingPolicy: GoogleComputeAutoscalerAutoscalingPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#timeouts GoogleComputeAutoscaler#timeouts}
    */
    readonly timeouts?: GoogleComputeAutoscalerTimeouts;
}
export interface GoogleComputeAutoscalerAutoscalingPolicyCpuUtilization {
    /**
    * Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are:
  
  - NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics.
  
  - OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#predictive_method GoogleComputeAutoscaler#predictive_method}
    */
    readonly predictiveMethod?: string;
    /**
    * The target CPU utilization that the autoscaler should maintain.
  Must be a float value in the range (0, 1]. If not specified, the
  default is 0.6.
  
  If the CPU level is below the target utilization, the autoscaler
  scales down the number of instances until it reaches the minimum
  number of instances you specified or until the average CPU of
  your instances reaches the target utilization.
  
  If the average CPU is above the target utilization, the autoscaler
  scales up until it reaches the maximum number of instances you
  specified or until the average utilization reaches the target
  utilization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#target GoogleComputeAutoscaler#target}
    */
    readonly target: number;
}
export declare function googleComputeAutoscalerAutoscalingPolicyCpuUtilizationToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyCpuUtilizationOutputReference | GoogleComputeAutoscalerAutoscalingPolicyCpuUtilization): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyCpuUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicyCpuUtilization | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicyCpuUtilization | undefined);
    private _predictiveMethod?;
    get predictiveMethod(): string;
    set predictiveMethod(value: string);
    resetPredictiveMethod(): void;
    get predictiveMethodInput(): string | undefined;
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
}
export interface GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization {
    /**
    * Fraction of backend capacity utilization (set in HTTP(s) load
  balancing configuration) that autoscaler should maintain. Must
  be a positive float value. If not defined, the default is 0.8.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#target GoogleComputeAutoscaler#target}
    */
    readonly target: number;
}
export declare function googleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference | GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined);
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
}
export interface GoogleComputeAutoscalerAutoscalingPolicyMetric {
    /**
    * A filter string to be used as the filter string for
  a Stackdriver Monitoring TimeSeries.list API call.
  This filter is used to select a specific TimeSeries for
  the purpose of autoscaling and to determine whether the metric
  is exporting per-instance or per-group data.
  
  You can only use the AND operator for joining selectors.
  You can only use direct equality comparison operator (=) without
  any functions for each selector.
  You can specify the metric in both the filter string and in the
  metric field. However, if specified in both places, the metric must
  be identical.
  
  The monitored resource type determines what kind of values are
  expected for the metric. If it is a gce_instance, the autoscaler
  expects the metric to include a separate TimeSeries for each
  instance in a group. In such a case, you cannot filter on resource
  labels.
  
  If the resource type is any other value, the autoscaler expects
  this metric to contain values that apply to the entire autoscaled
  instance group and resource label filtering can be performed to
  point autoscaler at the correct TimeSeries to scale upon.
  This is called a per-group metric for the purpose of autoscaling.
  
  If not specified, the type defaults to gce_instance.
  
  You should provide a filter that is selective enough to pick just
  one TimeSeries for the autoscaled group or for each of the instances
  (if you are using gce_instance resource type). If multiple
  TimeSeries are returned upon the query execution, the autoscaler
  will sum their respective values to obtain its scaling value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#filter GoogleComputeAutoscaler#filter}
    */
    readonly filter?: string;
    /**
    * The identifier (type) of the Stackdriver Monitoring metric.
  The metric cannot have negative values.
  
  The metric must have a value type of INT64 or DOUBLE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#name GoogleComputeAutoscaler#name}
    */
    readonly name: string;
    /**
    * If scaling is based on a per-group metric value that represents the
  total amount of work to be done or resource usage, set this value to
  an amount assigned for a single instance of the scaled group.
  The autoscaler will keep the number of instances proportional to the
  value of this metric, the metric itself should not change value due
  to group resizing.
  
  For example, a good metric to use with the target is
  'pubsub.googleapis.com/subscription/num_undelivered_messages'
  or a custom metric exporting the total number of requests coming to
  your instances.
  
  A bad example would be a metric exporting an average or median
  latency, since this value can't include a chunk assignable to a
  single instance, it could be better used with utilization_target
  instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#single_instance_assignment GoogleComputeAutoscaler#single_instance_assignment}
    */
    readonly singleInstanceAssignment?: number;
    /**
    * The target value of the metric that autoscaler should
  maintain. This must be a positive value. A utilization
  metric scales number of virtual machines handling requests
  to increase or decrease proportionally to the metric.
  
  For example, a good metric to use as a utilizationTarget is
  www.googleapis.com/compute/instance/network/received_bytes_count.
  The autoscaler will work to keep this value constant for each
  of the instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#target GoogleComputeAutoscaler#target}
    */
    readonly target?: number;
    /**
    * Defines how target utilization value is expressed for a
  Stackdriver Monitoring metric. Possible values: ["GAUGE", "DELTA_PER_SECOND", "DELTA_PER_MINUTE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#type GoogleComputeAutoscaler#type}
    */
    readonly type?: string;
}
export declare function googleComputeAutoscalerAutoscalingPolicyMetricToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable | undefined);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _singleInstanceAssignment?;
    get singleInstanceAssignment(): number;
    set singleInstanceAssignment(value: number);
    resetSingleInstanceAssignment(): void;
    get singleInstanceAssignmentInput(): number | undefined;
    private _target?;
    get target(): number;
    set target(value: number);
    resetTarget(): void;
    get targetInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleComputeAutoscalerAutoscalingPolicyMetricList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeAutoscalerAutoscalingPolicyMetricOutputReference;
}
export interface GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas {
    /**
    * Specifies a fixed number of VM instances. This must be a positive
  integer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#fixed GoogleComputeAutoscaler#fixed}
    */
    readonly fixed?: number;
    /**
    * Specifies a percentage of instances between 0 to 100%, inclusive.
  For example, specify 80 for 80%.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#percent GoogleComputeAutoscaler#percent}
    */
    readonly percent?: number;
}
export declare function googleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicasToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicasOutputReference | GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleComputeAutoscalerAutoscalingPolicyScaleDownControl {
    /**
    * How long back autoscaling should look when computing recommendations
  to include directives regarding slower scale down, as described above.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#time_window_sec GoogleComputeAutoscaler#time_window_sec}
    */
    readonly timeWindowSec?: number;
    /**
    * max_scaled_down_replicas block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#max_scaled_down_replicas GoogleComputeAutoscaler#max_scaled_down_replicas}
    */
    readonly maxScaledDownReplicas?: GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas;
}
export declare function googleComputeAutoscalerAutoscalingPolicyScaleDownControlToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlOutputReference | GoogleComputeAutoscalerAutoscalingPolicyScaleDownControl): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicyScaleDownControl | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicyScaleDownControl | undefined);
    private _timeWindowSec?;
    get timeWindowSec(): number;
    set timeWindowSec(value: number);
    resetTimeWindowSec(): void;
    get timeWindowSecInput(): number | undefined;
    private _maxScaledDownReplicas;
    get maxScaledDownReplicas(): GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicasOutputReference;
    putMaxScaledDownReplicas(value: GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas): void;
    resetMaxScaledDownReplicas(): void;
    get maxScaledDownReplicasInput(): GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas | undefined;
}
export interface GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas {
    /**
    * Specifies a fixed number of VM instances. This must be a positive
  integer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#fixed GoogleComputeAutoscaler#fixed}
    */
    readonly fixed?: number;
    /**
    * Specifies a percentage of instances between 0 to 100%, inclusive.
  For example, specify 80 for 80%.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#percent GoogleComputeAutoscaler#percent}
    */
    readonly percent?: number;
}
export declare function googleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference | GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleComputeAutoscalerAutoscalingPolicyScaleInControl {
    /**
    * How long back autoscaling should look when computing recommendations
  to include directives regarding slower scale down, as described above.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#time_window_sec GoogleComputeAutoscaler#time_window_sec}
    */
    readonly timeWindowSec?: number;
    /**
    * max_scaled_in_replicas block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#max_scaled_in_replicas GoogleComputeAutoscaler#max_scaled_in_replicas}
    */
    readonly maxScaledInReplicas?: GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas;
}
export declare function googleComputeAutoscalerAutoscalingPolicyScaleInControlToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyScaleInControlOutputReference | GoogleComputeAutoscalerAutoscalingPolicyScaleInControl): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyScaleInControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicyScaleInControl | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicyScaleInControl | undefined);
    private _timeWindowSec?;
    get timeWindowSec(): number;
    set timeWindowSec(value: number);
    resetTimeWindowSec(): void;
    get timeWindowSecInput(): number | undefined;
    private _maxScaledInReplicas;
    get maxScaledInReplicas(): GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference;
    putMaxScaledInReplicas(value: GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas): void;
    resetMaxScaledInReplicas(): void;
    get maxScaledInReplicasInput(): GoogleComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined;
}
export interface GoogleComputeAutoscalerAutoscalingPolicyScalingSchedules {
    /**
    * A description of a scaling schedule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#description GoogleComputeAutoscaler#description}
    */
    readonly description?: string;
    /**
    * A boolean value that specifies if a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#disabled GoogleComputeAutoscaler#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The duration of time intervals (in seconds) for which this scaling schedule will be running. The minimum allowed value is 300.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#duration_sec GoogleComputeAutoscaler#duration_sec}
    */
    readonly durationSec: number;
    /**
    * Minimum number of VM instances that autoscaler will recommend in time intervals starting according to schedule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#min_required_replicas GoogleComputeAutoscaler#min_required_replicas}
    */
    readonly minRequiredReplicas: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#name GoogleComputeAutoscaler#name}
    */
    readonly name: string;
    /**
    * The start timestamps of time intervals when this scaling schedule should provide a scaling signal. This field uses the extended cron format (with an optional year field).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#schedule GoogleComputeAutoscaler#schedule}
    */
    readonly schedule: string;
    /**
    * The time zone to be used when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#time_zone GoogleComputeAutoscaler#time_zone}
    */
    readonly timeZone?: string;
}
export declare function googleComputeAutoscalerAutoscalingPolicyScalingSchedulesToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyScalingSchedulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _durationSec?;
    get durationSec(): number;
    set durationSec(value: number);
    get durationSecInput(): number | undefined;
    private _minRequiredReplicas?;
    get minRequiredReplicas(): number;
    set minRequiredReplicas(value: number);
    get minRequiredReplicasInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    get scheduleInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
}
export declare class GoogleComputeAutoscalerAutoscalingPolicyScalingSchedulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeAutoscalerAutoscalingPolicyScalingSchedulesOutputReference;
}
export interface GoogleComputeAutoscalerAutoscalingPolicy {
    /**
    * The number of seconds that the autoscaler should wait before it
  starts collecting information from a new instance. This prevents
  the autoscaler from collecting information when the instance is
  initializing, during which the collected usage would not be
  reliable. The default time autoscaler waits is 60 seconds.
  
  Virtual machine initialization times might vary because of
  numerous factors. We recommend that you test how long an
  instance may take to initialize. To do this, create an instance
  and time the startup process.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#cooldown_period GoogleComputeAutoscaler#cooldown_period}
    */
    readonly cooldownPeriod?: number;
    /**
    * The maximum number of instances that the autoscaler can scale up
  to. This is required when creating or updating an autoscaler. The
  maximum number of replicas should not be lower than minimal number
  of replicas.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#max_replicas GoogleComputeAutoscaler#max_replicas}
    */
    readonly maxReplicas: number;
    /**
    * The minimum number of replicas that the autoscaler can scale down
  to. This cannot be less than 0. If not provided, autoscaler will
  choose a default value depending on maximum number of instances
  allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#min_replicas GoogleComputeAutoscaler#min_replicas}
    */
    readonly minReplicas: number;
    /**
    * Defines operating mode for this policy. Default value: "ON" Possible values: ["OFF", "ONLY_UP", "ON"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#mode GoogleComputeAutoscaler#mode}
    */
    readonly mode?: string;
    /**
    * cpu_utilization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#cpu_utilization GoogleComputeAutoscaler#cpu_utilization}
    */
    readonly cpuUtilization?: GoogleComputeAutoscalerAutoscalingPolicyCpuUtilization;
    /**
    * load_balancing_utilization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#load_balancing_utilization GoogleComputeAutoscaler#load_balancing_utilization}
    */
    readonly loadBalancingUtilization?: GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#metric GoogleComputeAutoscaler#metric}
    */
    readonly metric?: GoogleComputeAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable;
    /**
    * scale_down_control block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#scale_down_control GoogleComputeAutoscaler#scale_down_control}
    */
    readonly scaleDownControl?: GoogleComputeAutoscalerAutoscalingPolicyScaleDownControl;
    /**
    * scale_in_control block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#scale_in_control GoogleComputeAutoscaler#scale_in_control}
    */
    readonly scaleInControl?: GoogleComputeAutoscalerAutoscalingPolicyScaleInControl;
    /**
    * scaling_schedules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#scaling_schedules GoogleComputeAutoscaler#scaling_schedules}
    */
    readonly scalingSchedules?: GoogleComputeAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable;
}
export declare function googleComputeAutoscalerAutoscalingPolicyToTerraform(struct?: GoogleComputeAutoscalerAutoscalingPolicyOutputReference | GoogleComputeAutoscalerAutoscalingPolicy): any;
export declare class GoogleComputeAutoscalerAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeAutoscalerAutoscalingPolicy | undefined;
    set internalValue(value: GoogleComputeAutoscalerAutoscalingPolicy | undefined);
    private _cooldownPeriod?;
    get cooldownPeriod(): number;
    set cooldownPeriod(value: number);
    resetCooldownPeriod(): void;
    get cooldownPeriodInput(): number | undefined;
    private _maxReplicas?;
    get maxReplicas(): number;
    set maxReplicas(value: number);
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    get minReplicas(): number;
    set minReplicas(value: number);
    get minReplicasInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _cpuUtilization;
    get cpuUtilization(): GoogleComputeAutoscalerAutoscalingPolicyCpuUtilizationOutputReference;
    putCpuUtilization(value: GoogleComputeAutoscalerAutoscalingPolicyCpuUtilization): void;
    resetCpuUtilization(): void;
    get cpuUtilizationInput(): GoogleComputeAutoscalerAutoscalingPolicyCpuUtilization | undefined;
    private _loadBalancingUtilization;
    get loadBalancingUtilization(): GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference;
    putLoadBalancingUtilization(value: GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization): void;
    resetLoadBalancingUtilization(): void;
    get loadBalancingUtilizationInput(): GoogleComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined;
    private _metric;
    get metric(): GoogleComputeAutoscalerAutoscalingPolicyMetricList;
    putMetric(value: GoogleComputeAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable): void;
    resetMetric(): void;
    get metricInput(): cdktf.IResolvable | GoogleComputeAutoscalerAutoscalingPolicyMetric[] | undefined;
    private _scaleDownControl;
    get scaleDownControl(): GoogleComputeAutoscalerAutoscalingPolicyScaleDownControlOutputReference;
    putScaleDownControl(value: GoogleComputeAutoscalerAutoscalingPolicyScaleDownControl): void;
    resetScaleDownControl(): void;
    get scaleDownControlInput(): GoogleComputeAutoscalerAutoscalingPolicyScaleDownControl | undefined;
    private _scaleInControl;
    get scaleInControl(): GoogleComputeAutoscalerAutoscalingPolicyScaleInControlOutputReference;
    putScaleInControl(value: GoogleComputeAutoscalerAutoscalingPolicyScaleInControl): void;
    resetScaleInControl(): void;
    get scaleInControlInput(): GoogleComputeAutoscalerAutoscalingPolicyScaleInControl | undefined;
    private _scalingSchedules;
    get scalingSchedules(): GoogleComputeAutoscalerAutoscalingPolicyScalingSchedulesList;
    putScalingSchedules(value: GoogleComputeAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable): void;
    resetScalingSchedules(): void;
    get scalingSchedulesInput(): cdktf.IResolvable | GoogleComputeAutoscalerAutoscalingPolicyScalingSchedules[] | undefined;
}
export interface GoogleComputeAutoscalerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#create GoogleComputeAutoscaler#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#delete GoogleComputeAutoscaler#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler#update GoogleComputeAutoscaler#update}
    */
    readonly update?: string;
}
export declare function googleComputeAutoscalerTimeoutsToTerraform(struct?: GoogleComputeAutoscalerTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeAutoscalerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeAutoscalerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeAutoscalerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler google_compute_autoscaler}
*/
export declare class GoogleComputeAutoscaler extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_autoscaler";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_autoscaler google_compute_autoscaler} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeAutoscalerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeAutoscalerConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _autoscalingPolicy;
    get autoscalingPolicy(): GoogleComputeAutoscalerAutoscalingPolicyOutputReference;
    putAutoscalingPolicy(value: GoogleComputeAutoscalerAutoscalingPolicy): void;
    get autoscalingPolicyInput(): GoogleComputeAutoscalerAutoscalingPolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeAutoscalerTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeAutoscalerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeAutoscalerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
