import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeFirewallPolicyAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The target that the firewall policy is attached to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association#attachment_target GoogleComputeFirewallPolicyAssociation#attachment_target}
    */
    readonly attachmentTarget: string;
    /**
    * The firewall policy ID of the association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association#firewall_policy GoogleComputeFirewallPolicyAssociation#firewall_policy}
    */
    readonly firewallPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association#id GoogleComputeFirewallPolicyAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for an association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association#name GoogleComputeFirewallPolicyAssociation#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association#timeouts GoogleComputeFirewallPolicyAssociation#timeouts}
    */
    readonly timeouts?: GoogleComputeFirewallPolicyAssociationTimeouts;
}
export interface GoogleComputeFirewallPolicyAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association#create GoogleComputeFirewallPolicyAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association#delete GoogleComputeFirewallPolicyAssociation#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeFirewallPolicyAssociationTimeoutsToTerraform(struct?: GoogleComputeFirewallPolicyAssociationTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeFirewallPolicyAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeFirewallPolicyAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeFirewallPolicyAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association google_compute_firewall_policy_association}
*/
export declare class GoogleComputeFirewallPolicyAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_firewall_policy_association";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_firewall_policy_association google_compute_firewall_policy_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeFirewallPolicyAssociationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeFirewallPolicyAssociationConfig);
    private _attachmentTarget?;
    get attachmentTarget(): string;
    set attachmentTarget(value: string);
    get attachmentTargetInput(): string | undefined;
    private _firewallPolicy?;
    get firewallPolicy(): string;
    set firewallPolicy(value: string);
    get firewallPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get shortName(): string;
    private _timeouts;
    get timeouts(): GoogleComputeFirewallPolicyAssociationTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeFirewallPolicyAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeFirewallPolicyAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
