import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * This field is used along with the `backend_service` field for internal load balancing or with the `target` field for internal TargetInstance. This field cannot be used with `port` or `portRange` fields. When the load balancing scheme is `INTERNAL` and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#all_ports GoogleComputeForwardingRule#all_ports}
    */
    readonly allPorts?: boolean | cdktf.IResolvable;
    /**
    * This field is used along with the `backend_service` field for internal load balancing or with the `target` field for internal TargetInstance. If the field is set to `TRUE`, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#allow_global_access GoogleComputeForwardingRule#allow_global_access}
    */
    readonly allowGlobalAccess?: boolean | cdktf.IResolvable;
    /**
    * This field is only used for `INTERNAL` load balancing. For internal load balancing, this field identifies the BackendService resource to receive the matched traffic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#backend_service GoogleComputeForwardingRule#backend_service}
    */
    readonly backendService?: string;
    /**
    * An optional description of this resource. Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#description GoogleComputeForwardingRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#id GoogleComputeForwardingRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule. If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address: * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name` * Partial URL or by name, as in: * `projects/project_id/regions/region/addresses/address-name` * `regions/region/addresses/address-name` * `global/addresses/address-name` * `address-name` The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#ip_address GoogleComputeForwardingRule#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The IP protocol to which this rule applies. For protocol forwarding, valid options are `TCP`, `UDP`, `ESP`, `AH`, `SCTP` or `ICMP`. For Internal TCP/UDP Load Balancing, the load balancing scheme is `INTERNAL`, and one of `TCP` or `UDP` are valid. For Traffic Director, the load balancing scheme is `INTERNAL_SELF_MANAGED`, and only `TCP`is valid. For Internal HTTP(S) Load Balancing, the load balancing scheme is `INTERNAL_MANAGED`, and only `TCP` is valid. For HTTP(S), SSL Proxy, and TCP Proxy Load Balancing, the load balancing scheme is `EXTERNAL` and only `TCP` is valid. For Network TCP/UDP Load Balancing, the load balancing scheme is `EXTERNAL`, and one of `TCP` or `UDP` is valid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#ip_protocol GoogleComputeForwardingRule#ip_protocol}
    */
    readonly ipProtocol?: string;
    /**
    * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a `PacketMirroring` rule applies to them. This can only be set to true for load balancers that have their `loadBalancingScheme` set to `INTERNAL`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#is_mirroring_collector GoogleComputeForwardingRule#is_mirroring_collector}
    */
    readonly isMirroringCollector?: boolean | cdktf.IResolvable;
    /**
    * Labels to apply to this rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#labels GoogleComputeForwardingRule#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the forwarding rule type.
  
  *   `EXTERNAL` is used for:
      *   Classic Cloud VPN gateways
      *   Protocol forwarding to VMs from an external IP address
      *   The following load balancers: HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP
  *   `INTERNAL` is used for:
      *   Protocol forwarding to VMs from an internal IP address
      *   Internal TCP/UDP load balancers
  *   `INTERNAL_MANAGED` is used for:
      *   Internal HTTP(S) load balancers
  *   `INTERNAL_SELF_MANAGED` is used for:
      *   Traffic Director
  *   `EXTERNAL_MANAGED` is used for:
      *   Global external HTTP(S) load balancers
  
  For more information about forwarding rules, refer to [Forwarding rule concepts](/load-balancing/docs/forwarding-rule-concepts). Possible values: INVALID, INTERNAL, INTERNAL_MANAGED, INTERNAL_SELF_MANAGED, EXTERNAL, EXTERNAL_MANAGED
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#load_balancing_scheme GoogleComputeForwardingRule#load_balancing_scheme}
    */
    readonly loadBalancingScheme?: string;
    /**
    * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#name GoogleComputeForwardingRule#name}
    */
    readonly name: string;
    /**
    * This field is not used for external load balancing. For `INTERNAL` and `INTERNAL_SELF_MANAGED` load balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#network GoogleComputeForwardingRule#network}
    */
    readonly network?: string;
    /**
    * This signifies the networking tier used for configuring this load balancer and can only take the following values: `PREMIUM`, `STANDARD`. For regional ForwardingRule, the valid values are `PREMIUM` and `STANDARD`. For GlobalForwardingRule, the valid value is `PREMIUM`. If this field is not specified, it is assumed to be `PREMIUM`. If `IPAddress` is specified, this value must be equal to the networkTier of the Address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#network_tier GoogleComputeForwardingRule#network_tier}
    */
    readonly networkTier?: string;
    /**
    * When the load balancing scheme is `EXTERNAL`, `INTERNAL_SELF_MANAGED` and `INTERNAL_MANAGED`, you can specify a `port_range`. Use with a forwarding rule that points to a target proxy or a target pool. Do not use with a forwarding rule that points to a backend service. This field is used along with the `target` field for TargetHttpProxy, TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway, TargetPool, TargetInstance. Applicable only when `IPProtocol` is `TCP`, `UDP`, or `SCTP`, only packets addressed to ports in the specified range will be forwarded to `target`. Forwarding rules with the same `[IPAddress, IPProtocol]` pair must have disjoint port ranges. Some types of forwarding target have constraints on the acceptable ports:
  
  *   TargetHttpProxy: 80, 8080
  *   TargetHttpsProxy: 443
  *   TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
  *   TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
  *   TargetVpnGateway: 500, 4500
  
  @pattern: d+(?:-d+)?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#port_range GoogleComputeForwardingRule#port_range}
    */
    readonly portRange?: string;
    /**
    * This field is used along with the `backend_service` field for internal load balancing. When the load balancing scheme is `INTERNAL`, a list of ports can be configured, for example, ['80'], ['8000','9000']. Only packets addressed to these ports are forwarded to the backends configured with the forwarding rule. If the forwarding rule's loadBalancingScheme is INTERNAL, you can specify ports in one of the following ways: * A list of up to five ports, which can be non-contiguous * Keyword `ALL`, which causes the forwarding rule to forward traffic on any port of the forwarding rule's protocol. @pattern: d+(?:-d+)? For more information, refer to [Port specifications](/load-balancing/docs/forwarding-rule-concepts#port_specifications).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#ports GoogleComputeForwardingRule#ports}
    */
    readonly ports?: string[];
    /**
    * The project this resource belongs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#project GoogleComputeForwardingRule#project}
    */
    readonly project?: string;
    /**
    * The location of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#region GoogleComputeForwardingRule#region}
    */
    readonly region?: string;
    /**
    * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#service_label GoogleComputeForwardingRule#service_label}
    */
    readonly serviceLabel?: string;
    /**
    * This field is only used for `INTERNAL` load balancing. For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule. If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#subnetwork GoogleComputeForwardingRule#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must live in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. For `INTERNAL_SELF_MANAGED` load balancing, only `targetHttpProxy` is valid, not `targetHttpsProxy`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#target GoogleComputeForwardingRule#target}
    */
    readonly target?: string;
    /**
    * service_directory_registrations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#service_directory_registrations GoogleComputeForwardingRule#service_directory_registrations}
    */
    readonly serviceDirectoryRegistrations?: GoogleComputeForwardingRuleServiceDirectoryRegistrations[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#timeouts GoogleComputeForwardingRule#timeouts}
    */
    readonly timeouts?: GoogleComputeForwardingRuleTimeouts;
}
export interface GoogleComputeForwardingRuleServiceDirectoryRegistrations {
    /**
    * Service Directory namespace to register the forwarding rule under.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#namespace GoogleComputeForwardingRule#namespace}
    */
    readonly namespace?: string;
    /**
    * Service Directory service to register the forwarding rule under.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#service GoogleComputeForwardingRule#service}
    */
    readonly service?: string;
}
export declare function googleComputeForwardingRuleServiceDirectoryRegistrationsToTerraform(struct?: GoogleComputeForwardingRuleServiceDirectoryRegistrations | cdktf.IResolvable): any;
export declare class GoogleComputeForwardingRuleServiceDirectoryRegistrationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeForwardingRuleServiceDirectoryRegistrations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeForwardingRuleServiceDirectoryRegistrations | cdktf.IResolvable | undefined);
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export declare class GoogleComputeForwardingRuleServiceDirectoryRegistrationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeForwardingRuleServiceDirectoryRegistrations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeForwardingRuleServiceDirectoryRegistrationsOutputReference;
}
export interface GoogleComputeForwardingRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#create GoogleComputeForwardingRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#delete GoogleComputeForwardingRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule#update GoogleComputeForwardingRule#update}
    */
    readonly update?: string;
}
export declare function googleComputeForwardingRuleTimeoutsToTerraform(struct?: GoogleComputeForwardingRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeForwardingRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeForwardingRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeForwardingRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule google_compute_forwarding_rule}
*/
export declare class GoogleComputeForwardingRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_forwarding_rule";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_forwarding_rule google_compute_forwarding_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeForwardingRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeForwardingRuleConfig);
    private _allPorts?;
    get allPorts(): boolean | cdktf.IResolvable;
    set allPorts(value: boolean | cdktf.IResolvable);
    resetAllPorts(): void;
    get allPortsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowGlobalAccess?;
    get allowGlobalAccess(): boolean | cdktf.IResolvable;
    set allowGlobalAccess(value: boolean | cdktf.IResolvable);
    resetAllowGlobalAccess(): void;
    get allowGlobalAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    resetBackendService(): void;
    get backendServiceInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    resetIpProtocol(): void;
    get ipProtocolInput(): string | undefined;
    private _isMirroringCollector?;
    get isMirroringCollector(): boolean | cdktf.IResolvable;
    set isMirroringCollector(value: boolean | cdktf.IResolvable);
    resetIsMirroringCollector(): void;
    get isMirroringCollectorInput(): boolean | cdktf.IResolvable | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _loadBalancingScheme?;
    get loadBalancingScheme(): string;
    set loadBalancingScheme(value: string);
    resetLoadBalancingScheme(): void;
    get loadBalancingSchemeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    resetPorts(): void;
    get portsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get pscConnectionId(): string;
    get pscConnectionStatus(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _serviceLabel?;
    get serviceLabel(): string;
    set serviceLabel(value: string);
    resetServiceLabel(): void;
    get serviceLabelInput(): string | undefined;
    get serviceName(): string;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _target?;
    get target(): string;
    set target(value: string);
    resetTarget(): void;
    get targetInput(): string | undefined;
    private _serviceDirectoryRegistrations;
    get serviceDirectoryRegistrations(): GoogleComputeForwardingRuleServiceDirectoryRegistrationsList;
    putServiceDirectoryRegistrations(value: GoogleComputeForwardingRuleServiceDirectoryRegistrations[] | cdktf.IResolvable): void;
    resetServiceDirectoryRegistrations(): void;
    get serviceDirectoryRegistrationsInput(): cdktf.IResolvable | GoogleComputeForwardingRuleServiceDirectoryRegistrations[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeForwardingRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeForwardingRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeForwardingRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
