import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeHttpsHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
    * How often (in seconds) to send a health check. The default value is 5
  seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#check_interval_sec GoogleComputeHttpsHealthCheck#check_interval_sec}
    */
    readonly checkIntervalSec?: number;
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#description GoogleComputeHttpsHealthCheck#description}
    */
    readonly description?: string;
    /**
    * A so-far unhealthy instance will be marked healthy after this many
  consecutive successes. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#healthy_threshold GoogleComputeHttpsHealthCheck#healthy_threshold}
    */
    readonly healthyThreshold?: number;
    /**
    * The value of the host header in the HTTPS health check request. If
  left empty (default value), the public IP on behalf of which this
  health check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#host GoogleComputeHttpsHealthCheck#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#id GoogleComputeHttpsHealthCheck#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#name GoogleComputeHttpsHealthCheck#name}
    */
    readonly name: string;
    /**
    * The TCP port number for the HTTPS health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#port GoogleComputeHttpsHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#project GoogleComputeHttpsHealthCheck#project}
    */
    readonly project?: string;
    /**
    * The request path of the HTTPS health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#request_path GoogleComputeHttpsHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * How long (in seconds) to wait before claiming failure.
  The default value is 5 seconds.  It is invalid for timeoutSec to have
  greater value than checkIntervalSec.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#timeout_sec GoogleComputeHttpsHealthCheck#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * A so-far healthy instance will be marked unhealthy after this many
  consecutive failures. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#unhealthy_threshold GoogleComputeHttpsHealthCheck#unhealthy_threshold}
    */
    readonly unhealthyThreshold?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#timeouts GoogleComputeHttpsHealthCheck#timeouts}
    */
    readonly timeouts?: GoogleComputeHttpsHealthCheckTimeouts;
}
export interface GoogleComputeHttpsHealthCheckTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#create GoogleComputeHttpsHealthCheck#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#delete GoogleComputeHttpsHealthCheck#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check#update GoogleComputeHttpsHealthCheck#update}
    */
    readonly update?: string;
}
export declare function googleComputeHttpsHealthCheckTimeoutsToTerraform(struct?: GoogleComputeHttpsHealthCheckTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeHttpsHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHttpsHealthCheckTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeHttpsHealthCheckTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check google_compute_https_health_check}
*/
export declare class GoogleComputeHttpsHealthCheck extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_https_health_check";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_https_health_check google_compute_https_health_check} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeHttpsHealthCheckConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeHttpsHealthCheckConfig);
    private _checkIntervalSec?;
    get checkIntervalSec(): number;
    set checkIntervalSec(value: number);
    resetCheckIntervalSec(): void;
    get checkIntervalSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    get healthyThreshold(): number;
    set healthyThreshold(value: number);
    resetHealthyThreshold(): void;
    get healthyThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    get selfLink(): string;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number;
    set unhealthyThreshold(value: number);
    resetUnhealthyThreshold(): void;
    get unhealthyThresholdInput(): number | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeHttpsHealthCheckTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeHttpsHealthCheckTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeHttpsHealthCheckTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
