import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeInterconnectAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether the VLAN attachment is enabled or disabled.  When using
  PARTNER type this will Pre-Activate the interconnect attachment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#admin_enabled GoogleComputeInterconnectAttachment#admin_enabled}
    */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
    * Provisioned bandwidth capacity for the interconnect attachment.
  For attachments of type DEDICATED, the user can set the bandwidth.
  For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
  Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
  Defaults to BPS_10G Possible values: ["BPS_50M", "BPS_100M", "BPS_200M", "BPS_300M", "BPS_400M", "BPS_500M", "BPS_1G", "BPS_2G", "BPS_5G", "BPS_10G", "BPS_20G", "BPS_50G"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#bandwidth GoogleComputeInterconnectAttachment#bandwidth}
    */
    readonly bandwidth?: string;
    /**
    * Up to 16 candidate prefixes that can be used to restrict the allocation
  of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
  All prefixes must be within link-local address space (169.254.0.0/16)
  and must be /29 or shorter (/28, /27, etc). Google will attempt to select
  an unused /29 from the supplied candidate prefix(es). The request will
  fail if all possible /29s are in use on Google's edge. If not supplied,
  Google will randomly select an unused /29 from all of link-local space.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#candidate_subnets GoogleComputeInterconnectAttachment#candidate_subnets}
    */
    readonly candidateSubnets?: string[];
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#description GoogleComputeInterconnectAttachment#description}
    */
    readonly description?: string;
    /**
    * Desired availability domain for the attachment. Only available for type
  PARTNER, at creation time. For improved reliability, customers should
  configure a pair of attachments with one per availability domain. The
  selected availability domain will be provided to the Partner via the
  pairing key so that the provisioned circuit will lie in the specified
  domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#edge_availability_domain GoogleComputeInterconnectAttachment#edge_availability_domain}
    */
    readonly edgeAvailabilityDomain?: string;
    /**
    * Indicates the user-supplied encryption option of this interconnect
  attachment. Can only be specified at attachment creation for PARTNER or
  DEDICATED attachments.
  
  * NONE - This is the default value, which means that the VLAN attachment
  carries unencrypted traffic. VMs are able to send traffic to, or receive
  traffic from, such a VLAN attachment.
  
  * IPSEC - The VLAN attachment carries only encrypted traffic that is
  encrypted by an IPsec device, such as an HA VPN gateway or third-party
  IPsec VPN. VMs cannot directly send traffic to, or receive traffic from,
  such a VLAN attachment. To use HA VPN over Cloud Interconnect, the VLAN
  attachment must be created with this option. Default value: "NONE" Possible values: ["NONE", "IPSEC"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#encryption GoogleComputeInterconnectAttachment#encryption}
    */
    readonly encryption?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#id GoogleComputeInterconnectAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * URL of the underlying Interconnect object that this attachment's
  traffic will traverse through. Required if type is DEDICATED, must not
  be set if type is PARTNER.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#interconnect GoogleComputeInterconnectAttachment#interconnect}
    */
    readonly interconnect?: string;
    /**
    * URL of addresses that have been reserved for the interconnect attachment,
  Used only for interconnect attachment that has the encryption option as
  IPSEC.
  
  The addresses must be RFC 1918 IP address ranges. When creating HA VPN
  gateway over the interconnect attachment, if the attachment is configured
  to use an RFC 1918 IP address, then the VPN gateway's IP address will be
  allocated from the IP address range specified here.
  
  For example, if the HA VPN gateway's interface 0 is paired to this
  interconnect attachment, then an RFC 1918 IP address for the VPN gateway
  interface 0 will be allocated from the IP address specified for this
  interconnect attachment.
  
  If this field is not specified for interconnect attachment that has
  encryption option as IPSEC, later on when creating HA VPN gateway on this
  interconnect attachment, the HA VPN gateway's IP address will be
  allocated from regional external IP address pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#ipsec_internal_addresses GoogleComputeInterconnectAttachment#ipsec_internal_addresses}
    */
    readonly ipsecInternalAddresses?: string[];
    /**
    * Maximum Transmission Unit (MTU), in bytes, of packets passing through
  this interconnect attachment. Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#mtu GoogleComputeInterconnectAttachment#mtu}
    */
    readonly mtu?: string;
    /**
    * Name of the resource. Provided by the client when the resource is created. The
  name must be 1-63 characters long, and comply with RFC1035. Specifically, the
  name must be 1-63 characters long and match the regular expression
  '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character must be a
  lowercase letter, and all following characters must be a dash, lowercase
  letter, or digit, except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#name GoogleComputeInterconnectAttachment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#project GoogleComputeInterconnectAttachment#project}
    */
    readonly project?: string;
    /**
    * Region where the regional interconnect attachment resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#region GoogleComputeInterconnectAttachment#region}
    */
    readonly region?: string;
    /**
    * URL of the cloud router to be used for dynamic routing. This router must be in
  the same region as this InterconnectAttachment. The InterconnectAttachment will
  automatically connect the Interconnect to the network & region within which the
  Cloud Router is configured.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#router GoogleComputeInterconnectAttachment#router}
    */
    readonly router: string;
    /**
    * The type of InterconnectAttachment you wish to create. Defaults to
  DEDICATED. Possible values: ["DEDICATED", "PARTNER", "PARTNER_PROVIDER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#type GoogleComputeInterconnectAttachment#type}
    */
    readonly type?: string;
    /**
    * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
  using PARTNER type this will be managed upstream.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#vlan_tag8021q GoogleComputeInterconnectAttachment#vlan_tag8021q}
    */
    readonly vlanTag8021Q?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#timeouts GoogleComputeInterconnectAttachment#timeouts}
    */
    readonly timeouts?: GoogleComputeInterconnectAttachmentTimeouts;
}
export interface GoogleComputeInterconnectAttachmentPrivateInterconnectInfo {
}
export declare function googleComputeInterconnectAttachmentPrivateInterconnectInfoToTerraform(struct?: GoogleComputeInterconnectAttachmentPrivateInterconnectInfo): any;
export declare class GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeInterconnectAttachmentPrivateInterconnectInfo | undefined;
    set internalValue(value: GoogleComputeInterconnectAttachmentPrivateInterconnectInfo | undefined);
    get tag8021Q(): number;
}
export declare class GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference;
}
export interface GoogleComputeInterconnectAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#create GoogleComputeInterconnectAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#delete GoogleComputeInterconnectAttachment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment#update GoogleComputeInterconnectAttachment#update}
    */
    readonly update?: string;
}
export declare function googleComputeInterconnectAttachmentTimeoutsToTerraform(struct?: GoogleComputeInterconnectAttachmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeInterconnectAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInterconnectAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInterconnectAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment google_compute_interconnect_attachment}
*/
export declare class GoogleComputeInterconnectAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_interconnect_attachment";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_interconnect_attachment google_compute_interconnect_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeInterconnectAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeInterconnectAttachmentConfig);
    private _adminEnabled?;
    get adminEnabled(): boolean | cdktf.IResolvable;
    set adminEnabled(value: boolean | cdktf.IResolvable);
    resetAdminEnabled(): void;
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _bandwidth?;
    get bandwidth(): string;
    set bandwidth(value: string);
    resetBandwidth(): void;
    get bandwidthInput(): string | undefined;
    private _candidateSubnets?;
    get candidateSubnets(): string[];
    set candidateSubnets(value: string[]);
    resetCandidateSubnets(): void;
    get candidateSubnetsInput(): string[] | undefined;
    get cloudRouterIpAddress(): string;
    get creationTimestamp(): string;
    get customerRouterIpAddress(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _edgeAvailabilityDomain?;
    get edgeAvailabilityDomain(): string;
    set edgeAvailabilityDomain(value: string);
    resetEdgeAvailabilityDomain(): void;
    get edgeAvailabilityDomainInput(): string | undefined;
    private _encryption?;
    get encryption(): string;
    set encryption(value: string);
    resetEncryption(): void;
    get encryptionInput(): string | undefined;
    get googleReferenceId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interconnect?;
    get interconnect(): string;
    set interconnect(value: string);
    resetInterconnect(): void;
    get interconnectInput(): string | undefined;
    private _ipsecInternalAddresses?;
    get ipsecInternalAddresses(): string[];
    set ipsecInternalAddresses(value: string[]);
    resetIpsecInternalAddresses(): void;
    get ipsecInternalAddressesInput(): string[] | undefined;
    private _mtu?;
    get mtu(): string;
    set mtu(value: string);
    resetMtu(): void;
    get mtuInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pairingKey(): string;
    get partnerAsn(): string;
    private _privateInterconnectInfo;
    get privateInterconnectInfo(): GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    get routerInput(): string | undefined;
    get selfLink(): string;
    get state(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _vlanTag8021Q?;
    get vlanTag8021Q(): number;
    set vlanTag8021Q(value: number);
    resetVlanTag8021Q(): void;
    get vlanTag8021QInput(): number | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeInterconnectAttachmentTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeInterconnectAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeInterconnectAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
