import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether to export the custom routes to the peer network. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#export_custom_routes GoogleComputeNetworkPeering#export_custom_routes}
    */
    readonly exportCustomRoutes?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#export_subnet_routes_with_public_ip GoogleComputeNetworkPeering#export_subnet_routes_with_public_ip}
    */
    readonly exportSubnetRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#id GoogleComputeNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether to export the custom routes from the peer network. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#import_custom_routes GoogleComputeNetworkPeering#import_custom_routes}
    */
    readonly importCustomRoutes?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#import_subnet_routes_with_public_ip GoogleComputeNetworkPeering#import_subnet_routes_with_public_ip}
    */
    readonly importSubnetRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Name of the peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#name GoogleComputeNetworkPeering#name}
    */
    readonly name: string;
    /**
    * The primary network of the peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#network GoogleComputeNetworkPeering#network}
    */
    readonly network: string;
    /**
    * The peer network in the peering. The peer network may belong to a different project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#peer_network GoogleComputeNetworkPeering#peer_network}
    */
    readonly peerNetwork: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#timeouts GoogleComputeNetworkPeering#timeouts}
    */
    readonly timeouts?: GoogleComputeNetworkPeeringTimeouts;
}
export interface GoogleComputeNetworkPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#create GoogleComputeNetworkPeering#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#delete GoogleComputeNetworkPeering#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering#update GoogleComputeNetworkPeering#update}
    */
    readonly update?: string;
}
export declare function googleComputeNetworkPeeringTimeoutsToTerraform(struct?: GoogleComputeNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNetworkPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeNetworkPeeringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering google_compute_network_peering}
*/
export declare class GoogleComputeNetworkPeering extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_peering";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_network_peering google_compute_network_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeNetworkPeeringConfig);
    private _exportCustomRoutes?;
    get exportCustomRoutes(): boolean | cdktf.IResolvable;
    set exportCustomRoutes(value: boolean | cdktf.IResolvable);
    resetExportCustomRoutes(): void;
    get exportCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _exportSubnetRoutesWithPublicIp?;
    get exportSubnetRoutesWithPublicIp(): boolean | cdktf.IResolvable;
    set exportSubnetRoutesWithPublicIp(value: boolean | cdktf.IResolvable);
    resetExportSubnetRoutesWithPublicIp(): void;
    get exportSubnetRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importCustomRoutes?;
    get importCustomRoutes(): boolean | cdktf.IResolvable;
    set importCustomRoutes(value: boolean | cdktf.IResolvable);
    resetImportCustomRoutes(): void;
    get importCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _importSubnetRoutesWithPublicIp?;
    get importSubnetRoutesWithPublicIp(): boolean | cdktf.IResolvable;
    set importSubnetRoutesWithPublicIp(value: boolean | cdktf.IResolvable);
    resetImportSubnetRoutesWithPublicIp(): void;
    get importSubnetRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _peerNetwork?;
    get peerNetwork(): string;
    set peerNetwork(value: string);
    get peerNetworkInput(): string | undefined;
    get state(): string;
    get stateDetails(): string;
    private _timeouts;
    get timeouts(): GoogleComputeNetworkPeeringTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeNetworkPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeNetworkPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
