import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeNodeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional textual description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#description GoogleComputeNodeGroup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#id GoogleComputeNodeGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The initial number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#initial_size GoogleComputeNodeGroup#initial_size}
    */
    readonly initialSize?: number;
    /**
    * Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#maintenance_policy GoogleComputeNodeGroup#maintenance_policy}
    */
    readonly maintenancePolicy?: string;
    /**
    * Name of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#name GoogleComputeNodeGroup#name}
    */
    readonly name?: string;
    /**
    * The URL of the node template to which this node group belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#node_template GoogleComputeNodeGroup#node_template}
    */
    readonly nodeTemplate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#project GoogleComputeNodeGroup#project}
    */
    readonly project?: string;
    /**
    * The total number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#size GoogleComputeNodeGroup#size}
    */
    readonly size?: number;
    /**
    * Zone where this node group is located
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#zone GoogleComputeNodeGroup#zone}
    */
    readonly zone?: string;
    /**
    * autoscaling_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#autoscaling_policy GoogleComputeNodeGroup#autoscaling_policy}
    */
    readonly autoscalingPolicy?: GoogleComputeNodeGroupAutoscalingPolicy;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#maintenance_window GoogleComputeNodeGroup#maintenance_window}
    */
    readonly maintenanceWindow?: GoogleComputeNodeGroupMaintenanceWindow;
    /**
    * share_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#share_settings GoogleComputeNodeGroup#share_settings}
    */
    readonly shareSettings?: GoogleComputeNodeGroupShareSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#timeouts GoogleComputeNodeGroup#timeouts}
    */
    readonly timeouts?: GoogleComputeNodeGroupTimeouts;
}
export interface GoogleComputeNodeGroupAutoscalingPolicy {
    /**
    * Maximum size of the node group. Set to a value less than or equal
  to 100 and greater than or equal to min-nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#max_nodes GoogleComputeNodeGroup#max_nodes}
    */
    readonly maxNodes?: number;
    /**
    * Minimum size of the node group. Must be less
  than or equal to max-nodes. The default value is 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#min_nodes GoogleComputeNodeGroup#min_nodes}
    */
    readonly minNodes?: number;
    /**
    * The autoscaling mode. Set to one of the following:
    - OFF: Disables the autoscaler.
    - ON: Enables scaling in and scaling out.
    - ONLY_SCALE_OUT: Enables only scaling out.
    You must use this mode if your node groups are configured to
    restart their hosted VMs on minimal servers. Possible values: ["OFF", "ON", "ONLY_SCALE_OUT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#mode GoogleComputeNodeGroup#mode}
    */
    readonly mode?: string;
}
export declare function googleComputeNodeGroupAutoscalingPolicyToTerraform(struct?: GoogleComputeNodeGroupAutoscalingPolicyOutputReference | GoogleComputeNodeGroupAutoscalingPolicy): any;
export declare class GoogleComputeNodeGroupAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNodeGroupAutoscalingPolicy | undefined;
    set internalValue(value: GoogleComputeNodeGroupAutoscalingPolicy | undefined);
    private _maxNodes?;
    get maxNodes(): number;
    set maxNodes(value: number);
    resetMaxNodes(): void;
    get maxNodesInput(): number | undefined;
    private _minNodes?;
    get minNodes(): number;
    set minNodes(value: number);
    resetMinNodes(): void;
    get minNodesInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
}
export interface GoogleComputeNodeGroupMaintenanceWindow {
    /**
    * instances.start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#start_time GoogleComputeNodeGroup#start_time}
    */
    readonly startTime: string;
}
export declare function googleComputeNodeGroupMaintenanceWindowToTerraform(struct?: GoogleComputeNodeGroupMaintenanceWindowOutputReference | GoogleComputeNodeGroupMaintenanceWindow): any;
export declare class GoogleComputeNodeGroupMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNodeGroupMaintenanceWindow | undefined;
    set internalValue(value: GoogleComputeNodeGroupMaintenanceWindow | undefined);
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface GoogleComputeNodeGroupShareSettingsProjectMap {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#id GoogleComputeNodeGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * The project id/number should be the same as the key of this project config in the project map.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#project_id GoogleComputeNodeGroup#project_id}
    */
    readonly projectId: string;
}
export declare function googleComputeNodeGroupShareSettingsProjectMapToTerraform(struct?: GoogleComputeNodeGroupShareSettingsProjectMap | cdktf.IResolvable): any;
export declare class GoogleComputeNodeGroupShareSettingsProjectMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeNodeGroupShareSettingsProjectMap | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeNodeGroupShareSettingsProjectMap | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export declare class GoogleComputeNodeGroupShareSettingsProjectMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeNodeGroupShareSettingsProjectMap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeNodeGroupShareSettingsProjectMapOutputReference;
}
export interface GoogleComputeNodeGroupShareSettings {
    /**
    * Node group sharing type. Possible values: ["ORGANIZATION", "SPECIFIC_PROJECTS", "LOCAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#share_type GoogleComputeNodeGroup#share_type}
    */
    readonly shareType: string;
    /**
    * project_map block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#project_map GoogleComputeNodeGroup#project_map}
    */
    readonly projectMap?: GoogleComputeNodeGroupShareSettingsProjectMap[] | cdktf.IResolvable;
}
export declare function googleComputeNodeGroupShareSettingsToTerraform(struct?: GoogleComputeNodeGroupShareSettingsOutputReference | GoogleComputeNodeGroupShareSettings): any;
export declare class GoogleComputeNodeGroupShareSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNodeGroupShareSettings | undefined;
    set internalValue(value: GoogleComputeNodeGroupShareSettings | undefined);
    private _shareType?;
    get shareType(): string;
    set shareType(value: string);
    get shareTypeInput(): string | undefined;
    private _projectMap;
    get projectMap(): GoogleComputeNodeGroupShareSettingsProjectMapList;
    putProjectMap(value: GoogleComputeNodeGroupShareSettingsProjectMap[] | cdktf.IResolvable): void;
    resetProjectMap(): void;
    get projectMapInput(): cdktf.IResolvable | GoogleComputeNodeGroupShareSettingsProjectMap[] | undefined;
}
export interface GoogleComputeNodeGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#create GoogleComputeNodeGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#delete GoogleComputeNodeGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group#update GoogleComputeNodeGroup#update}
    */
    readonly update?: string;
}
export declare function googleComputeNodeGroupTimeoutsToTerraform(struct?: GoogleComputeNodeGroupTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeNodeGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNodeGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeNodeGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group google_compute_node_group}
*/
export declare class GoogleComputeNodeGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_node_group";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_group google_compute_node_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeNodeGroupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeNodeGroupConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialSize?;
    get initialSize(): number;
    set initialSize(value: number);
    resetInitialSize(): void;
    get initialSizeInput(): number | undefined;
    private _maintenancePolicy?;
    get maintenancePolicy(): string;
    set maintenancePolicy(value: string);
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodeTemplate?;
    get nodeTemplate(): string;
    set nodeTemplate(value: string);
    get nodeTemplateInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _autoscalingPolicy;
    get autoscalingPolicy(): GoogleComputeNodeGroupAutoscalingPolicyOutputReference;
    putAutoscalingPolicy(value: GoogleComputeNodeGroupAutoscalingPolicy): void;
    resetAutoscalingPolicy(): void;
    get autoscalingPolicyInput(): GoogleComputeNodeGroupAutoscalingPolicy | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): GoogleComputeNodeGroupMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: GoogleComputeNodeGroupMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): GoogleComputeNodeGroupMaintenanceWindow | undefined;
    private _shareSettings;
    get shareSettings(): GoogleComputeNodeGroupShareSettingsOutputReference;
    putShareSettings(value: GoogleComputeNodeGroupShareSettings): void;
    resetShareSettings(): void;
    get shareSettingsInput(): GoogleComputeNodeGroupShareSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeNodeGroupTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeNodeGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeNodeGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
