import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeNodeTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * CPU overcommit. Default value: "NONE" Possible values: ["ENABLED", "NONE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#cpu_overcommit_type GoogleComputeNodeTemplate#cpu_overcommit_type}
    */
    readonly cpuOvercommitType?: string;
    /**
    * An optional textual description of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#description GoogleComputeNodeTemplate#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#id GoogleComputeNodeTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#name GoogleComputeNodeTemplate#name}
    */
    readonly name?: string;
    /**
    * Labels to use for node affinity, which will be used in
  instance scheduling.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#node_affinity_labels GoogleComputeNodeTemplate#node_affinity_labels}
    */
    readonly nodeAffinityLabels?: {
        [key: string]: string;
    };
    /**
    * Node type to use for nodes group that are created from this template.
  Only one of nodeTypeFlexibility and nodeType can be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#node_type GoogleComputeNodeTemplate#node_type}
    */
    readonly nodeType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#project GoogleComputeNodeTemplate#project}
    */
    readonly project?: string;
    /**
    * Region where nodes using the node template will be created.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#region GoogleComputeNodeTemplate#region}
    */
    readonly region?: string;
    /**
    * node_type_flexibility block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#node_type_flexibility GoogleComputeNodeTemplate#node_type_flexibility}
    */
    readonly nodeTypeFlexibility?: GoogleComputeNodeTemplateNodeTypeFlexibility;
    /**
    * server_binding block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#server_binding GoogleComputeNodeTemplate#server_binding}
    */
    readonly serverBinding?: GoogleComputeNodeTemplateServerBinding;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#timeouts GoogleComputeNodeTemplate#timeouts}
    */
    readonly timeouts?: GoogleComputeNodeTemplateTimeouts;
}
export interface GoogleComputeNodeTemplateNodeTypeFlexibility {
    /**
    * Number of virtual CPUs to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#cpus GoogleComputeNodeTemplate#cpus}
    */
    readonly cpus?: string;
    /**
    * Physical memory available to the node, defined in MB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#memory GoogleComputeNodeTemplate#memory}
    */
    readonly memory?: string;
}
export declare function googleComputeNodeTemplateNodeTypeFlexibilityToTerraform(struct?: GoogleComputeNodeTemplateNodeTypeFlexibilityOutputReference | GoogleComputeNodeTemplateNodeTypeFlexibility): any;
export declare class GoogleComputeNodeTemplateNodeTypeFlexibilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNodeTemplateNodeTypeFlexibility | undefined;
    set internalValue(value: GoogleComputeNodeTemplateNodeTypeFlexibility | undefined);
    private _cpus?;
    get cpus(): string;
    set cpus(value: string);
    resetCpus(): void;
    get cpusInput(): string | undefined;
    get localSsd(): string;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface GoogleComputeNodeTemplateServerBinding {
    /**
    * Type of server binding policy. If 'RESTART_NODE_ON_ANY_SERVER',
  nodes using this template will restart on any physical server
  following a maintenance event.
  
  If 'RESTART_NODE_ON_MINIMAL_SERVER', nodes using this template
  will restart on the same physical server following a maintenance
  event, instead of being live migrated to or restarted on a new
  physical server. This option may be useful if you are using
  software licenses tied to the underlying server characteristics
  such as physical sockets or cores, to avoid the need for
  additional licenses when maintenance occurs. However, VMs on such
  nodes will experience outages while maintenance is applied. Possible values: ["RESTART_NODE_ON_ANY_SERVER", "RESTART_NODE_ON_MINIMAL_SERVERS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#type GoogleComputeNodeTemplate#type}
    */
    readonly type: string;
}
export declare function googleComputeNodeTemplateServerBindingToTerraform(struct?: GoogleComputeNodeTemplateServerBindingOutputReference | GoogleComputeNodeTemplateServerBinding): any;
export declare class GoogleComputeNodeTemplateServerBindingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNodeTemplateServerBinding | undefined;
    set internalValue(value: GoogleComputeNodeTemplateServerBinding | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleComputeNodeTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#create GoogleComputeNodeTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template#delete GoogleComputeNodeTemplate#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeNodeTemplateTimeoutsToTerraform(struct?: GoogleComputeNodeTemplateTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeNodeTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNodeTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeNodeTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template google_compute_node_template}
*/
export declare class GoogleComputeNodeTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_node_template";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_node_template google_compute_node_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeNodeTemplateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleComputeNodeTemplateConfig);
    private _cpuOvercommitType?;
    get cpuOvercommitType(): string;
    set cpuOvercommitType(value: string);
    resetCpuOvercommitType(): void;
    get cpuOvercommitTypeInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodeAffinityLabels?;
    get nodeAffinityLabels(): {
        [key: string]: string;
    };
    set nodeAffinityLabels(value: {
        [key: string]: string;
    });
    resetNodeAffinityLabels(): void;
    get nodeAffinityLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodeType?;
    get nodeType(): string;
    set nodeType(value: string);
    resetNodeType(): void;
    get nodeTypeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _nodeTypeFlexibility;
    get nodeTypeFlexibility(): GoogleComputeNodeTemplateNodeTypeFlexibilityOutputReference;
    putNodeTypeFlexibility(value: GoogleComputeNodeTemplateNodeTypeFlexibility): void;
    resetNodeTypeFlexibility(): void;
    get nodeTypeFlexibilityInput(): GoogleComputeNodeTemplateNodeTypeFlexibility | undefined;
    private _serverBinding;
    get serverBinding(): GoogleComputeNodeTemplateServerBindingOutputReference;
    putServerBinding(value: GoogleComputeNodeTemplateServerBinding): void;
    resetServerBinding(): void;
    get serverBindingInput(): GoogleComputeNodeTemplateServerBinding | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeNodeTemplateTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeNodeTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeNodeTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
