import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionPerInstanceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#id GoogleComputeRegionPerInstanceConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The minimal action to perform on the instance during an update.
  Default is 'NONE'. Possible values are:
  * REPLACE
  * RESTART
  * REFRESH
  * NONE
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#minimal_action GoogleComputeRegionPerInstanceConfig#minimal_action}
    */
    readonly minimalAction?: string;
    /**
    * The most disruptive action to perform on the instance during an update.
  Default is 'REPLACE'. Possible values are:
  * REPLACE
  * RESTART
  * REFRESH
  * NONE
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#most_disruptive_allowed_action GoogleComputeRegionPerInstanceConfig#most_disruptive_allowed_action}
    */
    readonly mostDisruptiveAllowedAction?: string;
    /**
    * The name for this per-instance config and its corresponding instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#name GoogleComputeRegionPerInstanceConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#project GoogleComputeRegionPerInstanceConfig#project}
    */
    readonly project?: string;
    /**
    * Region where the containing instance group manager is located
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#region GoogleComputeRegionPerInstanceConfig#region}
    */
    readonly region?: string;
    /**
    * The region instance group manager this instance config is part of.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#region_instance_group_manager GoogleComputeRegionPerInstanceConfig#region_instance_group_manager}
    */
    readonly regionInstanceGroupManager: string;
    /**
    * When true, deleting this config will immediately remove any specified state from the underlying instance.
  When false, deleting this config will *not* immediately remove any state from the underlying instance.
  State will be removed on the next instance recreation or update.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#remove_instance_state_on_destroy GoogleComputeRegionPerInstanceConfig#remove_instance_state_on_destroy}
    */
    readonly removeInstanceStateOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * preserved_state block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#preserved_state GoogleComputeRegionPerInstanceConfig#preserved_state}
    */
    readonly preservedState?: GoogleComputeRegionPerInstanceConfigPreservedState;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#timeouts GoogleComputeRegionPerInstanceConfig#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionPerInstanceConfigTimeouts;
}
export interface GoogleComputeRegionPerInstanceConfigPreservedStateDisk {
    /**
    * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
  The available options are 'NEVER' and 'ON_PERMANENT_INSTANCE_DELETION'.
  'NEVER' - detach the disk when the VM is deleted, but do not delete the disk.
  'ON_PERMANENT_INSTANCE_DELETION' will delete the stateful disk when the VM is permanently
  deleted from the instance group. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#delete_rule GoogleComputeRegionPerInstanceConfig#delete_rule}
    */
    readonly deleteRule?: string;
    /**
    * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#device_name GoogleComputeRegionPerInstanceConfig#device_name}
    */
    readonly deviceName: string;
    /**
    * The mode of the disk. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#mode GoogleComputeRegionPerInstanceConfig#mode}
    */
    readonly mode?: string;
    /**
    * The URI of an existing persistent disk to attach under the specified device-name in the format
  'projects/project-id/zones/zone/disks/disk-name'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#source GoogleComputeRegionPerInstanceConfig#source}
    */
    readonly source: string;
}
export declare function googleComputeRegionPerInstanceConfigPreservedStateDiskToTerraform(struct?: GoogleComputeRegionPerInstanceConfigPreservedStateDisk | cdktf.IResolvable): any;
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionPerInstanceConfigPreservedStateDisk | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionPerInstanceConfigPreservedStateDisk | cdktf.IResolvable | undefined);
    private _deleteRule?;
    get deleteRule(): string;
    set deleteRule(value: string);
    resetDeleteRule(): void;
    get deleteRuleInput(): string | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    get deviceNameInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
}
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionPerInstanceConfigPreservedStateDiskOutputReference;
}
export interface GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddress {
    /**
    * The URL of the reservation for this IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#address GoogleComputeRegionPerInstanceConfig#address}
    */
    readonly address?: string;
}
export declare function googleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddressToTerraform(struct?: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddressOutputReference | GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddress): any;
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddress | undefined;
    set internalValue(value: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddress | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
}
export interface GoogleComputeRegionPerInstanceConfigPreservedStateExternalIp {
    /**
    * These stateful IPs will never be released during autohealing, update or VM instance recreate operations. This flag is used to configure if the IP reservation should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#auto_delete GoogleComputeRegionPerInstanceConfig#auto_delete}
    */
    readonly autoDelete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#interface_name GoogleComputeRegionPerInstanceConfig#interface_name}
    */
    readonly interfaceName: string;
    /**
    * ip_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#ip_address GoogleComputeRegionPerInstanceConfig#ip_address}
    */
    readonly ipAddress?: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddress;
}
export declare function googleComputeRegionPerInstanceConfigPreservedStateExternalIpToTerraform(struct?: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIp | cdktf.IResolvable): any;
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionPerInstanceConfigPreservedStateExternalIp | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIp | cdktf.IResolvable | undefined);
    private _autoDelete?;
    get autoDelete(): string;
    set autoDelete(value: string);
    resetAutoDelete(): void;
    get autoDeleteInput(): string | undefined;
    private _interfaceName?;
    get interfaceName(): string;
    set interfaceName(value: string);
    get interfaceNameInput(): string | undefined;
    private _ipAddress;
    get ipAddress(): GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddressOutputReference;
    putIpAddress(value: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddress): void;
    resetIpAddress(): void;
    get ipAddressInput(): GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpIpAddress | undefined;
}
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpOutputReference;
}
export interface GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddress {
    /**
    * The URL of the reservation for this IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#address GoogleComputeRegionPerInstanceConfig#address}
    */
    readonly address?: string;
}
export declare function googleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddressToTerraform(struct?: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddressOutputReference | GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddress): any;
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddress | undefined;
    set internalValue(value: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddress | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
}
export interface GoogleComputeRegionPerInstanceConfigPreservedStateInternalIp {
    /**
    * These stateful IPs will never be released during autohealing, update or VM instance recreate operations. This flag is used to configure if the IP reservation should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#auto_delete GoogleComputeRegionPerInstanceConfig#auto_delete}
    */
    readonly autoDelete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#interface_name GoogleComputeRegionPerInstanceConfig#interface_name}
    */
    readonly interfaceName: string;
    /**
    * ip_address block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#ip_address GoogleComputeRegionPerInstanceConfig#ip_address}
    */
    readonly ipAddress?: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddress;
}
export declare function googleComputeRegionPerInstanceConfigPreservedStateInternalIpToTerraform(struct?: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIp | cdktf.IResolvable): any;
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionPerInstanceConfigPreservedStateInternalIp | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIp | cdktf.IResolvable | undefined);
    private _autoDelete?;
    get autoDelete(): string;
    set autoDelete(value: string);
    resetAutoDelete(): void;
    get autoDeleteInput(): string | undefined;
    private _interfaceName?;
    get interfaceName(): string;
    set interfaceName(value: string);
    get interfaceNameInput(): string | undefined;
    private _ipAddress;
    get ipAddress(): GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddressOutputReference;
    putIpAddress(value: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddress): void;
    resetIpAddress(): void;
    get ipAddressInput(): GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpIpAddress | undefined;
}
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpOutputReference;
}
export interface GoogleComputeRegionPerInstanceConfigPreservedState {
    /**
    * Preserved metadata defined for this instance. This is a list of key->value pairs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#metadata GoogleComputeRegionPerInstanceConfig#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#disk GoogleComputeRegionPerInstanceConfig#disk}
    */
    readonly disk?: GoogleComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable;
    /**
    * external_ip block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#external_ip GoogleComputeRegionPerInstanceConfig#external_ip}
    */
    readonly externalIp?: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIp[] | cdktf.IResolvable;
    /**
    * internal_ip block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#internal_ip GoogleComputeRegionPerInstanceConfig#internal_ip}
    */
    readonly internalIp?: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIp[] | cdktf.IResolvable;
}
export declare function googleComputeRegionPerInstanceConfigPreservedStateToTerraform(struct?: GoogleComputeRegionPerInstanceConfigPreservedStateOutputReference | GoogleComputeRegionPerInstanceConfigPreservedState): any;
export declare class GoogleComputeRegionPerInstanceConfigPreservedStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionPerInstanceConfigPreservedState | undefined;
    set internalValue(value: GoogleComputeRegionPerInstanceConfigPreservedState | undefined);
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _disk;
    get disk(): GoogleComputeRegionPerInstanceConfigPreservedStateDiskList;
    putDisk(value: GoogleComputeRegionPerInstanceConfigPreservedStateDisk[] | cdktf.IResolvable): void;
    resetDisk(): void;
    get diskInput(): cdktf.IResolvable | GoogleComputeRegionPerInstanceConfigPreservedStateDisk[] | undefined;
    private _externalIp;
    get externalIp(): GoogleComputeRegionPerInstanceConfigPreservedStateExternalIpList;
    putExternalIp(value: GoogleComputeRegionPerInstanceConfigPreservedStateExternalIp[] | cdktf.IResolvable): void;
    resetExternalIp(): void;
    get externalIpInput(): cdktf.IResolvable | GoogleComputeRegionPerInstanceConfigPreservedStateExternalIp[] | undefined;
    private _internalIp;
    get internalIp(): GoogleComputeRegionPerInstanceConfigPreservedStateInternalIpList;
    putInternalIp(value: GoogleComputeRegionPerInstanceConfigPreservedStateInternalIp[] | cdktf.IResolvable): void;
    resetInternalIp(): void;
    get internalIpInput(): cdktf.IResolvable | GoogleComputeRegionPerInstanceConfigPreservedStateInternalIp[] | undefined;
}
export interface GoogleComputeRegionPerInstanceConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#create GoogleComputeRegionPerInstanceConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#delete GoogleComputeRegionPerInstanceConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config#update GoogleComputeRegionPerInstanceConfig#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionPerInstanceConfigTimeoutsToTerraform(struct?: GoogleComputeRegionPerInstanceConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionPerInstanceConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionPerInstanceConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionPerInstanceConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config google_compute_region_per_instance_config}
*/
export declare class GoogleComputeRegionPerInstanceConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_per_instance_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_region_per_instance_config google_compute_region_per_instance_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionPerInstanceConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionPerInstanceConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _minimalAction?;
    get minimalAction(): string;
    set minimalAction(value: string);
    resetMinimalAction(): void;
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    get mostDisruptiveAllowedAction(): string;
    set mostDisruptiveAllowedAction(value: string);
    resetMostDisruptiveAllowedAction(): void;
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _regionInstanceGroupManager?;
    get regionInstanceGroupManager(): string;
    set regionInstanceGroupManager(value: string);
    get regionInstanceGroupManagerInput(): string | undefined;
    private _removeInstanceStateOnDestroy?;
    get removeInstanceStateOnDestroy(): boolean | cdktf.IResolvable;
    set removeInstanceStateOnDestroy(value: boolean | cdktf.IResolvable);
    resetRemoveInstanceStateOnDestroy(): void;
    get removeInstanceStateOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _preservedState;
    get preservedState(): GoogleComputeRegionPerInstanceConfigPreservedStateOutputReference;
    putPreservedState(value: GoogleComputeRegionPerInstanceConfigPreservedState): void;
    resetPreservedState(): void;
    get preservedStateInput(): GoogleComputeRegionPerInstanceConfigPreservedState | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionPerInstanceConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionPerInstanceConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionPerInstanceConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
