import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeSubnetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
  you create the resource. This field can be set only at resource
  creation time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#description GoogleComputeSubnetwork#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#id GoogleComputeSubnetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The range of internal addresses that are owned by this subnetwork.
  Provide this property when you create the subnetwork. For example,
  10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
  non-overlapping within a network. Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#ip_cidr_range GoogleComputeSubnetwork#ip_cidr_range}
    */
    readonly ipCidrRange: string;
    /**
    * The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
  or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
  cannot enable direct path. Possible values: ["EXTERNAL", "INTERNAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#ipv6_access_type GoogleComputeSubnetwork#ipv6_access_type}
    */
    readonly ipv6AccessType?: string;
    /**
    * The name of the resource, provided by the client when initially
  creating the resource. The name must be 1-63 characters long, and
  comply with RFC1035. Specifically, the name must be 1-63 characters
  long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
  means the first character must be a lowercase letter, and all
  following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#name GoogleComputeSubnetwork#name}
    */
    readonly name: string;
    /**
    * The network this subnet belongs to.
  Only networks that are in the distributed mode can have subnetworks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#network GoogleComputeSubnetwork#network}
    */
    readonly network: string;
    /**
    * When enabled, VMs in this subnetwork without external IP addresses can
  access Google APIs and services by using Private Google Access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#private_ip_google_access GoogleComputeSubnetwork#private_ip_google_access}
    */
    readonly privateIpGoogleAccess?: boolean | cdktf.IResolvable;
    /**
    * The private IPv6 google access type for the VMs in this subnet.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#private_ipv6_google_access GoogleComputeSubnetwork#private_ipv6_google_access}
    */
    readonly privateIpv6GoogleAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#project GoogleComputeSubnetwork#project}
    */
    readonly project?: string;
    /**
    * The purpose of the resource. This field can be either 'PRIVATE_RFC_1918', 'INTERNAL_HTTPS_LOAD_BALANCER' or 'REGIONAL_MANAGED_PROXY'.
  A subnetwork with purpose set to 'INTERNAL_HTTPS_LOAD_BALANCER' is a user-created subnetwork that is reserved for Internal HTTP(S) Load Balancing.
  A subnetwork in a given region with purpose set to 'REGIONAL_MANAGED_PROXY' is a proxy-only subnet and is shared between all the regional Envoy-based load balancers.
  If unspecified, the purpose defaults to 'PRIVATE_RFC_1918'.
  The enableFlowLogs field isn't supported with the purpose field set to 'INTERNAL_HTTPS_LOAD_BALANCER'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#purpose GoogleComputeSubnetwork#purpose}
    */
    readonly purpose?: string;
    /**
    * The GCP region for this subnetwork.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#region GoogleComputeSubnetwork#region}
    */
    readonly region?: string;
    /**
    * The role of subnetwork.
  The value can be set to 'ACTIVE' or 'BACKUP'.
  An 'ACTIVE' subnetwork is one that is currently being used.
  A 'BACKUP' subnetwork is one that is ready to be promoted to 'ACTIVE' or is currently draining.
  
  Subnetwork role must be specified when purpose is set to 'INTERNAL_HTTPS_LOAD_BALANCER' or 'REGIONAL_MANAGED_PROXY'. Possible values: ["ACTIVE", "BACKUP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#role GoogleComputeSubnetwork#role}
    */
    readonly role?: string;
    /**
    * An array of configurations for secondary IP ranges for VM instances
  contained in this subnetwork. The primary IP of such VM must belong
  to the primary ipCidrRange of the subnetwork. The alias IPs may belong
  to either primary or secondary ranges.
  
  **Note**: This field uses [attr-as-block mode](https://www.terraform.io/docs/configuration/attr-as-blocks.html) to avoid
  breaking users during the 0.12 upgrade. To explicitly send a list
  of zero objects you must use the following syntax:
  'example=[]'
  For more details about this behavior, see [this section](https://www.terraform.io/docs/configuration/attr-as-blocks.html#defining-a-fixed-object-collection-value).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#secondary_ip_range GoogleComputeSubnetwork#secondary_ip_range}
    */
    readonly secondaryIpRange?: GoogleComputeSubnetworkSecondaryIpRange[] | cdktf.IResolvable;
    /**
    * The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
  If not specified IPV4_ONLY will be used. Possible values: ["IPV4_ONLY", "IPV4_IPV6"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#stack_type GoogleComputeSubnetwork#stack_type}
    */
    readonly stackType?: string;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#log_config GoogleComputeSubnetwork#log_config}
    */
    readonly logConfig?: GoogleComputeSubnetworkLogConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#timeouts GoogleComputeSubnetwork#timeouts}
    */
    readonly timeouts?: GoogleComputeSubnetworkTimeouts;
}
export interface GoogleComputeSubnetworkSecondaryIpRange {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#ip_cidr_range GoogleComputeSubnetwork#ip_cidr_range}
    */
    readonly ipCidrRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#range_name GoogleComputeSubnetwork#range_name}
    */
    readonly rangeName?: string;
}
export declare function googleComputeSubnetworkSecondaryIpRangeToTerraform(struct?: GoogleComputeSubnetworkSecondaryIpRange | cdktf.IResolvable): any;
export declare class GoogleComputeSubnetworkSecondaryIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeSubnetworkSecondaryIpRange | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSubnetworkSecondaryIpRange | cdktf.IResolvable | undefined);
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    resetIpCidrRange(): void;
    get ipCidrRangeInput(): string | undefined;
    private _rangeName?;
    get rangeName(): string;
    set rangeName(value: string);
    resetRangeName(): void;
    get rangeNameInput(): string | undefined;
}
export declare class GoogleComputeSubnetworkSecondaryIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeSubnetworkSecondaryIpRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeSubnetworkSecondaryIpRangeOutputReference;
}
export interface GoogleComputeSubnetworkLogConfig {
    /**
    * Can only be specified if VPC flow logging for this subnetwork is enabled.
  Toggles the aggregation interval for collecting flow logs. Increasing the
  interval time will reduce the amount of generated flow logs for long
  lasting connections. Default is an interval of 5 seconds per connection. Default value: "INTERVAL_5_SEC" Possible values: ["INTERVAL_5_SEC", "INTERVAL_30_SEC", "INTERVAL_1_MIN", "INTERVAL_5_MIN", "INTERVAL_10_MIN", "INTERVAL_15_MIN"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#aggregation_interval GoogleComputeSubnetwork#aggregation_interval}
    */
    readonly aggregationInterval?: string;
    /**
    * Export filter used to define which VPC flow logs should be logged, as as CEL expression. See
  https://cloud.google.com/vpc/docs/flow-logs#filtering for details on how to format this field.
  The default value is 'true', which evaluates to include everything.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#filter_expr GoogleComputeSubnetwork#filter_expr}
    */
    readonly filterExpr?: string;
    /**
    * Can only be specified if VPC flow logging for this subnetwork is enabled.
  The value of the field must be in [0, 1]. Set the sampling rate of VPC
  flow logs within the subnetwork where 1.0 means all collected logs are
  reported and 0.0 means no logs are reported. Default is 0.5 which means
  half of all collected logs are reported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#flow_sampling GoogleComputeSubnetwork#flow_sampling}
    */
    readonly flowSampling?: number;
    /**
    * Can only be specified if VPC flow logging for this subnetwork is enabled.
  Configures whether metadata fields should be added to the reported VPC
  flow logs. Default value: "INCLUDE_ALL_METADATA" Possible values: ["EXCLUDE_ALL_METADATA", "INCLUDE_ALL_METADATA", "CUSTOM_METADATA"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#metadata GoogleComputeSubnetwork#metadata}
    */
    readonly metadata?: string;
    /**
    * List of metadata fields that should be added to reported logs.
  Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" is set to CUSTOM_METADATA.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#metadata_fields GoogleComputeSubnetwork#metadata_fields}
    */
    readonly metadataFields?: string[];
}
export declare function googleComputeSubnetworkLogConfigToTerraform(struct?: GoogleComputeSubnetworkLogConfigOutputReference | GoogleComputeSubnetworkLogConfig): any;
export declare class GoogleComputeSubnetworkLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSubnetworkLogConfig | undefined;
    set internalValue(value: GoogleComputeSubnetworkLogConfig | undefined);
    private _aggregationInterval?;
    get aggregationInterval(): string;
    set aggregationInterval(value: string);
    resetAggregationInterval(): void;
    get aggregationIntervalInput(): string | undefined;
    private _filterExpr?;
    get filterExpr(): string;
    set filterExpr(value: string);
    resetFilterExpr(): void;
    get filterExprInput(): string | undefined;
    private _flowSampling?;
    get flowSampling(): number;
    set flowSampling(value: number);
    resetFlowSampling(): void;
    get flowSamplingInput(): number | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _metadataFields?;
    get metadataFields(): string[];
    set metadataFields(value: string[]);
    resetMetadataFields(): void;
    get metadataFieldsInput(): string[] | undefined;
}
export interface GoogleComputeSubnetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#create GoogleComputeSubnetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#delete GoogleComputeSubnetwork#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork#update GoogleComputeSubnetwork#update}
    */
    readonly update?: string;
}
export declare function googleComputeSubnetworkTimeoutsToTerraform(struct?: GoogleComputeSubnetworkTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeSubnetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeSubnetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeSubnetworkTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork google_compute_subnetwork}
*/
export declare class GoogleComputeSubnetwork extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_subnetwork";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_subnetwork google_compute_subnetwork} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeSubnetworkConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeSubnetworkConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get externalIpv6Prefix(): string;
    get fingerprint(): string;
    get gatewayAddress(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    get ipCidrRangeInput(): string | undefined;
    private _ipv6AccessType?;
    get ipv6AccessType(): string;
    set ipv6AccessType(value: string);
    resetIpv6AccessType(): void;
    get ipv6AccessTypeInput(): string | undefined;
    get ipv6CidrRange(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _privateIpGoogleAccess?;
    get privateIpGoogleAccess(): boolean | cdktf.IResolvable;
    set privateIpGoogleAccess(value: boolean | cdktf.IResolvable);
    resetPrivateIpGoogleAccess(): void;
    get privateIpGoogleAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string;
    set privateIpv6GoogleAccess(value: string);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _purpose?;
    get purpose(): string;
    set purpose(value: string);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _secondaryIpRange;
    get secondaryIpRange(): GoogleComputeSubnetworkSecondaryIpRangeList;
    putSecondaryIpRange(value: GoogleComputeSubnetworkSecondaryIpRange[] | cdktf.IResolvable): void;
    resetSecondaryIpRange(): void;
    get secondaryIpRangeInput(): cdktf.IResolvable | GoogleComputeSubnetworkSecondaryIpRange[] | undefined;
    get selfLink(): string;
    private _stackType?;
    get stackType(): string;
    set stackType(value: string);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _logConfig;
    get logConfig(): GoogleComputeSubnetworkLogConfigOutputReference;
    putLogConfig(value: GoogleComputeSubnetworkLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): GoogleComputeSubnetworkLogConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeSubnetworkTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeSubnetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeSubnetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
