import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeVpnTunnelConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#description GoogleComputeVpnTunnel#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#id GoogleComputeVpnTunnel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * IKE protocol version to use when establishing the VPN tunnel with
  peer VPN gateway.
  Acceptable IKE versions are 1 or 2. Default version is 2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#ike_version GoogleComputeVpnTunnel#ike_version}
    */
    readonly ikeVersion?: number;
    /**
    * Labels to apply to this VpnTunnel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#labels GoogleComputeVpnTunnel#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Local traffic selector to use when establishing the VPN tunnel with
  peer VPN gateway. The value should be a CIDR formatted string,
  for example '192.168.0.0/16'. The ranges should be disjoint.
  Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#local_traffic_selector GoogleComputeVpnTunnel#local_traffic_selector}
    */
    readonly localTrafficSelector?: string[];
    /**
    * Name of the resource. The name must be 1-63 characters long, and
  comply with RFC1035. Specifically, the name must be 1-63
  characters long and match the regular expression
  '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character
  must be a lowercase letter, and all following characters must
  be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#name GoogleComputeVpnTunnel#name}
    */
    readonly name: string;
    /**
    * URL of the peer side external VPN gateway to which this VPN tunnel is connected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#peer_external_gateway GoogleComputeVpnTunnel#peer_external_gateway}
    */
    readonly peerExternalGateway?: string;
    /**
    * The interface ID of the external VPN gateway to which this VPN tunnel is connected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#peer_external_gateway_interface GoogleComputeVpnTunnel#peer_external_gateway_interface}
    */
    readonly peerExternalGatewayInterface?: number;
    /**
    * URL of the peer side HA GCP VPN gateway to which this VPN tunnel is connected.
  If provided, the VPN tunnel will automatically use the same vpn_gateway_interface
  ID in the peer GCP VPN gateway.
  This field must reference a 'google_compute_ha_vpn_gateway' resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#peer_gcp_gateway GoogleComputeVpnTunnel#peer_gcp_gateway}
    */
    readonly peerGcpGateway?: string;
    /**
    * IP address of the peer VPN gateway. Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#peer_ip GoogleComputeVpnTunnel#peer_ip}
    */
    readonly peerIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#project GoogleComputeVpnTunnel#project}
    */
    readonly project?: string;
    /**
    * The region where the tunnel is located. If unset, is set to the region of 'target_vpn_gateway'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#region GoogleComputeVpnTunnel#region}
    */
    readonly region?: string;
    /**
    * Remote traffic selector to use when establishing the VPN tunnel with
  peer VPN gateway. The value should be a CIDR formatted string,
  for example '192.168.0.0/16'. The ranges should be disjoint.
  Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#remote_traffic_selector GoogleComputeVpnTunnel#remote_traffic_selector}
    */
    readonly remoteTrafficSelector?: string[];
    /**
    * URL of router resource to be used for dynamic routing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#router GoogleComputeVpnTunnel#router}
    */
    readonly router?: string;
    /**
    * Shared secret used to set the secure session between the Cloud VPN
  gateway and the peer VPN gateway.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#shared_secret GoogleComputeVpnTunnel#shared_secret}
    */
    readonly sharedSecret: string;
    /**
    * URL of the Target VPN gateway with which this VPN tunnel is
  associated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#target_vpn_gateway GoogleComputeVpnTunnel#target_vpn_gateway}
    */
    readonly targetVpnGateway?: string;
    /**
    * URL of the VPN gateway with which this VPN tunnel is associated.
  This must be used if a High Availability VPN gateway resource is created.
  This field must reference a 'google_compute_ha_vpn_gateway' resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#vpn_gateway GoogleComputeVpnTunnel#vpn_gateway}
    */
    readonly vpnGateway?: string;
    /**
    * The interface ID of the VPN gateway with which this VPN tunnel is associated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#vpn_gateway_interface GoogleComputeVpnTunnel#vpn_gateway_interface}
    */
    readonly vpnGatewayInterface?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#timeouts GoogleComputeVpnTunnel#timeouts}
    */
    readonly timeouts?: GoogleComputeVpnTunnelTimeouts;
}
export interface GoogleComputeVpnTunnelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#create GoogleComputeVpnTunnel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#delete GoogleComputeVpnTunnel#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel#update GoogleComputeVpnTunnel#update}
    */
    readonly update?: string;
}
export declare function googleComputeVpnTunnelTimeoutsToTerraform(struct?: GoogleComputeVpnTunnelTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeVpnTunnelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeVpnTunnelTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeVpnTunnelTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel google_compute_vpn_tunnel}
*/
export declare class GoogleComputeVpnTunnel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_vpn_tunnel";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_compute_vpn_tunnel google_compute_vpn_tunnel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeVpnTunnelConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeVpnTunnelConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get detailedStatus(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ikeVersion?;
    get ikeVersion(): number;
    set ikeVersion(value: number);
    resetIkeVersion(): void;
    get ikeVersionInput(): number | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _localTrafficSelector?;
    get localTrafficSelector(): string[];
    set localTrafficSelector(value: string[]);
    resetLocalTrafficSelector(): void;
    get localTrafficSelectorInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerExternalGateway?;
    get peerExternalGateway(): string;
    set peerExternalGateway(value: string);
    resetPeerExternalGateway(): void;
    get peerExternalGatewayInput(): string | undefined;
    private _peerExternalGatewayInterface?;
    get peerExternalGatewayInterface(): number;
    set peerExternalGatewayInterface(value: number);
    resetPeerExternalGatewayInterface(): void;
    get peerExternalGatewayInterfaceInput(): number | undefined;
    private _peerGcpGateway?;
    get peerGcpGateway(): string;
    set peerGcpGateway(value: string);
    resetPeerGcpGateway(): void;
    get peerGcpGatewayInput(): string | undefined;
    private _peerIp?;
    get peerIp(): string;
    set peerIp(value: string);
    resetPeerIp(): void;
    get peerIpInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _remoteTrafficSelector?;
    get remoteTrafficSelector(): string[];
    set remoteTrafficSelector(value: string[]);
    resetRemoteTrafficSelector(): void;
    get remoteTrafficSelectorInput(): string[] | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    resetRouter(): void;
    get routerInput(): string | undefined;
    get selfLink(): string;
    private _sharedSecret?;
    get sharedSecret(): string;
    set sharedSecret(value: string);
    get sharedSecretInput(): string | undefined;
    get sharedSecretHash(): string;
    private _targetVpnGateway?;
    get targetVpnGateway(): string;
    set targetVpnGateway(value: string);
    resetTargetVpnGateway(): void;
    get targetVpnGatewayInput(): string | undefined;
    get tunnelId(): string;
    private _vpnGateway?;
    get vpnGateway(): string;
    set vpnGateway(value: string);
    resetVpnGateway(): void;
    get vpnGatewayInput(): string | undefined;
    private _vpnGatewayInterface?;
    get vpnGatewayInterface(): number;
    set vpnGatewayInterface(value: number);
    resetVpnGatewayInterface(): void;
    get vpnGatewayInterfaceInput(): number | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeVpnTunnelTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeVpnTunnelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeVpnTunnelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
