import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerAttachedClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the cluster. This field has the same
  restrictions as Kubernetes annotations. The total size of all keys and
  values combined is limited to 256k. Key can have 2 segments: prefix (optional)
  and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
  Name must be 63 characters or less, begin and end with alphanumerics,
  with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#annotations GoogleContainerAttachedCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Policy to determine what flags to send on delete.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#deletion_policy GoogleContainerAttachedCluster#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * A human readable description of this attached cluster. Cannot be longer
  than 255 UTF-8 encoded bytes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#description GoogleContainerAttachedCluster#description}
    */
    readonly description?: string;
    /**
    * The Kubernetes distribution of the underlying attached cluster. Supported values:
  "eks", "aks".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#distribution GoogleContainerAttachedCluster#distribution}
    */
    readonly distribution: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#id GoogleContainerAttachedCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#location GoogleContainerAttachedCluster#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#name GoogleContainerAttachedCluster#name}
    */
    readonly name: string;
    /**
    * The platform version for the cluster (e.g. '1.23.0-gke.1').
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#platform_version GoogleContainerAttachedCluster#platform_version}
    */
    readonly platformVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#project GoogleContainerAttachedCluster#project}
    */
    readonly project?: string;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#authorization GoogleContainerAttachedCluster#authorization}
    */
    readonly authorization?: GoogleContainerAttachedClusterAuthorization;
    /**
    * fleet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#fleet GoogleContainerAttachedCluster#fleet}
    */
    readonly fleet: GoogleContainerAttachedClusterFleet;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#logging_config GoogleContainerAttachedCluster#logging_config}
    */
    readonly loggingConfig?: GoogleContainerAttachedClusterLoggingConfig;
    /**
    * monitoring_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#monitoring_config GoogleContainerAttachedCluster#monitoring_config}
    */
    readonly monitoringConfig?: GoogleContainerAttachedClusterMonitoringConfig;
    /**
    * oidc_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#oidc_config GoogleContainerAttachedCluster#oidc_config}
    */
    readonly oidcConfig: GoogleContainerAttachedClusterOidcConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#timeouts GoogleContainerAttachedCluster#timeouts}
    */
    readonly timeouts?: GoogleContainerAttachedClusterTimeouts;
}
export interface GoogleContainerAttachedClusterErrors {
}
export declare function googleContainerAttachedClusterErrorsToTerraform(struct?: GoogleContainerAttachedClusterErrors): any;
export declare class GoogleContainerAttachedClusterErrorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAttachedClusterErrors | undefined;
    set internalValue(value: GoogleContainerAttachedClusterErrors | undefined);
    get message(): string;
}
export declare class GoogleContainerAttachedClusterErrorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAttachedClusterErrorsOutputReference;
}
export interface GoogleContainerAttachedClusterWorkloadIdentityConfig {
}
export declare function googleContainerAttachedClusterWorkloadIdentityConfigToTerraform(struct?: GoogleContainerAttachedClusterWorkloadIdentityConfig): any;
export declare class GoogleContainerAttachedClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAttachedClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: GoogleContainerAttachedClusterWorkloadIdentityConfig | undefined);
    get identityProvider(): string;
    get issuerUri(): string;
    get workloadPool(): string;
}
export declare class GoogleContainerAttachedClusterWorkloadIdentityConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAttachedClusterWorkloadIdentityConfigOutputReference;
}
export interface GoogleContainerAttachedClusterAuthorization {
    /**
    * Users that can perform operations as a cluster admin. A managed
  ClusterRoleBinding will be created to grant the 'cluster-admin' ClusterRole
  to the users. Up to ten admin users can be provided.
  
  For more info on RBAC, see
  https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#admin_users GoogleContainerAttachedCluster#admin_users}
    */
    readonly adminUsers?: string[];
}
export declare function googleContainerAttachedClusterAuthorizationToTerraform(struct?: GoogleContainerAttachedClusterAuthorizationOutputReference | GoogleContainerAttachedClusterAuthorization): any;
export declare class GoogleContainerAttachedClusterAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAttachedClusterAuthorization | undefined;
    set internalValue(value: GoogleContainerAttachedClusterAuthorization | undefined);
    private _adminUsers?;
    get adminUsers(): string[];
    set adminUsers(value: string[]);
    resetAdminUsers(): void;
    get adminUsersInput(): string[] | undefined;
}
export interface GoogleContainerAttachedClusterFleet {
    /**
    * The number of the Fleet host project where this cluster will be registered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#project GoogleContainerAttachedCluster#project}
    */
    readonly project: string;
}
export declare function googleContainerAttachedClusterFleetToTerraform(struct?: GoogleContainerAttachedClusterFleetOutputReference | GoogleContainerAttachedClusterFleet): any;
export declare class GoogleContainerAttachedClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAttachedClusterFleet | undefined;
    set internalValue(value: GoogleContainerAttachedClusterFleet | undefined);
    get membership(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
}
export interface GoogleContainerAttachedClusterLoggingConfigComponentConfig {
    /**
    * The components to be enabled. Possible values: ["SYSTEM_COMPONENTS", "WORKLOADS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#enable_components GoogleContainerAttachedCluster#enable_components}
    */
    readonly enableComponents?: string[];
}
export declare function googleContainerAttachedClusterLoggingConfigComponentConfigToTerraform(struct?: GoogleContainerAttachedClusterLoggingConfigComponentConfigOutputReference | GoogleContainerAttachedClusterLoggingConfigComponentConfig): any;
export declare class GoogleContainerAttachedClusterLoggingConfigComponentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAttachedClusterLoggingConfigComponentConfig | undefined;
    set internalValue(value: GoogleContainerAttachedClusterLoggingConfigComponentConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    resetEnableComponents(): void;
    get enableComponentsInput(): string[] | undefined;
}
export interface GoogleContainerAttachedClusterLoggingConfig {
    /**
    * component_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#component_config GoogleContainerAttachedCluster#component_config}
    */
    readonly componentConfig?: GoogleContainerAttachedClusterLoggingConfigComponentConfig;
}
export declare function googleContainerAttachedClusterLoggingConfigToTerraform(struct?: GoogleContainerAttachedClusterLoggingConfigOutputReference | GoogleContainerAttachedClusterLoggingConfig): any;
export declare class GoogleContainerAttachedClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAttachedClusterLoggingConfig | undefined;
    set internalValue(value: GoogleContainerAttachedClusterLoggingConfig | undefined);
    private _componentConfig;
    get componentConfig(): GoogleContainerAttachedClusterLoggingConfigComponentConfigOutputReference;
    putComponentConfig(value: GoogleContainerAttachedClusterLoggingConfigComponentConfig): void;
    resetComponentConfig(): void;
    get componentConfigInput(): GoogleContainerAttachedClusterLoggingConfigComponentConfig | undefined;
}
export interface GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfig {
    /**
    * Enable Managed Collection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#enabled GoogleContainerAttachedCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleContainerAttachedClusterMonitoringConfigManagedPrometheusConfigToTerraform(struct?: GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfigOutputReference | GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfig): any;
export declare class GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfig | undefined;
    set internalValue(value: GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleContainerAttachedClusterMonitoringConfig {
    /**
    * managed_prometheus_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#managed_prometheus_config GoogleContainerAttachedCluster#managed_prometheus_config}
    */
    readonly managedPrometheusConfig?: GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfig;
}
export declare function googleContainerAttachedClusterMonitoringConfigToTerraform(struct?: GoogleContainerAttachedClusterMonitoringConfigOutputReference | GoogleContainerAttachedClusterMonitoringConfig): any;
export declare class GoogleContainerAttachedClusterMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAttachedClusterMonitoringConfig | undefined;
    set internalValue(value: GoogleContainerAttachedClusterMonitoringConfig | undefined);
    private _managedPrometheusConfig;
    get managedPrometheusConfig(): GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfigOutputReference;
    putManagedPrometheusConfig(value: GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfig): void;
    resetManagedPrometheusConfig(): void;
    get managedPrometheusConfigInput(): GoogleContainerAttachedClusterMonitoringConfigManagedPrometheusConfig | undefined;
}
export interface GoogleContainerAttachedClusterOidcConfig {
    /**
    * A JSON Web Token (JWT) issuer URI. 'issuer' must start with 'https://'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#issuer_url GoogleContainerAttachedCluster#issuer_url}
    */
    readonly issuerUrl: string;
    /**
    * OIDC verification keys in JWKS format (RFC 7517).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#jwks GoogleContainerAttachedCluster#jwks}
    */
    readonly jwks?: string;
}
export declare function googleContainerAttachedClusterOidcConfigToTerraform(struct?: GoogleContainerAttachedClusterOidcConfigOutputReference | GoogleContainerAttachedClusterOidcConfig): any;
export declare class GoogleContainerAttachedClusterOidcConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAttachedClusterOidcConfig | undefined;
    set internalValue(value: GoogleContainerAttachedClusterOidcConfig | undefined);
    private _issuerUrl?;
    get issuerUrl(): string;
    set issuerUrl(value: string);
    get issuerUrlInput(): string | undefined;
    private _jwks?;
    get jwks(): string;
    set jwks(value: string);
    resetJwks(): void;
    get jwksInput(): string | undefined;
}
export interface GoogleContainerAttachedClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#create GoogleContainerAttachedCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#delete GoogleContainerAttachedCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster#update GoogleContainerAttachedCluster#update}
    */
    readonly update?: string;
}
export declare function googleContainerAttachedClusterTimeoutsToTerraform(struct?: GoogleContainerAttachedClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerAttachedClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAttachedClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAttachedClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster google_container_attached_cluster}
*/
export declare class GoogleContainerAttachedCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_attached_cluster";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_attached_cluster google_container_attached_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerAttachedClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerAttachedClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get clusterRegion(): string;
    get createTime(): string;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _distribution?;
    get distribution(): string;
    set distribution(value: string);
    get distributionInput(): string | undefined;
    private _errors;
    get errors(): GoogleContainerAttachedClusterErrorsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kubernetesVersion(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _platformVersion?;
    get platformVersion(): string;
    set platformVersion(value: string);
    get platformVersionInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): GoogleContainerAttachedClusterWorkloadIdentityConfigList;
    private _authorization;
    get authorization(): GoogleContainerAttachedClusterAuthorizationOutputReference;
    putAuthorization(value: GoogleContainerAttachedClusterAuthorization): void;
    resetAuthorization(): void;
    get authorizationInput(): GoogleContainerAttachedClusterAuthorization | undefined;
    private _fleet;
    get fleet(): GoogleContainerAttachedClusterFleetOutputReference;
    putFleet(value: GoogleContainerAttachedClusterFleet): void;
    get fleetInput(): GoogleContainerAttachedClusterFleet | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleContainerAttachedClusterLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleContainerAttachedClusterLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleContainerAttachedClusterLoggingConfig | undefined;
    private _monitoringConfig;
    get monitoringConfig(): GoogleContainerAttachedClusterMonitoringConfigOutputReference;
    putMonitoringConfig(value: GoogleContainerAttachedClusterMonitoringConfig): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): GoogleContainerAttachedClusterMonitoringConfig | undefined;
    private _oidcConfig;
    get oidcConfig(): GoogleContainerAttachedClusterOidcConfigOutputReference;
    putOidcConfig(value: GoogleContainerAttachedClusterOidcConfig): void;
    get oidcConfigInput(): GoogleContainerAttachedClusterOidcConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerAttachedClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerAttachedClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerAttachedClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
