import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerAwsClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#annotations GoogleContainerAwsCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#aws_region GoogleContainerAwsCluster#aws_region}
    */
    readonly awsRegion: string;
    /**
    * Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#description GoogleContainerAwsCluster#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#id GoogleContainerAwsCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#location GoogleContainerAwsCluster#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#name GoogleContainerAwsCluster#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#project GoogleContainerAwsCluster#project}
    */
    readonly project?: string;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#authorization GoogleContainerAwsCluster#authorization}
    */
    readonly authorization: GoogleContainerAwsClusterAuthorization;
    /**
    * control_plane block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#control_plane GoogleContainerAwsCluster#control_plane}
    */
    readonly controlPlane: GoogleContainerAwsClusterControlPlane;
    /**
    * fleet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#fleet GoogleContainerAwsCluster#fleet}
    */
    readonly fleet: GoogleContainerAwsClusterFleet;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#logging_config GoogleContainerAwsCluster#logging_config}
    */
    readonly loggingConfig?: GoogleContainerAwsClusterLoggingConfig;
    /**
    * networking block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#networking GoogleContainerAwsCluster#networking}
    */
    readonly networking: GoogleContainerAwsClusterNetworking;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#timeouts GoogleContainerAwsCluster#timeouts}
    */
    readonly timeouts?: GoogleContainerAwsClusterTimeouts;
}
export interface GoogleContainerAwsClusterWorkloadIdentityConfig {
}
export declare function googleContainerAwsClusterWorkloadIdentityConfigToTerraform(struct?: GoogleContainerAwsClusterWorkloadIdentityConfig): any;
export declare class GoogleContainerAwsClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAwsClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: GoogleContainerAwsClusterWorkloadIdentityConfig | undefined);
    get identityProvider(): string;
    get issuerUri(): string;
    get workloadPool(): string;
}
export declare class GoogleContainerAwsClusterWorkloadIdentityConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAwsClusterWorkloadIdentityConfigOutputReference;
}
export interface GoogleContainerAwsClusterAuthorizationAdminUsers {
    /**
    * The name of the user, e.g. `my-gcp-id@gmail.com`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#username GoogleContainerAwsCluster#username}
    */
    readonly username: string;
}
export declare function googleContainerAwsClusterAuthorizationAdminUsersToTerraform(struct?: GoogleContainerAwsClusterAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare class GoogleContainerAwsClusterAuthorizationAdminUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAwsClusterAuthorizationAdminUsers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAwsClusterAuthorizationAdminUsers | cdktf.IResolvable | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class GoogleContainerAwsClusterAuthorizationAdminUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerAwsClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAwsClusterAuthorizationAdminUsersOutputReference;
}
export interface GoogleContainerAwsClusterAuthorization {
    /**
    * admin_users block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#admin_users GoogleContainerAwsCluster#admin_users}
    */
    readonly adminUsers: GoogleContainerAwsClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
}
export declare function googleContainerAwsClusterAuthorizationToTerraform(struct?: GoogleContainerAwsClusterAuthorizationOutputReference | GoogleContainerAwsClusterAuthorization): any;
export declare class GoogleContainerAwsClusterAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterAuthorization | undefined;
    set internalValue(value: GoogleContainerAwsClusterAuthorization | undefined);
    private _adminUsers;
    get adminUsers(): GoogleContainerAwsClusterAuthorizationAdminUsersList;
    putAdminUsers(value: GoogleContainerAwsClusterAuthorizationAdminUsers[] | cdktf.IResolvable): void;
    get adminUsersInput(): cdktf.IResolvable | GoogleContainerAwsClusterAuthorizationAdminUsers[] | undefined;
}
export interface GoogleContainerAwsClusterControlPlaneAwsServicesAuthentication {
    /**
    * The Amazon Resource Name (ARN) of the role that the Anthos Multi-Cloud API will assume when managing AWS resources on your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#role_arn GoogleContainerAwsCluster#role_arn}
    */
    readonly roleArn: string;
    /**
    * Optional. An identifier for the assumed role session. When unspecified, it defaults to `multicloud-service-agent`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#role_session_name GoogleContainerAwsCluster#role_session_name}
    */
    readonly roleSessionName?: string;
}
export declare function googleContainerAwsClusterControlPlaneAwsServicesAuthenticationToTerraform(struct?: GoogleContainerAwsClusterControlPlaneAwsServicesAuthenticationOutputReference | GoogleContainerAwsClusterControlPlaneAwsServicesAuthentication): any;
export declare class GoogleContainerAwsClusterControlPlaneAwsServicesAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlaneAwsServicesAuthentication | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlaneAwsServicesAuthentication | undefined);
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _roleSessionName?;
    get roleSessionName(): string;
    set roleSessionName(value: string);
    resetRoleSessionName(): void;
    get roleSessionNameInput(): string | undefined;
}
export interface GoogleContainerAwsClusterControlPlaneConfigEncryption {
    /**
    * The ARN of the AWS KMS key used to encrypt cluster configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#kms_key_arn GoogleContainerAwsCluster#kms_key_arn}
    */
    readonly kmsKeyArn: string;
}
export declare function googleContainerAwsClusterControlPlaneConfigEncryptionToTerraform(struct?: GoogleContainerAwsClusterControlPlaneConfigEncryptionOutputReference | GoogleContainerAwsClusterControlPlaneConfigEncryption): any;
export declare class GoogleContainerAwsClusterControlPlaneConfigEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlaneConfigEncryption | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlaneConfigEncryption | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    get kmsKeyArnInput(): string | undefined;
}
export interface GoogleContainerAwsClusterControlPlaneDatabaseEncryption {
    /**
    * The ARN of the AWS KMS key used to encrypt cluster secrets.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#kms_key_arn GoogleContainerAwsCluster#kms_key_arn}
    */
    readonly kmsKeyArn: string;
}
export declare function googleContainerAwsClusterControlPlaneDatabaseEncryptionToTerraform(struct?: GoogleContainerAwsClusterControlPlaneDatabaseEncryptionOutputReference | GoogleContainerAwsClusterControlPlaneDatabaseEncryption): any;
export declare class GoogleContainerAwsClusterControlPlaneDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlaneDatabaseEncryption | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlaneDatabaseEncryption | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    get kmsKeyArnInput(): string | undefined;
}
export interface GoogleContainerAwsClusterControlPlaneInstancePlacement {
    /**
    * The tenancy for the instance. Possible values: TENANCY_UNSPECIFIED, DEFAULT, DEDICATED, HOST
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#tenancy GoogleContainerAwsCluster#tenancy}
    */
    readonly tenancy?: string;
}
export declare function googleContainerAwsClusterControlPlaneInstancePlacementToTerraform(struct?: GoogleContainerAwsClusterControlPlaneInstancePlacementOutputReference | GoogleContainerAwsClusterControlPlaneInstancePlacement): any;
export declare class GoogleContainerAwsClusterControlPlaneInstancePlacementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlaneInstancePlacement | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlaneInstancePlacement | undefined);
    private _tenancy?;
    get tenancy(): string;
    set tenancy(value: string);
    resetTenancy(): void;
    get tenancyInput(): string | undefined;
}
export interface GoogleContainerAwsClusterControlPlaneMainVolume {
    /**
    * Optional. The number of I/O operations per second (IOPS) to provision for GP3 volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#iops GoogleContainerAwsCluster#iops}
    */
    readonly iops?: number;
    /**
    * Optional. The Amazon Resource Name (ARN) of the Customer Managed Key (CMK) used to encrypt AWS EBS volumes. If not specified, the default Amazon managed key associated to the AWS region where this cluster runs will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#kms_key_arn GoogleContainerAwsCluster#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
    /**
    * Optional. The size of the volume, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#size_gib GoogleContainerAwsCluster#size_gib}
    */
    readonly sizeGib?: number;
    /**
    * Optional. Type of the EBS volume. When unspecified, it defaults to GP2 volume. Possible values: VOLUME_TYPE_UNSPECIFIED, GP2, GP3
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#volume_type GoogleContainerAwsCluster#volume_type}
    */
    readonly volumeType?: string;
}
export declare function googleContainerAwsClusterControlPlaneMainVolumeToTerraform(struct?: GoogleContainerAwsClusterControlPlaneMainVolumeOutputReference | GoogleContainerAwsClusterControlPlaneMainVolume): any;
export declare class GoogleContainerAwsClusterControlPlaneMainVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlaneMainVolume | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlaneMainVolume | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    resetKmsKeyArn(): void;
    get kmsKeyArnInput(): string | undefined;
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
}
export interface GoogleContainerAwsClusterControlPlaneProxyConfig {
    /**
    * The ARN of the AWS Secret Manager secret that contains the HTTP(S) proxy configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#secret_arn GoogleContainerAwsCluster#secret_arn}
    */
    readonly secretArn: string;
    /**
    * The version string of the AWS Secret Manager secret that contains the HTTP(S) proxy configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#secret_version GoogleContainerAwsCluster#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleContainerAwsClusterControlPlaneProxyConfigToTerraform(struct?: GoogleContainerAwsClusterControlPlaneProxyConfigOutputReference | GoogleContainerAwsClusterControlPlaneProxyConfig): any;
export declare class GoogleContainerAwsClusterControlPlaneProxyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlaneProxyConfig | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlaneProxyConfig | undefined);
    private _secretArn?;
    get secretArn(): string;
    set secretArn(value: string);
    get secretArnInput(): string | undefined;
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleContainerAwsClusterControlPlaneRootVolume {
    /**
    * Optional. The number of I/O operations per second (IOPS) to provision for GP3 volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#iops GoogleContainerAwsCluster#iops}
    */
    readonly iops?: number;
    /**
    * Optional. The Amazon Resource Name (ARN) of the Customer Managed Key (CMK) used to encrypt AWS EBS volumes. If not specified, the default Amazon managed key associated to the AWS region where this cluster runs will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#kms_key_arn GoogleContainerAwsCluster#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
    /**
    * Optional. The size of the volume, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#size_gib GoogleContainerAwsCluster#size_gib}
    */
    readonly sizeGib?: number;
    /**
    * Optional. Type of the EBS volume. When unspecified, it defaults to GP2 volume. Possible values: VOLUME_TYPE_UNSPECIFIED, GP2, GP3
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#volume_type GoogleContainerAwsCluster#volume_type}
    */
    readonly volumeType?: string;
}
export declare function googleContainerAwsClusterControlPlaneRootVolumeToTerraform(struct?: GoogleContainerAwsClusterControlPlaneRootVolumeOutputReference | GoogleContainerAwsClusterControlPlaneRootVolume): any;
export declare class GoogleContainerAwsClusterControlPlaneRootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlaneRootVolume | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlaneRootVolume | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    resetKmsKeyArn(): void;
    get kmsKeyArnInput(): string | undefined;
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
}
export interface GoogleContainerAwsClusterControlPlaneSshConfig {
    /**
    * The name of the EC2 key pair used to login into cluster machines.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#ec2_key_pair GoogleContainerAwsCluster#ec2_key_pair}
    */
    readonly ec2KeyPair: string;
}
export declare function googleContainerAwsClusterControlPlaneSshConfigToTerraform(struct?: GoogleContainerAwsClusterControlPlaneSshConfigOutputReference | GoogleContainerAwsClusterControlPlaneSshConfig): any;
export declare class GoogleContainerAwsClusterControlPlaneSshConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlaneSshConfig | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlaneSshConfig | undefined);
    private _ec2KeyPair?;
    get ec2KeyPair(): string;
    set ec2KeyPair(value: string);
    get ec2KeyPairInput(): string | undefined;
}
export interface GoogleContainerAwsClusterControlPlane {
    /**
    * The name of the AWS IAM instance pofile to assign to each control plane replica.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#iam_instance_profile GoogleContainerAwsCluster#iam_instance_profile}
    */
    readonly iamInstanceProfile: string;
    /**
    * Optional. The AWS instance type. When unspecified, it defaults to `m5.large`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#instance_type GoogleContainerAwsCluster#instance_type}
    */
    readonly instanceType?: string;
    /**
    * Optional. The IDs of additional security groups to add to control plane replicas. The Anthos Multi-Cloud API will automatically create and manage security groups with the minimum rules needed for a functioning cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#security_group_ids GoogleContainerAwsCluster#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * The list of subnets where control plane replicas will run. A replica will be provisioned on each subnet and up to three values can be provided. Each subnet must be in a different AWS Availability Zone (AZ).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#subnet_ids GoogleContainerAwsCluster#subnet_ids}
    */
    readonly subnetIds: string[];
    /**
    * Optional. A set of AWS resource tags to propagate to all underlying managed AWS resources. Specify at most 50 pairs containing alphanumerics, spaces, and symbols (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to 255 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#tags GoogleContainerAwsCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * The Kubernetes version to run on control plane replicas (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling .
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#version GoogleContainerAwsCluster#version}
    */
    readonly version: string;
    /**
    * aws_services_authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#aws_services_authentication GoogleContainerAwsCluster#aws_services_authentication}
    */
    readonly awsServicesAuthentication: GoogleContainerAwsClusterControlPlaneAwsServicesAuthentication;
    /**
    * config_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#config_encryption GoogleContainerAwsCluster#config_encryption}
    */
    readonly configEncryption: GoogleContainerAwsClusterControlPlaneConfigEncryption;
    /**
    * database_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#database_encryption GoogleContainerAwsCluster#database_encryption}
    */
    readonly databaseEncryption: GoogleContainerAwsClusterControlPlaneDatabaseEncryption;
    /**
    * instance_placement block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#instance_placement GoogleContainerAwsCluster#instance_placement}
    */
    readonly instancePlacement?: GoogleContainerAwsClusterControlPlaneInstancePlacement;
    /**
    * main_volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#main_volume GoogleContainerAwsCluster#main_volume}
    */
    readonly mainVolume?: GoogleContainerAwsClusterControlPlaneMainVolume;
    /**
    * proxy_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#proxy_config GoogleContainerAwsCluster#proxy_config}
    */
    readonly proxyConfig?: GoogleContainerAwsClusterControlPlaneProxyConfig;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#root_volume GoogleContainerAwsCluster#root_volume}
    */
    readonly rootVolume?: GoogleContainerAwsClusterControlPlaneRootVolume;
    /**
    * ssh_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#ssh_config GoogleContainerAwsCluster#ssh_config}
    */
    readonly sshConfig?: GoogleContainerAwsClusterControlPlaneSshConfig;
}
export declare function googleContainerAwsClusterControlPlaneToTerraform(struct?: GoogleContainerAwsClusterControlPlaneOutputReference | GoogleContainerAwsClusterControlPlane): any;
export declare class GoogleContainerAwsClusterControlPlaneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterControlPlane | undefined;
    set internalValue(value: GoogleContainerAwsClusterControlPlane | undefined);
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    get iamInstanceProfileInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    resetInstanceType(): void;
    get instanceTypeInput(): string | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _subnetIds?;
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    get subnetIdsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _awsServicesAuthentication;
    get awsServicesAuthentication(): GoogleContainerAwsClusterControlPlaneAwsServicesAuthenticationOutputReference;
    putAwsServicesAuthentication(value: GoogleContainerAwsClusterControlPlaneAwsServicesAuthentication): void;
    get awsServicesAuthenticationInput(): GoogleContainerAwsClusterControlPlaneAwsServicesAuthentication | undefined;
    private _configEncryption;
    get configEncryption(): GoogleContainerAwsClusterControlPlaneConfigEncryptionOutputReference;
    putConfigEncryption(value: GoogleContainerAwsClusterControlPlaneConfigEncryption): void;
    get configEncryptionInput(): GoogleContainerAwsClusterControlPlaneConfigEncryption | undefined;
    private _databaseEncryption;
    get databaseEncryption(): GoogleContainerAwsClusterControlPlaneDatabaseEncryptionOutputReference;
    putDatabaseEncryption(value: GoogleContainerAwsClusterControlPlaneDatabaseEncryption): void;
    get databaseEncryptionInput(): GoogleContainerAwsClusterControlPlaneDatabaseEncryption | undefined;
    private _instancePlacement;
    get instancePlacement(): GoogleContainerAwsClusterControlPlaneInstancePlacementOutputReference;
    putInstancePlacement(value: GoogleContainerAwsClusterControlPlaneInstancePlacement): void;
    resetInstancePlacement(): void;
    get instancePlacementInput(): GoogleContainerAwsClusterControlPlaneInstancePlacement | undefined;
    private _mainVolume;
    get mainVolume(): GoogleContainerAwsClusterControlPlaneMainVolumeOutputReference;
    putMainVolume(value: GoogleContainerAwsClusterControlPlaneMainVolume): void;
    resetMainVolume(): void;
    get mainVolumeInput(): GoogleContainerAwsClusterControlPlaneMainVolume | undefined;
    private _proxyConfig;
    get proxyConfig(): GoogleContainerAwsClusterControlPlaneProxyConfigOutputReference;
    putProxyConfig(value: GoogleContainerAwsClusterControlPlaneProxyConfig): void;
    resetProxyConfig(): void;
    get proxyConfigInput(): GoogleContainerAwsClusterControlPlaneProxyConfig | undefined;
    private _rootVolume;
    get rootVolume(): GoogleContainerAwsClusterControlPlaneRootVolumeOutputReference;
    putRootVolume(value: GoogleContainerAwsClusterControlPlaneRootVolume): void;
    resetRootVolume(): void;
    get rootVolumeInput(): GoogleContainerAwsClusterControlPlaneRootVolume | undefined;
    private _sshConfig;
    get sshConfig(): GoogleContainerAwsClusterControlPlaneSshConfigOutputReference;
    putSshConfig(value: GoogleContainerAwsClusterControlPlaneSshConfig): void;
    resetSshConfig(): void;
    get sshConfigInput(): GoogleContainerAwsClusterControlPlaneSshConfig | undefined;
}
export interface GoogleContainerAwsClusterFleet {
    /**
    * The number of the Fleet host project where this cluster will be registered.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#project GoogleContainerAwsCluster#project}
    */
    readonly project?: string;
}
export declare function googleContainerAwsClusterFleetToTerraform(struct?: GoogleContainerAwsClusterFleetOutputReference | GoogleContainerAwsClusterFleet): any;
export declare class GoogleContainerAwsClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterFleet | undefined;
    set internalValue(value: GoogleContainerAwsClusterFleet | undefined);
    get membership(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
}
export interface GoogleContainerAwsClusterLoggingConfigComponentConfig {
    /**
    * Components of the logging configuration to be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#enable_components GoogleContainerAwsCluster#enable_components}
    */
    readonly enableComponents?: string[];
}
export declare function googleContainerAwsClusterLoggingConfigComponentConfigToTerraform(struct?: GoogleContainerAwsClusterLoggingConfigComponentConfigOutputReference | GoogleContainerAwsClusterLoggingConfigComponentConfig): any;
export declare class GoogleContainerAwsClusterLoggingConfigComponentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterLoggingConfigComponentConfig | undefined;
    set internalValue(value: GoogleContainerAwsClusterLoggingConfigComponentConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    resetEnableComponents(): void;
    get enableComponentsInput(): string[] | undefined;
}
export interface GoogleContainerAwsClusterLoggingConfig {
    /**
    * component_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#component_config GoogleContainerAwsCluster#component_config}
    */
    readonly componentConfig?: GoogleContainerAwsClusterLoggingConfigComponentConfig;
}
export declare function googleContainerAwsClusterLoggingConfigToTerraform(struct?: GoogleContainerAwsClusterLoggingConfigOutputReference | GoogleContainerAwsClusterLoggingConfig): any;
export declare class GoogleContainerAwsClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterLoggingConfig | undefined;
    set internalValue(value: GoogleContainerAwsClusterLoggingConfig | undefined);
    private _componentConfig;
    get componentConfig(): GoogleContainerAwsClusterLoggingConfigComponentConfigOutputReference;
    putComponentConfig(value: GoogleContainerAwsClusterLoggingConfigComponentConfig): void;
    resetComponentConfig(): void;
    get componentConfigInput(): GoogleContainerAwsClusterLoggingConfigComponentConfig | undefined;
}
export interface GoogleContainerAwsClusterNetworking {
    /**
    * All pods in the cluster are assigned an RFC1918 IPv4 address from these ranges. Only a single range is supported. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#pod_address_cidr_blocks GoogleContainerAwsCluster#pod_address_cidr_blocks}
    */
    readonly podAddressCidrBlocks: string[];
    /**
    * All services in the cluster are assigned an RFC1918 IPv4 address from these ranges. Only a single range is supported. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#service_address_cidr_blocks GoogleContainerAwsCluster#service_address_cidr_blocks}
    */
    readonly serviceAddressCidrBlocks: string[];
    /**
    * The VPC associated with the cluster. All component clusters (i.e. control plane and node pools) run on a single VPC. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#vpc_id GoogleContainerAwsCluster#vpc_id}
    */
    readonly vpcId: string;
}
export declare function googleContainerAwsClusterNetworkingToTerraform(struct?: GoogleContainerAwsClusterNetworkingOutputReference | GoogleContainerAwsClusterNetworking): any;
export declare class GoogleContainerAwsClusterNetworkingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterNetworking | undefined;
    set internalValue(value: GoogleContainerAwsClusterNetworking | undefined);
    private _podAddressCidrBlocks?;
    get podAddressCidrBlocks(): string[];
    set podAddressCidrBlocks(value: string[]);
    get podAddressCidrBlocksInput(): string[] | undefined;
    private _serviceAddressCidrBlocks?;
    get serviceAddressCidrBlocks(): string[];
    set serviceAddressCidrBlocks(value: string[]);
    get serviceAddressCidrBlocksInput(): string[] | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    get vpcIdInput(): string | undefined;
}
export interface GoogleContainerAwsClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#create GoogleContainerAwsCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#delete GoogleContainerAwsCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster#update GoogleContainerAwsCluster#update}
    */
    readonly update?: string;
}
export declare function googleContainerAwsClusterTimeoutsToTerraform(struct?: GoogleContainerAwsClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerAwsClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAwsClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster google_container_aws_cluster}
*/
export declare class GoogleContainerAwsCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_aws_cluster";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_cluster google_container_aws_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerAwsClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerAwsClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _awsRegion?;
    get awsRegion(): string;
    set awsRegion(value: string);
    get awsRegionInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get endpoint(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): GoogleContainerAwsClusterWorkloadIdentityConfigList;
    private _authorization;
    get authorization(): GoogleContainerAwsClusterAuthorizationOutputReference;
    putAuthorization(value: GoogleContainerAwsClusterAuthorization): void;
    get authorizationInput(): GoogleContainerAwsClusterAuthorization | undefined;
    private _controlPlane;
    get controlPlane(): GoogleContainerAwsClusterControlPlaneOutputReference;
    putControlPlane(value: GoogleContainerAwsClusterControlPlane): void;
    get controlPlaneInput(): GoogleContainerAwsClusterControlPlane | undefined;
    private _fleet;
    get fleet(): GoogleContainerAwsClusterFleetOutputReference;
    putFleet(value: GoogleContainerAwsClusterFleet): void;
    get fleetInput(): GoogleContainerAwsClusterFleet | undefined;
    private _loggingConfig;
    get loggingConfig(): GoogleContainerAwsClusterLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleContainerAwsClusterLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleContainerAwsClusterLoggingConfig | undefined;
    private _networking;
    get networking(): GoogleContainerAwsClusterNetworkingOutputReference;
    putNetworking(value: GoogleContainerAwsClusterNetworking): void;
    get networkingInput(): GoogleContainerAwsClusterNetworking | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerAwsClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerAwsClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerAwsClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
