import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleContainerAwsNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#annotations GoogleContainerAwsNodePool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The awsCluster for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#cluster GoogleContainerAwsNodePool#cluster}
    */
    readonly cluster: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#id GoogleContainerAwsNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#location GoogleContainerAwsNodePool#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#name GoogleContainerAwsNodePool#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#project GoogleContainerAwsNodePool#project}
    */
    readonly project?: string;
    /**
    * The subnet where the node pool node run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#subnet_id GoogleContainerAwsNodePool#subnet_id}
    */
    readonly subnetId: string;
    /**
    * The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#version GoogleContainerAwsNodePool#version}
    */
    readonly version: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#autoscaling GoogleContainerAwsNodePool#autoscaling}
    */
    readonly autoscaling: GoogleContainerAwsNodePoolAutoscaling;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#config GoogleContainerAwsNodePool#config}
    */
    readonly config: GoogleContainerAwsNodePoolConfigA;
    /**
    * max_pods_constraint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#max_pods_constraint GoogleContainerAwsNodePool#max_pods_constraint}
    */
    readonly maxPodsConstraint: GoogleContainerAwsNodePoolMaxPodsConstraint;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#timeouts GoogleContainerAwsNodePool#timeouts}
    */
    readonly timeouts?: GoogleContainerAwsNodePoolTimeouts;
}
export interface GoogleContainerAwsNodePoolAutoscaling {
    /**
    * Maximum number of nodes in the NodePool. Must be >= min_node_count.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#max_node_count GoogleContainerAwsNodePool#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * Minimum number of nodes in the NodePool. Must be >= 1 and <= max_node_count.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#min_node_count GoogleContainerAwsNodePool#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function googleContainerAwsNodePoolAutoscalingToTerraform(struct?: GoogleContainerAwsNodePoolAutoscalingOutputReference | GoogleContainerAwsNodePoolAutoscaling): any;
export declare class GoogleContainerAwsNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolAutoscaling | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolAutoscaling | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollection {
    /**
    * The frequency at which EC2 Auto Scaling sends aggregated data to AWS CloudWatch. The only valid value is "1Minute".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#granularity GoogleContainerAwsNodePool#granularity}
    */
    readonly granularity: string;
    /**
    * The metrics to enable. For a list of valid metrics, see https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html. If you specify granularity and don't specify any metrics, all metrics are enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#metrics GoogleContainerAwsNodePool#metrics}
    */
    readonly metrics?: string[];
}
export declare function googleContainerAwsNodePoolConfigAutoscalingMetricsCollectionToTerraform(struct?: GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollectionOutputReference | GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollection): any;
export declare class GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollection | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollection | undefined);
    private _granularity?;
    get granularity(): string;
    set granularity(value: string);
    get granularityInput(): string | undefined;
    private _metrics?;
    get metrics(): string[];
    set metrics(value: string[]);
    resetMetrics(): void;
    get metricsInput(): string[] | undefined;
}
export interface GoogleContainerAwsNodePoolConfigConfigEncryption {
    /**
    * The ARN of the AWS KMS key used to encrypt node pool configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#kms_key_arn GoogleContainerAwsNodePool#kms_key_arn}
    */
    readonly kmsKeyArn: string;
}
export declare function googleContainerAwsNodePoolConfigConfigEncryptionToTerraform(struct?: GoogleContainerAwsNodePoolConfigConfigEncryptionOutputReference | GoogleContainerAwsNodePoolConfigConfigEncryption): any;
export declare class GoogleContainerAwsNodePoolConfigConfigEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolConfigConfigEncryption | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolConfigConfigEncryption | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    get kmsKeyArnInput(): string | undefined;
}
export interface GoogleContainerAwsNodePoolConfigInstancePlacement {
    /**
    * The tenancy for the instance. Possible values: TENANCY_UNSPECIFIED, DEFAULT, DEDICATED, HOST
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#tenancy GoogleContainerAwsNodePool#tenancy}
    */
    readonly tenancy?: string;
}
export declare function googleContainerAwsNodePoolConfigInstancePlacementToTerraform(struct?: GoogleContainerAwsNodePoolConfigInstancePlacementOutputReference | GoogleContainerAwsNodePoolConfigInstancePlacement): any;
export declare class GoogleContainerAwsNodePoolConfigInstancePlacementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolConfigInstancePlacement | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolConfigInstancePlacement | undefined);
    private _tenancy?;
    get tenancy(): string;
    set tenancy(value: string);
    resetTenancy(): void;
    get tenancyInput(): string | undefined;
}
export interface GoogleContainerAwsNodePoolConfigProxyConfig {
    /**
    * The ARN of the AWS Secret Manager secret that contains the HTTP(S) proxy configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#secret_arn GoogleContainerAwsNodePool#secret_arn}
    */
    readonly secretArn: string;
    /**
    * The version string of the AWS Secret Manager secret that contains the HTTP(S) proxy configuration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#secret_version GoogleContainerAwsNodePool#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleContainerAwsNodePoolConfigProxyConfigToTerraform(struct?: GoogleContainerAwsNodePoolConfigProxyConfigOutputReference | GoogleContainerAwsNodePoolConfigProxyConfig): any;
export declare class GoogleContainerAwsNodePoolConfigProxyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolConfigProxyConfig | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolConfigProxyConfig | undefined);
    private _secretArn?;
    get secretArn(): string;
    set secretArn(value: string);
    get secretArnInput(): string | undefined;
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleContainerAwsNodePoolConfigRootVolume {
    /**
    * Optional. The number of I/O operations per second (IOPS) to provision for GP3 volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#iops GoogleContainerAwsNodePool#iops}
    */
    readonly iops?: number;
    /**
    * Optional. The Amazon Resource Name (ARN) of the Customer Managed Key (CMK) used to encrypt AWS EBS volumes. If not specified, the default Amazon managed key associated to the AWS region where this cluster runs will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#kms_key_arn GoogleContainerAwsNodePool#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
    /**
    * Optional. The size of the volume, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#size_gib GoogleContainerAwsNodePool#size_gib}
    */
    readonly sizeGib?: number;
    /**
    * Optional. Type of the EBS volume. When unspecified, it defaults to GP2 volume. Possible values: VOLUME_TYPE_UNSPECIFIED, GP2, GP3
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#volume_type GoogleContainerAwsNodePool#volume_type}
    */
    readonly volumeType?: string;
}
export declare function googleContainerAwsNodePoolConfigRootVolumeToTerraform(struct?: GoogleContainerAwsNodePoolConfigRootVolumeOutputReference | GoogleContainerAwsNodePoolConfigRootVolume): any;
export declare class GoogleContainerAwsNodePoolConfigRootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolConfigRootVolume | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolConfigRootVolume | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    resetKmsKeyArn(): void;
    get kmsKeyArnInput(): string | undefined;
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
}
export interface GoogleContainerAwsNodePoolConfigSshConfig {
    /**
    * The name of the EC2 key pair used to login into cluster machines.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#ec2_key_pair GoogleContainerAwsNodePool#ec2_key_pair}
    */
    readonly ec2KeyPair: string;
}
export declare function googleContainerAwsNodePoolConfigSshConfigToTerraform(struct?: GoogleContainerAwsNodePoolConfigSshConfigOutputReference | GoogleContainerAwsNodePoolConfigSshConfig): any;
export declare class GoogleContainerAwsNodePoolConfigSshConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolConfigSshConfig | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolConfigSshConfig | undefined);
    private _ec2KeyPair?;
    get ec2KeyPair(): string;
    set ec2KeyPair(value: string);
    get ec2KeyPairInput(): string | undefined;
}
export interface GoogleContainerAwsNodePoolConfigTaints {
    /**
    * The taint effect. Possible values: EFFECT_UNSPECIFIED, NO_SCHEDULE, PREFER_NO_SCHEDULE, NO_EXECUTE
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#effect GoogleContainerAwsNodePool#effect}
    */
    readonly effect: string;
    /**
    * Key for the taint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#key GoogleContainerAwsNodePool#key}
    */
    readonly key: string;
    /**
    * Value for the taint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#value GoogleContainerAwsNodePool#value}
    */
    readonly value: string;
}
export declare function googleContainerAwsNodePoolConfigTaintsToTerraform(struct?: GoogleContainerAwsNodePoolConfigTaints | cdktf.IResolvable): any;
export declare class GoogleContainerAwsNodePoolConfigTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleContainerAwsNodePoolConfigTaints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolConfigTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleContainerAwsNodePoolConfigTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleContainerAwsNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleContainerAwsNodePoolConfigTaintsOutputReference;
}
export interface GoogleContainerAwsNodePoolConfigA {
    /**
    * The name of the AWS IAM role assigned to nodes in the pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#iam_instance_profile GoogleContainerAwsNodePool#iam_instance_profile}
    */
    readonly iamInstanceProfile: string;
    /**
    * The OS image type to use on node pool instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#image_type GoogleContainerAwsNodePool#image_type}
    */
    readonly imageType?: string;
    /**
    * Optional. The AWS instance type. When unspecified, it defaults to `m5.large`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#instance_type GoogleContainerAwsNodePool#instance_type}
    */
    readonly instanceType?: string;
    /**
    * Optional. The initial labels assigned to nodes of this node pool. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#labels GoogleContainerAwsNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Optional. The IDs of additional security groups to add to nodes in this pool. The manager will automatically create security groups with minimum rules needed for a functioning cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#security_group_ids GoogleContainerAwsNodePool#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * Optional. Key/value metadata to assign to each underlying AWS resource. Specify at most 50 pairs containing alphanumerics, spaces, and symbols (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to 255 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#tags GoogleContainerAwsNodePool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * autoscaling_metrics_collection block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#autoscaling_metrics_collection GoogleContainerAwsNodePool#autoscaling_metrics_collection}
    */
    readonly autoscalingMetricsCollection?: GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollection;
    /**
    * config_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#config_encryption GoogleContainerAwsNodePool#config_encryption}
    */
    readonly configEncryption: GoogleContainerAwsNodePoolConfigConfigEncryption;
    /**
    * instance_placement block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#instance_placement GoogleContainerAwsNodePool#instance_placement}
    */
    readonly instancePlacement?: GoogleContainerAwsNodePoolConfigInstancePlacement;
    /**
    * proxy_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#proxy_config GoogleContainerAwsNodePool#proxy_config}
    */
    readonly proxyConfig?: GoogleContainerAwsNodePoolConfigProxyConfig;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#root_volume GoogleContainerAwsNodePool#root_volume}
    */
    readonly rootVolume?: GoogleContainerAwsNodePoolConfigRootVolume;
    /**
    * ssh_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#ssh_config GoogleContainerAwsNodePool#ssh_config}
    */
    readonly sshConfig?: GoogleContainerAwsNodePoolConfigSshConfig;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#taints GoogleContainerAwsNodePool#taints}
    */
    readonly taints?: GoogleContainerAwsNodePoolConfigTaints[] | cdktf.IResolvable;
}
export declare function googleContainerAwsNodePoolConfigAToTerraform(struct?: GoogleContainerAwsNodePoolConfigAOutputReference | GoogleContainerAwsNodePoolConfigA): any;
export declare class GoogleContainerAwsNodePoolConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolConfigA | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolConfigA | undefined);
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    get iamInstanceProfileInput(): string | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    resetInstanceType(): void;
    get instanceTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _autoscalingMetricsCollection;
    get autoscalingMetricsCollection(): GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollectionOutputReference;
    putAutoscalingMetricsCollection(value: GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollection): void;
    resetAutoscalingMetricsCollection(): void;
    get autoscalingMetricsCollectionInput(): GoogleContainerAwsNodePoolConfigAutoscalingMetricsCollection | undefined;
    private _configEncryption;
    get configEncryption(): GoogleContainerAwsNodePoolConfigConfigEncryptionOutputReference;
    putConfigEncryption(value: GoogleContainerAwsNodePoolConfigConfigEncryption): void;
    get configEncryptionInput(): GoogleContainerAwsNodePoolConfigConfigEncryption | undefined;
    private _instancePlacement;
    get instancePlacement(): GoogleContainerAwsNodePoolConfigInstancePlacementOutputReference;
    putInstancePlacement(value: GoogleContainerAwsNodePoolConfigInstancePlacement): void;
    resetInstancePlacement(): void;
    get instancePlacementInput(): GoogleContainerAwsNodePoolConfigInstancePlacement | undefined;
    private _proxyConfig;
    get proxyConfig(): GoogleContainerAwsNodePoolConfigProxyConfigOutputReference;
    putProxyConfig(value: GoogleContainerAwsNodePoolConfigProxyConfig): void;
    resetProxyConfig(): void;
    get proxyConfigInput(): GoogleContainerAwsNodePoolConfigProxyConfig | undefined;
    private _rootVolume;
    get rootVolume(): GoogleContainerAwsNodePoolConfigRootVolumeOutputReference;
    putRootVolume(value: GoogleContainerAwsNodePoolConfigRootVolume): void;
    resetRootVolume(): void;
    get rootVolumeInput(): GoogleContainerAwsNodePoolConfigRootVolume | undefined;
    private _sshConfig;
    get sshConfig(): GoogleContainerAwsNodePoolConfigSshConfigOutputReference;
    putSshConfig(value: GoogleContainerAwsNodePoolConfigSshConfig): void;
    resetSshConfig(): void;
    get sshConfigInput(): GoogleContainerAwsNodePoolConfigSshConfig | undefined;
    private _taints;
    get taints(): GoogleContainerAwsNodePoolConfigTaintsList;
    putTaints(value: GoogleContainerAwsNodePoolConfigTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | GoogleContainerAwsNodePoolConfigTaints[] | undefined;
}
export interface GoogleContainerAwsNodePoolMaxPodsConstraint {
    /**
    * The maximum number of pods to schedule on a single node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#max_pods_per_node GoogleContainerAwsNodePool#max_pods_per_node}
    */
    readonly maxPodsPerNode: number;
}
export declare function googleContainerAwsNodePoolMaxPodsConstraintToTerraform(struct?: GoogleContainerAwsNodePoolMaxPodsConstraintOutputReference | GoogleContainerAwsNodePoolMaxPodsConstraint): any;
export declare class GoogleContainerAwsNodePoolMaxPodsConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolMaxPodsConstraint | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolMaxPodsConstraint | undefined);
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    get maxPodsPerNodeInput(): number | undefined;
}
export interface GoogleContainerAwsNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#create GoogleContainerAwsNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#delete GoogleContainerAwsNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool#update GoogleContainerAwsNodePool#update}
    */
    readonly update?: string;
}
export declare function googleContainerAwsNodePoolTimeoutsToTerraform(struct?: GoogleContainerAwsNodePoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleContainerAwsNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleContainerAwsNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleContainerAwsNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool google_container_aws_node_pool}
*/
export declare class GoogleContainerAwsNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_aws_node_pool";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_container_aws_node_pool google_container_aws_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleContainerAwsNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleContainerAwsNodePoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get createTime(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): GoogleContainerAwsNodePoolAutoscalingOutputReference;
    putAutoscaling(value: GoogleContainerAwsNodePoolAutoscaling): void;
    get autoscalingInput(): GoogleContainerAwsNodePoolAutoscaling | undefined;
    private _config;
    get config(): GoogleContainerAwsNodePoolConfigAOutputReference;
    putConfig(value: GoogleContainerAwsNodePoolConfigA): void;
    get configInput(): GoogleContainerAwsNodePoolConfigA | undefined;
    private _maxPodsConstraint;
    get maxPodsConstraint(): GoogleContainerAwsNodePoolMaxPodsConstraintOutputReference;
    putMaxPodsConstraint(value: GoogleContainerAwsNodePoolMaxPodsConstraint): void;
    get maxPodsConstraintInput(): GoogleContainerAwsNodePoolMaxPodsConstraint | undefined;
    private _timeouts;
    get timeouts(): GoogleContainerAwsNodePoolTimeoutsOutputReference;
    putTimeouts(value: GoogleContainerAwsNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleContainerAwsNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
