import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataCatalogEntryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Entry description, which can consist of several sentences or paragraphs that describe entry contents.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#description GoogleDataCatalogEntry#description}
    */
    readonly description?: string;
    /**
    * Display information such as title and description. A short name to identify the entry,
  for example, "Analytics Data - Jan 2011".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#display_name GoogleDataCatalogEntry#display_name}
    */
    readonly displayName?: string;
    /**
    * The name of the entry group this entry is in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#entry_group GoogleDataCatalogEntry#entry_group}
    */
    readonly entryGroup: string;
    /**
    * The id of the entry to create.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#entry_id GoogleDataCatalogEntry#entry_id}
    */
    readonly entryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#id GoogleDataCatalogEntry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource this metadata entry refers to.
  For Google Cloud Platform resources, linkedResource is the full name of the resource.
  For example, the linkedResource for a table resource from BigQuery is:
  //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
  Output only when Entry is of type in the EntryType enum. For entries with userSpecifiedType,
  this field is optional and defaults to an empty string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#linked_resource GoogleDataCatalogEntry#linked_resource}
    */
    readonly linkedResource?: string;
    /**
    * Schema of the entry (e.g. BigQuery, GoogleSQL, Avro schema), as a json string. An entry might not have any schema
  attached to it. See
  https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries#schema
  for what fields this schema can contain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#schema GoogleDataCatalogEntry#schema}
    */
    readonly schema?: string;
    /**
    * The type of the entry. Only used for Entries with types in the EntryType enum.
  Currently, only FILESET enum value is allowed. All other entries created through Data Catalog must use userSpecifiedType. Possible values: ["FILESET"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#type GoogleDataCatalogEntry#type}
    */
    readonly type?: string;
    /**
    * This field indicates the entry's source system that Data Catalog does not integrate with.
  userSpecifiedSystem strings must begin with a letter or underscore and can only contain letters, numbers,
  and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#user_specified_system GoogleDataCatalogEntry#user_specified_system}
    */
    readonly userSpecifiedSystem?: string;
    /**
    * Entry type if it does not fit any of the input-allowed values listed in EntryType enum above.
  When creating an entry, users should check the enum values first, if nothing matches the entry
  to be created, then provide a custom value, for example "my_special_type".
  userSpecifiedType strings must begin with a letter or underscore and can only contain letters,
  numbers, and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#user_specified_type GoogleDataCatalogEntry#user_specified_type}
    */
    readonly userSpecifiedType?: string;
    /**
    * gcs_fileset_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#gcs_fileset_spec GoogleDataCatalogEntry#gcs_fileset_spec}
    */
    readonly gcsFilesetSpec?: GoogleDataCatalogEntryGcsFilesetSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#timeouts GoogleDataCatalogEntry#timeouts}
    */
    readonly timeouts?: GoogleDataCatalogEntryTimeouts;
}
export interface GoogleDataCatalogEntryBigqueryDateShardedSpec {
}
export declare function googleDataCatalogEntryBigqueryDateShardedSpecToTerraform(struct?: GoogleDataCatalogEntryBigqueryDateShardedSpec): any;
export declare class GoogleDataCatalogEntryBigqueryDateShardedSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataCatalogEntryBigqueryDateShardedSpec | undefined;
    set internalValue(value: GoogleDataCatalogEntryBigqueryDateShardedSpec | undefined);
    get dataset(): string;
    get shardCount(): number;
    get tablePrefix(): string;
}
export declare class GoogleDataCatalogEntryBigqueryDateShardedSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataCatalogEntryBigqueryDateShardedSpecOutputReference;
}
export interface GoogleDataCatalogEntryBigqueryTableSpecTableSpec {
}
export declare function googleDataCatalogEntryBigqueryTableSpecTableSpecToTerraform(struct?: GoogleDataCatalogEntryBigqueryTableSpecTableSpec): any;
export declare class GoogleDataCatalogEntryBigqueryTableSpecTableSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataCatalogEntryBigqueryTableSpecTableSpec | undefined;
    set internalValue(value: GoogleDataCatalogEntryBigqueryTableSpecTableSpec | undefined);
    get groupedEntry(): string;
}
export declare class GoogleDataCatalogEntryBigqueryTableSpecTableSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataCatalogEntryBigqueryTableSpecTableSpecOutputReference;
}
export interface GoogleDataCatalogEntryBigqueryTableSpecViewSpec {
}
export declare function googleDataCatalogEntryBigqueryTableSpecViewSpecToTerraform(struct?: GoogleDataCatalogEntryBigqueryTableSpecViewSpec): any;
export declare class GoogleDataCatalogEntryBigqueryTableSpecViewSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataCatalogEntryBigqueryTableSpecViewSpec | undefined;
    set internalValue(value: GoogleDataCatalogEntryBigqueryTableSpecViewSpec | undefined);
    get viewQuery(): string;
}
export declare class GoogleDataCatalogEntryBigqueryTableSpecViewSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataCatalogEntryBigqueryTableSpecViewSpecOutputReference;
}
export interface GoogleDataCatalogEntryBigqueryTableSpec {
}
export declare function googleDataCatalogEntryBigqueryTableSpecToTerraform(struct?: GoogleDataCatalogEntryBigqueryTableSpec): any;
export declare class GoogleDataCatalogEntryBigqueryTableSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataCatalogEntryBigqueryTableSpec | undefined;
    set internalValue(value: GoogleDataCatalogEntryBigqueryTableSpec | undefined);
    get tableSourceType(): string;
    private _tableSpec;
    get tableSpec(): GoogleDataCatalogEntryBigqueryTableSpecTableSpecList;
    private _viewSpec;
    get viewSpec(): GoogleDataCatalogEntryBigqueryTableSpecViewSpecList;
}
export declare class GoogleDataCatalogEntryBigqueryTableSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataCatalogEntryBigqueryTableSpecOutputReference;
}
export interface GoogleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs {
}
export declare function googleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsToTerraform(struct?: GoogleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs): any;
export declare class GoogleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs | undefined;
    set internalValue(value: GoogleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs | undefined);
    get filePath(): string;
    get sizeBytes(): number;
}
export declare class GoogleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsOutputReference;
}
export interface GoogleDataCatalogEntryGcsFilesetSpec {
    /**
    * Patterns to identify a set of files in Google Cloud Storage.
  See [Cloud Storage documentation](https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames)
  for more information. Note that bucket wildcards are currently not supported. Examples of valid filePatterns:
  
  * gs://bucket_name/dir/*: matches all files within bucket_name/dir directory.
  * gs://bucket_name/dir/**: matches all files in bucket_name/dir spanning all subdirectories.
  * gs://bucket_name/file*: matches files prefixed by file in bucket_name
  * gs://bucket_name/??.txt: matches files with two characters followed by .txt in bucket_name
  * gs://bucket_name/[aeiou].txt: matches files that contain a single vowel character followed by .txt in bucket_name
  * gs://bucket_name/[a-m].txt: matches files that contain a, b, ... or m followed by .txt in bucket_name
  * gs://bucket_name/a/*\/b: matches all files in bucket_name that match a/*\/b pattern, such as a/c/b, a/d/b
  * gs://another_bucket/a.txt: matches gs://another_bucket/a.txt
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#file_patterns GoogleDataCatalogEntry#file_patterns}
    */
    readonly filePatterns: string[];
}
export declare function googleDataCatalogEntryGcsFilesetSpecToTerraform(struct?: GoogleDataCatalogEntryGcsFilesetSpecOutputReference | GoogleDataCatalogEntryGcsFilesetSpec): any;
export declare class GoogleDataCatalogEntryGcsFilesetSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataCatalogEntryGcsFilesetSpec | undefined;
    set internalValue(value: GoogleDataCatalogEntryGcsFilesetSpec | undefined);
    private _filePatterns?;
    get filePatterns(): string[];
    set filePatterns(value: string[]);
    get filePatternsInput(): string[] | undefined;
    private _sampleGcsFileSpecs;
    get sampleGcsFileSpecs(): GoogleDataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsList;
}
export interface GoogleDataCatalogEntryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#create GoogleDataCatalogEntry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#delete GoogleDataCatalogEntry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry#update GoogleDataCatalogEntry#update}
    */
    readonly update?: string;
}
export declare function googleDataCatalogEntryTimeoutsToTerraform(struct?: GoogleDataCatalogEntryTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataCatalogEntryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataCatalogEntryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataCatalogEntryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry google_data_catalog_entry}
*/
export declare class GoogleDataCatalogEntry extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_entry";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_data_catalog_entry google_data_catalog_entry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataCatalogEntryConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataCatalogEntryConfig);
    private _bigqueryDateShardedSpec;
    get bigqueryDateShardedSpec(): GoogleDataCatalogEntryBigqueryDateShardedSpecList;
    private _bigqueryTableSpec;
    get bigqueryTableSpec(): GoogleDataCatalogEntryBigqueryTableSpecList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _entryGroup?;
    get entryGroup(): string;
    set entryGroup(value: string);
    get entryGroupInput(): string | undefined;
    private _entryId?;
    get entryId(): string;
    set entryId(value: string);
    get entryIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get integratedSystem(): string;
    private _linkedResource?;
    get linkedResource(): string;
    set linkedResource(value: string);
    resetLinkedResource(): void;
    get linkedResourceInput(): string | undefined;
    get name(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _userSpecifiedSystem?;
    get userSpecifiedSystem(): string;
    set userSpecifiedSystem(value: string);
    resetUserSpecifiedSystem(): void;
    get userSpecifiedSystemInput(): string | undefined;
    private _userSpecifiedType?;
    get userSpecifiedType(): string;
    set userSpecifiedType(value: string);
    resetUserSpecifiedType(): void;
    get userSpecifiedTypeInput(): string | undefined;
    private _gcsFilesetSpec;
    get gcsFilesetSpec(): GoogleDataCatalogEntryGcsFilesetSpecOutputReference;
    putGcsFilesetSpec(value: GoogleDataCatalogEntryGcsFilesetSpec): void;
    resetGcsFilesetSpec(): void;
    get gcsFilesetSpecInput(): GoogleDataCatalogEntryGcsFilesetSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleDataCatalogEntryTimeoutsOutputReference;
    putTimeouts(value: GoogleDataCatalogEntryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataCatalogEntryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
