import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDataplexZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Description of the zone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#description GoogleDataplexZone#description}
    */
    readonly description?: string;
    /**
    * Optional. User friendly display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#display_name GoogleDataplexZone#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#id GoogleDataplexZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. User defined labels for the zone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#labels GoogleDataplexZone#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The lake for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#lake GoogleDataplexZone#lake}
    */
    readonly lake: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#location GoogleDataplexZone#location}
    */
    readonly location: string;
    /**
    * The name of the zone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#name GoogleDataplexZone#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#project GoogleDataplexZone#project}
    */
    readonly project?: string;
    /**
    * Required. Immutable. The type of the zone. Possible values: TYPE_UNSPECIFIED, RAW, CURATED
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#type GoogleDataplexZone#type}
    */
    readonly type: string;
    /**
    * discovery_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#discovery_spec GoogleDataplexZone#discovery_spec}
    */
    readonly discoverySpec: GoogleDataplexZoneDiscoverySpec;
    /**
    * resource_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#resource_spec GoogleDataplexZone#resource_spec}
    */
    readonly resourceSpec: GoogleDataplexZoneResourceSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#timeouts GoogleDataplexZone#timeouts}
    */
    readonly timeouts?: GoogleDataplexZoneTimeouts;
}
export interface GoogleDataplexZoneAssetStatus {
}
export declare function googleDataplexZoneAssetStatusToTerraform(struct?: GoogleDataplexZoneAssetStatus): any;
export declare class GoogleDataplexZoneAssetStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDataplexZoneAssetStatus | undefined;
    set internalValue(value: GoogleDataplexZoneAssetStatus | undefined);
    get activeAssets(): number;
    get securityPolicyApplyingAssets(): number;
    get updateTime(): string;
}
export declare class GoogleDataplexZoneAssetStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDataplexZoneAssetStatusOutputReference;
}
export interface GoogleDataplexZoneDiscoverySpecCsvOptions {
    /**
    * Optional. The delimiter being used to separate values. This defaults to ','.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#delimiter GoogleDataplexZone#delimiter}
    */
    readonly delimiter?: string;
    /**
    * Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#disable_type_inference GoogleDataplexZone#disable_type_inference}
    */
    readonly disableTypeInference?: boolean | cdktf.IResolvable;
    /**
    * Optional. The character encoding of the data. The default is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#encoding GoogleDataplexZone#encoding}
    */
    readonly encoding?: string;
    /**
    * Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#header_rows GoogleDataplexZone#header_rows}
    */
    readonly headerRows?: number;
}
export declare function googleDataplexZoneDiscoverySpecCsvOptionsToTerraform(struct?: GoogleDataplexZoneDiscoverySpecCsvOptionsOutputReference | GoogleDataplexZoneDiscoverySpecCsvOptions): any;
export declare class GoogleDataplexZoneDiscoverySpecCsvOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexZoneDiscoverySpecCsvOptions | undefined;
    set internalValue(value: GoogleDataplexZoneDiscoverySpecCsvOptions | undefined);
    private _delimiter?;
    get delimiter(): string;
    set delimiter(value: string);
    resetDelimiter(): void;
    get delimiterInput(): string | undefined;
    private _disableTypeInference?;
    get disableTypeInference(): boolean | cdktf.IResolvable;
    set disableTypeInference(value: boolean | cdktf.IResolvable);
    resetDisableTypeInference(): void;
    get disableTypeInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _headerRows?;
    get headerRows(): number;
    set headerRows(value: number);
    resetHeaderRows(): void;
    get headerRowsInput(): number | undefined;
}
export interface GoogleDataplexZoneDiscoverySpecJsonOptions {
    /**
    * Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#disable_type_inference GoogleDataplexZone#disable_type_inference}
    */
    readonly disableTypeInference?: boolean | cdktf.IResolvable;
    /**
    * Optional. The character encoding of the data. The default is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#encoding GoogleDataplexZone#encoding}
    */
    readonly encoding?: string;
}
export declare function googleDataplexZoneDiscoverySpecJsonOptionsToTerraform(struct?: GoogleDataplexZoneDiscoverySpecJsonOptionsOutputReference | GoogleDataplexZoneDiscoverySpecJsonOptions): any;
export declare class GoogleDataplexZoneDiscoverySpecJsonOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexZoneDiscoverySpecJsonOptions | undefined;
    set internalValue(value: GoogleDataplexZoneDiscoverySpecJsonOptions | undefined);
    private _disableTypeInference?;
    get disableTypeInference(): boolean | cdktf.IResolvable;
    set disableTypeInference(value: boolean | cdktf.IResolvable);
    resetDisableTypeInference(): void;
    get disableTypeInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
}
export interface GoogleDataplexZoneDiscoverySpec {
    /**
    * Required. Whether discovery is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#enabled GoogleDataplexZone#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#exclude_patterns GoogleDataplexZone#exclude_patterns}
    */
    readonly excludePatterns?: string[];
    /**
    * Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#include_patterns GoogleDataplexZone#include_patterns}
    */
    readonly includePatterns?: string[];
    /**
    * Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#schedule GoogleDataplexZone#schedule}
    */
    readonly schedule?: string;
    /**
    * csv_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#csv_options GoogleDataplexZone#csv_options}
    */
    readonly csvOptions?: GoogleDataplexZoneDiscoverySpecCsvOptions;
    /**
    * json_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#json_options GoogleDataplexZone#json_options}
    */
    readonly jsonOptions?: GoogleDataplexZoneDiscoverySpecJsonOptions;
}
export declare function googleDataplexZoneDiscoverySpecToTerraform(struct?: GoogleDataplexZoneDiscoverySpecOutputReference | GoogleDataplexZoneDiscoverySpec): any;
export declare class GoogleDataplexZoneDiscoverySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexZoneDiscoverySpec | undefined;
    set internalValue(value: GoogleDataplexZoneDiscoverySpec | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _excludePatterns?;
    get excludePatterns(): string[];
    set excludePatterns(value: string[]);
    resetExcludePatterns(): void;
    get excludePatternsInput(): string[] | undefined;
    private _includePatterns?;
    get includePatterns(): string[];
    set includePatterns(value: string[]);
    resetIncludePatterns(): void;
    get includePatternsInput(): string[] | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _csvOptions;
    get csvOptions(): GoogleDataplexZoneDiscoverySpecCsvOptionsOutputReference;
    putCsvOptions(value: GoogleDataplexZoneDiscoverySpecCsvOptions): void;
    resetCsvOptions(): void;
    get csvOptionsInput(): GoogleDataplexZoneDiscoverySpecCsvOptions | undefined;
    private _jsonOptions;
    get jsonOptions(): GoogleDataplexZoneDiscoverySpecJsonOptionsOutputReference;
    putJsonOptions(value: GoogleDataplexZoneDiscoverySpecJsonOptions): void;
    resetJsonOptions(): void;
    get jsonOptionsInput(): GoogleDataplexZoneDiscoverySpecJsonOptions | undefined;
}
export interface GoogleDataplexZoneResourceSpec {
    /**
    * Required. Immutable. The location type of the resources that are allowed to be attached to the assets within this zone. Possible values: LOCATION_TYPE_UNSPECIFIED, SINGLE_REGION, MULTI_REGION
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#location_type GoogleDataplexZone#location_type}
    */
    readonly locationType: string;
}
export declare function googleDataplexZoneResourceSpecToTerraform(struct?: GoogleDataplexZoneResourceSpecOutputReference | GoogleDataplexZoneResourceSpec): any;
export declare class GoogleDataplexZoneResourceSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexZoneResourceSpec | undefined;
    set internalValue(value: GoogleDataplexZoneResourceSpec | undefined);
    private _locationType?;
    get locationType(): string;
    set locationType(value: string);
    get locationTypeInput(): string | undefined;
}
export interface GoogleDataplexZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#create GoogleDataplexZone#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#delete GoogleDataplexZone#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone#update GoogleDataplexZone#update}
    */
    readonly update?: string;
}
export declare function googleDataplexZoneTimeoutsToTerraform(struct?: GoogleDataplexZoneTimeouts | cdktf.IResolvable): any;
export declare class GoogleDataplexZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDataplexZoneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDataplexZoneTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone google_dataplex_zone}
*/
export declare class GoogleDataplexZone extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_zone";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dataplex_zone google_dataplex_zone} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDataplexZoneConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDataplexZoneConfig);
    private _assetStatus;
    get assetStatus(): GoogleDataplexZoneAssetStatusList;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lake?;
    get lake(): string;
    set lake(value: string);
    get lakeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _discoverySpec;
    get discoverySpec(): GoogleDataplexZoneDiscoverySpecOutputReference;
    putDiscoverySpec(value: GoogleDataplexZoneDiscoverySpec): void;
    get discoverySpecInput(): GoogleDataplexZoneDiscoverySpec | undefined;
    private _resourceSpec;
    get resourceSpec(): GoogleDataplexZoneResourceSpecOutputReference;
    putResourceSpec(value: GoogleDataplexZoneResourceSpec): void;
    get resourceSpecInput(): GoogleDataplexZoneResourceSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleDataplexZoneTimeoutsOutputReference;
    putTimeouts(value: GoogleDataplexZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDataplexZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
