import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDatastreamConnectionProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The connection profile identifier.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#connection_profile_id GoogleDatastreamConnectionProfile#connection_profile_id}
    */
    readonly connectionProfileId: string;
    /**
    * Display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#display_name GoogleDatastreamConnectionProfile#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#id GoogleDatastreamConnectionProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#labels GoogleDatastreamConnectionProfile#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location this connection profile is located in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#location GoogleDatastreamConnectionProfile#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#project GoogleDatastreamConnectionProfile#project}
    */
    readonly project?: string;
    /**
    * bigquery_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#bigquery_profile GoogleDatastreamConnectionProfile#bigquery_profile}
    */
    readonly bigqueryProfile?: GoogleDatastreamConnectionProfileBigqueryProfile;
    /**
    * forward_ssh_connectivity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#forward_ssh_connectivity GoogleDatastreamConnectionProfile#forward_ssh_connectivity}
    */
    readonly forwardSshConnectivity?: GoogleDatastreamConnectionProfileForwardSshConnectivity;
    /**
    * gcs_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#gcs_profile GoogleDatastreamConnectionProfile#gcs_profile}
    */
    readonly gcsProfile?: GoogleDatastreamConnectionProfileGcsProfile;
    /**
    * mysql_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#mysql_profile GoogleDatastreamConnectionProfile#mysql_profile}
    */
    readonly mysqlProfile?: GoogleDatastreamConnectionProfileMysqlProfile;
    /**
    * oracle_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#oracle_profile GoogleDatastreamConnectionProfile#oracle_profile}
    */
    readonly oracleProfile?: GoogleDatastreamConnectionProfileOracleProfile;
    /**
    * postgresql_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#postgresql_profile GoogleDatastreamConnectionProfile#postgresql_profile}
    */
    readonly postgresqlProfile?: GoogleDatastreamConnectionProfilePostgresqlProfile;
    /**
    * private_connectivity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#private_connectivity GoogleDatastreamConnectionProfile#private_connectivity}
    */
    readonly privateConnectivity?: GoogleDatastreamConnectionProfilePrivateConnectivity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#timeouts GoogleDatastreamConnectionProfile#timeouts}
    */
    readonly timeouts?: GoogleDatastreamConnectionProfileTimeouts;
}
export interface GoogleDatastreamConnectionProfileBigqueryProfile {
}
export declare function googleDatastreamConnectionProfileBigqueryProfileToTerraform(struct?: GoogleDatastreamConnectionProfileBigqueryProfileOutputReference | GoogleDatastreamConnectionProfileBigqueryProfile): any;
export declare class GoogleDatastreamConnectionProfileBigqueryProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfileBigqueryProfile | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfileBigqueryProfile | undefined);
}
export interface GoogleDatastreamConnectionProfileForwardSshConnectivity {
    /**
    * Hostname for the SSH tunnel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#hostname GoogleDatastreamConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * SSH password.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#password GoogleDatastreamConnectionProfile#password}
    */
    readonly password?: string;
    /**
    * Port for the SSH tunnel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#port GoogleDatastreamConnectionProfile#port}
    */
    readonly port?: number;
    /**
    * SSH private key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#private_key GoogleDatastreamConnectionProfile#private_key}
    */
    readonly privateKey?: string;
    /**
    * Username for the SSH tunnel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#username GoogleDatastreamConnectionProfile#username}
    */
    readonly username: string;
}
export declare function googleDatastreamConnectionProfileForwardSshConnectivityToTerraform(struct?: GoogleDatastreamConnectionProfileForwardSshConnectivityOutputReference | GoogleDatastreamConnectionProfileForwardSshConnectivity): any;
export declare class GoogleDatastreamConnectionProfileForwardSshConnectivityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfileForwardSshConnectivity | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfileForwardSshConnectivity | undefined);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleDatastreamConnectionProfileGcsProfile {
    /**
    * The Cloud Storage bucket name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#bucket GoogleDatastreamConnectionProfile#bucket}
    */
    readonly bucket: string;
    /**
    * The root path inside the Cloud Storage bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#root_path GoogleDatastreamConnectionProfile#root_path}
    */
    readonly rootPath?: string;
}
export declare function googleDatastreamConnectionProfileGcsProfileToTerraform(struct?: GoogleDatastreamConnectionProfileGcsProfileOutputReference | GoogleDatastreamConnectionProfileGcsProfile): any;
export declare class GoogleDatastreamConnectionProfileGcsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfileGcsProfile | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfileGcsProfile | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _rootPath?;
    get rootPath(): string;
    set rootPath(value: string);
    resetRootPath(): void;
    get rootPathInput(): string | undefined;
}
export interface GoogleDatastreamConnectionProfileMysqlProfileSslConfig {
    /**
    * PEM-encoded certificate of the CA that signed the source database
  server's certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#ca_certificate GoogleDatastreamConnectionProfile#ca_certificate}
    */
    readonly caCertificate?: string;
    /**
    * PEM-encoded certificate that will be used by the replica to
  authenticate against the source database server. If this field
  is used then the 'clientKey' and the 'caCertificate' fields are
  mandatory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#client_certificate GoogleDatastreamConnectionProfile#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * PEM-encoded private key associated with the Client Certificate.
  If this field is used then the 'client_certificate' and the
  'ca_certificate' fields are mandatory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#client_key GoogleDatastreamConnectionProfile#client_key}
    */
    readonly clientKey?: string;
}
export declare function googleDatastreamConnectionProfileMysqlProfileSslConfigToTerraform(struct?: GoogleDatastreamConnectionProfileMysqlProfileSslConfigOutputReference | GoogleDatastreamConnectionProfileMysqlProfileSslConfig): any;
export declare class GoogleDatastreamConnectionProfileMysqlProfileSslConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfileMysqlProfileSslConfig | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfileMysqlProfileSslConfig | undefined);
    private _caCertificate?;
    get caCertificate(): string;
    set caCertificate(value: string);
    resetCaCertificate(): void;
    get caCertificateInput(): string | undefined;
    get caCertificateSet(): cdktf.IResolvable;
    private _clientCertificate?;
    get clientCertificate(): string;
    set clientCertificate(value: string);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    get clientCertificateSet(): cdktf.IResolvable;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    get clientKeySet(): cdktf.IResolvable;
}
export interface GoogleDatastreamConnectionProfileMysqlProfile {
    /**
    * Hostname for the MySQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#hostname GoogleDatastreamConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * Password for the MySQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#password GoogleDatastreamConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Port for the MySQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#port GoogleDatastreamConnectionProfile#port}
    */
    readonly port?: number;
    /**
    * Username for the MySQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#username GoogleDatastreamConnectionProfile#username}
    */
    readonly username: string;
    /**
    * ssl_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#ssl_config GoogleDatastreamConnectionProfile#ssl_config}
    */
    readonly sslConfig?: GoogleDatastreamConnectionProfileMysqlProfileSslConfig;
}
export declare function googleDatastreamConnectionProfileMysqlProfileToTerraform(struct?: GoogleDatastreamConnectionProfileMysqlProfileOutputReference | GoogleDatastreamConnectionProfileMysqlProfile): any;
export declare class GoogleDatastreamConnectionProfileMysqlProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfileMysqlProfile | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfileMysqlProfile | undefined);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _sslConfig;
    get sslConfig(): GoogleDatastreamConnectionProfileMysqlProfileSslConfigOutputReference;
    putSslConfig(value: GoogleDatastreamConnectionProfileMysqlProfileSslConfig): void;
    resetSslConfig(): void;
    get sslConfigInput(): GoogleDatastreamConnectionProfileMysqlProfileSslConfig | undefined;
}
export interface GoogleDatastreamConnectionProfileOracleProfile {
    /**
    * Connection string attributes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#connection_attributes GoogleDatastreamConnectionProfile#connection_attributes}
    */
    readonly connectionAttributes?: {
        [key: string]: string;
    };
    /**
    * Database for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#database_service GoogleDatastreamConnectionProfile#database_service}
    */
    readonly databaseService: string;
    /**
    * Hostname for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#hostname GoogleDatastreamConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * Password for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#password GoogleDatastreamConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Port for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#port GoogleDatastreamConnectionProfile#port}
    */
    readonly port?: number;
    /**
    * Username for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#username GoogleDatastreamConnectionProfile#username}
    */
    readonly username: string;
}
export declare function googleDatastreamConnectionProfileOracleProfileToTerraform(struct?: GoogleDatastreamConnectionProfileOracleProfileOutputReference | GoogleDatastreamConnectionProfileOracleProfile): any;
export declare class GoogleDatastreamConnectionProfileOracleProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfileOracleProfile | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfileOracleProfile | undefined);
    private _connectionAttributes?;
    get connectionAttributes(): {
        [key: string]: string;
    };
    set connectionAttributes(value: {
        [key: string]: string;
    });
    resetConnectionAttributes(): void;
    get connectionAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _databaseService?;
    get databaseService(): string;
    set databaseService(value: string);
    get databaseServiceInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleDatastreamConnectionProfilePostgresqlProfile {
    /**
    * Database for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#database GoogleDatastreamConnectionProfile#database}
    */
    readonly database: string;
    /**
    * Hostname for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#hostname GoogleDatastreamConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * Password for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#password GoogleDatastreamConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Port for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#port GoogleDatastreamConnectionProfile#port}
    */
    readonly port?: number;
    /**
    * Username for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#username GoogleDatastreamConnectionProfile#username}
    */
    readonly username: string;
}
export declare function googleDatastreamConnectionProfilePostgresqlProfileToTerraform(struct?: GoogleDatastreamConnectionProfilePostgresqlProfileOutputReference | GoogleDatastreamConnectionProfilePostgresqlProfile): any;
export declare class GoogleDatastreamConnectionProfilePostgresqlProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfilePostgresqlProfile | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfilePostgresqlProfile | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleDatastreamConnectionProfilePrivateConnectivity {
    /**
    * A reference to a private connection resource. Format: 'projects/{project}/locations/{location}/privateConnections/{name}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#private_connection GoogleDatastreamConnectionProfile#private_connection}
    */
    readonly privateConnection: string;
}
export declare function googleDatastreamConnectionProfilePrivateConnectivityToTerraform(struct?: GoogleDatastreamConnectionProfilePrivateConnectivityOutputReference | GoogleDatastreamConnectionProfilePrivateConnectivity): any;
export declare class GoogleDatastreamConnectionProfilePrivateConnectivityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfilePrivateConnectivity | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfilePrivateConnectivity | undefined);
    private _privateConnection?;
    get privateConnection(): string;
    set privateConnection(value: string);
    get privateConnectionInput(): string | undefined;
}
export interface GoogleDatastreamConnectionProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#create GoogleDatastreamConnectionProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#delete GoogleDatastreamConnectionProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile#update GoogleDatastreamConnectionProfile#update}
    */
    readonly update?: string;
}
export declare function googleDatastreamConnectionProfileTimeoutsToTerraform(struct?: GoogleDatastreamConnectionProfileTimeouts | cdktf.IResolvable): any;
export declare class GoogleDatastreamConnectionProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamConnectionProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDatastreamConnectionProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile google_datastream_connection_profile}
*/
export declare class GoogleDatastreamConnectionProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_datastream_connection_profile";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_connection_profile google_datastream_connection_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDatastreamConnectionProfileConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDatastreamConnectionProfileConfig);
    private _connectionProfileId?;
    get connectionProfileId(): string;
    set connectionProfileId(value: string);
    get connectionProfileIdInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _bigqueryProfile;
    get bigqueryProfile(): GoogleDatastreamConnectionProfileBigqueryProfileOutputReference;
    putBigqueryProfile(value: GoogleDatastreamConnectionProfileBigqueryProfile): void;
    resetBigqueryProfile(): void;
    get bigqueryProfileInput(): GoogleDatastreamConnectionProfileBigqueryProfile | undefined;
    private _forwardSshConnectivity;
    get forwardSshConnectivity(): GoogleDatastreamConnectionProfileForwardSshConnectivityOutputReference;
    putForwardSshConnectivity(value: GoogleDatastreamConnectionProfileForwardSshConnectivity): void;
    resetForwardSshConnectivity(): void;
    get forwardSshConnectivityInput(): GoogleDatastreamConnectionProfileForwardSshConnectivity | undefined;
    private _gcsProfile;
    get gcsProfile(): GoogleDatastreamConnectionProfileGcsProfileOutputReference;
    putGcsProfile(value: GoogleDatastreamConnectionProfileGcsProfile): void;
    resetGcsProfile(): void;
    get gcsProfileInput(): GoogleDatastreamConnectionProfileGcsProfile | undefined;
    private _mysqlProfile;
    get mysqlProfile(): GoogleDatastreamConnectionProfileMysqlProfileOutputReference;
    putMysqlProfile(value: GoogleDatastreamConnectionProfileMysqlProfile): void;
    resetMysqlProfile(): void;
    get mysqlProfileInput(): GoogleDatastreamConnectionProfileMysqlProfile | undefined;
    private _oracleProfile;
    get oracleProfile(): GoogleDatastreamConnectionProfileOracleProfileOutputReference;
    putOracleProfile(value: GoogleDatastreamConnectionProfileOracleProfile): void;
    resetOracleProfile(): void;
    get oracleProfileInput(): GoogleDatastreamConnectionProfileOracleProfile | undefined;
    private _postgresqlProfile;
    get postgresqlProfile(): GoogleDatastreamConnectionProfilePostgresqlProfileOutputReference;
    putPostgresqlProfile(value: GoogleDatastreamConnectionProfilePostgresqlProfile): void;
    resetPostgresqlProfile(): void;
    get postgresqlProfileInput(): GoogleDatastreamConnectionProfilePostgresqlProfile | undefined;
    private _privateConnectivity;
    get privateConnectivity(): GoogleDatastreamConnectionProfilePrivateConnectivityOutputReference;
    putPrivateConnectivity(value: GoogleDatastreamConnectionProfilePrivateConnectivity): void;
    resetPrivateConnectivity(): void;
    get privateConnectivityInput(): GoogleDatastreamConnectionProfilePrivateConnectivity | undefined;
    private _timeouts;
    get timeouts(): GoogleDatastreamConnectionProfileTimeoutsOutputReference;
    putTimeouts(value: GoogleDatastreamConnectionProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDatastreamConnectionProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
