import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDatastreamPrivateConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#display_name GoogleDatastreamPrivateConnection#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#id GoogleDatastreamPrivateConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#labels GoogleDatastreamPrivateConnection#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location this private connection is located in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#location GoogleDatastreamPrivateConnection#location}
    */
    readonly location: string;
    /**
    * The private connectivity identifier.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#private_connection_id GoogleDatastreamPrivateConnection#private_connection_id}
    */
    readonly privateConnectionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#project GoogleDatastreamPrivateConnection#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#timeouts GoogleDatastreamPrivateConnection#timeouts}
    */
    readonly timeouts?: GoogleDatastreamPrivateConnectionTimeouts;
    /**
    * vpc_peering_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#vpc_peering_config GoogleDatastreamPrivateConnection#vpc_peering_config}
    */
    readonly vpcPeeringConfig: GoogleDatastreamPrivateConnectionVpcPeeringConfig;
}
export interface GoogleDatastreamPrivateConnectionError {
}
export declare function googleDatastreamPrivateConnectionErrorToTerraform(struct?: GoogleDatastreamPrivateConnectionError): any;
export declare class GoogleDatastreamPrivateConnectionErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDatastreamPrivateConnectionError | undefined;
    set internalValue(value: GoogleDatastreamPrivateConnectionError | undefined);
    private _details;
    get details(): cdktf.StringMap;
    get message(): string;
}
export declare class GoogleDatastreamPrivateConnectionErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDatastreamPrivateConnectionErrorOutputReference;
}
export interface GoogleDatastreamPrivateConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#create GoogleDatastreamPrivateConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#delete GoogleDatastreamPrivateConnection#delete}
    */
    readonly delete?: string;
}
export declare function googleDatastreamPrivateConnectionTimeoutsToTerraform(struct?: GoogleDatastreamPrivateConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleDatastreamPrivateConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamPrivateConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDatastreamPrivateConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface GoogleDatastreamPrivateConnectionVpcPeeringConfig {
    /**
    * A free subnet for peering. (CIDR of /29)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#subnet GoogleDatastreamPrivateConnection#subnet}
    */
    readonly subnet: string;
    /**
    * Fully qualified name of the VPC that Datastream will peer to.
  Format: projects/{project}/global/{networks}/{name}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection#vpc GoogleDatastreamPrivateConnection#vpc}
    */
    readonly vpc: string;
}
export declare function googleDatastreamPrivateConnectionVpcPeeringConfigToTerraform(struct?: GoogleDatastreamPrivateConnectionVpcPeeringConfigOutputReference | GoogleDatastreamPrivateConnectionVpcPeeringConfig): any;
export declare class GoogleDatastreamPrivateConnectionVpcPeeringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDatastreamPrivateConnectionVpcPeeringConfig | undefined;
    set internalValue(value: GoogleDatastreamPrivateConnectionVpcPeeringConfig | undefined);
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    get subnetInput(): string | undefined;
    private _vpc?;
    get vpc(): string;
    set vpc(value: string);
    get vpcInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection google_datastream_private_connection}
*/
export declare class GoogleDatastreamPrivateConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_datastream_private_connection";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_datastream_private_connection google_datastream_private_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDatastreamPrivateConnectionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDatastreamPrivateConnectionConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _error;
    get error(): GoogleDatastreamPrivateConnectionErrorList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _privateConnectionId?;
    get privateConnectionId(): string;
    set privateConnectionId(value: string);
    get privateConnectionIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _timeouts;
    get timeouts(): GoogleDatastreamPrivateConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleDatastreamPrivateConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDatastreamPrivateConnectionTimeouts | undefined;
    private _vpcPeeringConfig;
    get vpcPeeringConfig(): GoogleDatastreamPrivateConnectionVpcPeeringConfigOutputReference;
    putVpcPeeringConfig(value: GoogleDatastreamPrivateConnectionVpcPeeringConfig): void;
    get vpcPeeringConfigInput(): GoogleDatastreamPrivateConnectionVpcPeeringConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
