import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxAgentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#avatar_uri GoogleDialogflowCxAgent#avatar_uri}
    */
    readonly avatarUri?: string;
    /**
    * The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
  for a list of the currently supported language codes. This field cannot be updated after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#default_language_code GoogleDialogflowCxAgent#default_language_code}
    */
    readonly defaultLanguageCode: string;
    /**
    * The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#description GoogleDialogflowCxAgent#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the agent, unique within the location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#display_name GoogleDialogflowCxAgent#display_name}
    */
    readonly displayName: string;
    /**
    * Indicates if automatic spell correction is enabled in detect intent requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#enable_spell_correction GoogleDialogflowCxAgent#enable_spell_correction}
    */
    readonly enableSpellCorrection?: boolean | cdktf.IResolvable;
    /**
    * Determines whether this agent should log conversation queries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#enable_stackdriver_logging GoogleDialogflowCxAgent#enable_stackdriver_logging}
    */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#id GoogleDialogflowCxAgent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the location this agent is located in.
  
  ~> **Note:** The first time you are deploying an Agent in your project you must configure location settings.
   This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
   Another options is to use global location so you don't need to manually configure location settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#location GoogleDialogflowCxAgent#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#project GoogleDialogflowCxAgent#project}
    */
    readonly project?: string;
    /**
    * Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#security_settings GoogleDialogflowCxAgent#security_settings}
    */
    readonly securitySettings?: string;
    /**
    * The list of all languages supported by this agent (except for the default_language_code).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#supported_language_codes GoogleDialogflowCxAgent#supported_language_codes}
    */
    readonly supportedLanguageCodes?: string[];
    /**
    * The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
  Europe/Paris.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#time_zone GoogleDialogflowCxAgent#time_zone}
    */
    readonly timeZone: string;
    /**
    * speech_to_text_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#speech_to_text_settings GoogleDialogflowCxAgent#speech_to_text_settings}
    */
    readonly speechToTextSettings?: GoogleDialogflowCxAgentSpeechToTextSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#timeouts GoogleDialogflowCxAgent#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxAgentTimeouts;
}
export interface GoogleDialogflowCxAgentSpeechToTextSettings {
    /**
    * Whether to use speech adaptation for speech recognition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#enable_speech_adaptation GoogleDialogflowCxAgent#enable_speech_adaptation}
    */
    readonly enableSpeechAdaptation?: boolean | cdktf.IResolvable;
}
export declare function googleDialogflowCxAgentSpeechToTextSettingsToTerraform(struct?: GoogleDialogflowCxAgentSpeechToTextSettingsOutputReference | GoogleDialogflowCxAgentSpeechToTextSettings): any;
export declare class GoogleDialogflowCxAgentSpeechToTextSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentSpeechToTextSettings | undefined;
    set internalValue(value: GoogleDialogflowCxAgentSpeechToTextSettings | undefined);
    private _enableSpeechAdaptation?;
    get enableSpeechAdaptation(): boolean | cdktf.IResolvable;
    set enableSpeechAdaptation(value: boolean | cdktf.IResolvable);
    resetEnableSpeechAdaptation(): void;
    get enableSpeechAdaptationInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleDialogflowCxAgentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#create GoogleDialogflowCxAgent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#delete GoogleDialogflowCxAgent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent#update GoogleDialogflowCxAgent#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxAgentTimeoutsToTerraform(struct?: GoogleDialogflowCxAgentTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxAgentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxAgentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxAgentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent google_dialogflow_cx_agent}
*/
export declare class GoogleDialogflowCxAgent extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_agent";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_agent google_dialogflow_cx_agent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxAgentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxAgentConfig);
    private _avatarUri?;
    get avatarUri(): string;
    set avatarUri(value: string);
    resetAvatarUri(): void;
    get avatarUriInput(): string | undefined;
    private _defaultLanguageCode?;
    get defaultLanguageCode(): string;
    set defaultLanguageCode(value: string);
    get defaultLanguageCodeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableSpellCorrection?;
    get enableSpellCorrection(): boolean | cdktf.IResolvable;
    set enableSpellCorrection(value: boolean | cdktf.IResolvable);
    resetEnableSpellCorrection(): void;
    get enableSpellCorrectionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverLogging?;
    get enableStackdriverLogging(): boolean | cdktf.IResolvable;
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverLogging(): void;
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _securitySettings?;
    get securitySettings(): string;
    set securitySettings(value: string);
    resetSecuritySettings(): void;
    get securitySettingsInput(): string | undefined;
    get startFlow(): string;
    private _supportedLanguageCodes?;
    get supportedLanguageCodes(): string[];
    set supportedLanguageCodes(value: string[]);
    resetSupportedLanguageCodes(): void;
    get supportedLanguageCodesInput(): string[] | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _speechToTextSettings;
    get speechToTextSettings(): GoogleDialogflowCxAgentSpeechToTextSettingsOutputReference;
    putSpeechToTextSettings(value: GoogleDialogflowCxAgentSpeechToTextSettings): void;
    resetSpeechToTextSettings(): void;
    get speechToTextSettingsInput(): GoogleDialogflowCxAgentSpeechToTextSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxAgentTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxAgentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxAgentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
