import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxFlowConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#description GoogleDialogflowCxFlow#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#display_name GoogleDialogflowCxFlow#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#id GoogleDialogflowCxFlow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The language of the following fields in flow:
  Flow.event_handlers.trigger_fulfillment.messages
  Flow.event_handlers.trigger_fulfillment.conditional_cases
  Flow.transition_routes.trigger_fulfillment.messages
  Flow.transition_routes.trigger_fulfillment.conditional_cases
  If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#language_code GoogleDialogflowCxFlow#language_code}
    */
    readonly languageCode?: string;
    /**
    * The agent to create a flow for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#parent GoogleDialogflowCxFlow#parent}
    */
    readonly parent?: string;
    /**
    * A flow's transition route group serve two purposes:
  They are responsible for matching the user's first utterances in the flow.
  They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
  Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#transition_route_groups GoogleDialogflowCxFlow#transition_route_groups}
    */
    readonly transitionRouteGroups?: string[];
    /**
    * event_handlers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#event_handlers GoogleDialogflowCxFlow#event_handlers}
    */
    readonly eventHandlers?: GoogleDialogflowCxFlowEventHandlers[] | cdktf.IResolvable;
    /**
    * nlu_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#nlu_settings GoogleDialogflowCxFlow#nlu_settings}
    */
    readonly nluSettings?: GoogleDialogflowCxFlowNluSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#timeouts GoogleDialogflowCxFlow#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxFlowTimeouts;
    /**
    * transition_routes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#transition_routes GoogleDialogflowCxFlow#transition_routes}
    */
    readonly transitionRoutes?: GoogleDialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _text;
    get text(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxFlowEventHandlersTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#return_partial_responses GoogleDialogflowCxFlow#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#tag GoogleDialogflowCxFlow#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#webhook GoogleDialogflowCxFlow#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#messages GoogleDialogflowCxFlow#messages}
    */
    readonly messages?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxFlowEventHandlersTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference | GoogleDialogflowCxFlowEventHandlersTriggerFulfillment): any;
export declare class GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined;
}
export interface GoogleDialogflowCxFlowEventHandlers {
    /**
    * The name of the event to handle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#event GoogleDialogflowCxFlow#event}
    */
    readonly event?: string;
    /**
    * The target flow to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#target_flow GoogleDialogflowCxFlow#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#target_page GoogleDialogflowCxFlow#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#trigger_fulfillment GoogleDialogflowCxFlow#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxFlowEventHandlersTriggerFulfillment;
}
export declare function googleDialogflowCxFlowEventHandlersToTerraform(struct?: GoogleDialogflowCxFlowEventHandlers | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowEventHandlersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowEventHandlers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowEventHandlers | cdktf.IResolvable | undefined);
    private _event?;
    get event(): string;
    set event(value: string);
    resetEvent(): void;
    get eventInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxFlowEventHandlersTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxFlowEventHandlersTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxFlowEventHandlersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowEventHandlers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowEventHandlersOutputReference;
}
export interface GoogleDialogflowCxFlowNluSettings {
    /**
    * To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold.
  If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#classification_threshold GoogleDialogflowCxFlow#classification_threshold}
    */
    readonly classificationThreshold?: number;
    /**
    * Indicates NLU model training mode.
  * MODEL_TRAINING_MODE_AUTOMATIC: NLU model training is automatically triggered when a flow gets modified. User can also manually trigger model training in this mode.
  * MODEL_TRAINING_MODE_MANUAL: User needs to manually trigger NLU model training. Best for large flows whose models take long time to train. Possible values: ["MODEL_TRAINING_MODE_AUTOMATIC", "MODEL_TRAINING_MODE_MANUAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#model_training_mode GoogleDialogflowCxFlow#model_training_mode}
    */
    readonly modelTrainingMode?: string;
    /**
    * Indicates the type of NLU model.
  * MODEL_TYPE_STANDARD: Use standard NLU model.
  * MODEL_TYPE_ADVANCED: Use advanced NLU model. Possible values: ["MODEL_TYPE_STANDARD", "MODEL_TYPE_ADVANCED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#model_type GoogleDialogflowCxFlow#model_type}
    */
    readonly modelType?: string;
}
export declare function googleDialogflowCxFlowNluSettingsToTerraform(struct?: GoogleDialogflowCxFlowNluSettingsOutputReference | GoogleDialogflowCxFlowNluSettings): any;
export declare class GoogleDialogflowCxFlowNluSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowNluSettings | undefined;
    set internalValue(value: GoogleDialogflowCxFlowNluSettings | undefined);
    private _classificationThreshold?;
    get classificationThreshold(): number;
    set classificationThreshold(value: number);
    resetClassificationThreshold(): void;
    get classificationThresholdInput(): number | undefined;
    private _modelTrainingMode?;
    get modelTrainingMode(): string;
    set modelTrainingMode(value: string);
    resetModelTrainingMode(): void;
    get modelTrainingModeInput(): string | undefined;
    private _modelType?;
    get modelType(): string;
    set modelType(value: string);
    resetModelType(): void;
    get modelTypeInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#create GoogleDialogflowCxFlow#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#delete GoogleDialogflowCxFlow#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#update GoogleDialogflowCxFlow#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxFlowTimeoutsToTerraform(struct?: GoogleDialogflowCxFlowTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: string[];
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#text GoogleDialogflowCxFlow#text}
    */
    readonly text?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _text;
    get text(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference;
    putText(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined;
}
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputReference;
}
export interface GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#return_partial_responses GoogleDialogflowCxFlow#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#tag GoogleDialogflowCxFlow#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#webhook GoogleDialogflowCxFlow#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#messages GoogleDialogflowCxFlow#messages}
    */
    readonly messages?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxFlowTransitionRoutesTriggerFulfillmentToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages;
    get messages(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesList;
    putMessages(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
export interface GoogleDialogflowCxFlowTransitionRoutes {
    /**
    * The condition to evaluate against form parameters or session parameters.
  At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#condition GoogleDialogflowCxFlow#condition}
    */
    readonly condition?: string;
    /**
    * The unique identifier of an Intent.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#intent GoogleDialogflowCxFlow#intent}
    */
    readonly intent?: string;
    /**
    * The target flow to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#target_flow GoogleDialogflowCxFlow#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#target_page GoogleDialogflowCxFlow#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow#trigger_fulfillment GoogleDialogflowCxFlow#trigger_fulfillment}
    */
    readonly triggerFulfillment?: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment;
}
export declare function googleDialogflowCxFlowTransitionRoutesToTerraform(struct?: GoogleDialogflowCxFlowTransitionRoutes | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxFlowTransitionRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxFlowTransitionRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxFlowTransitionRoutes | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _intent?;
    get intent(): string;
    set intent(value: string);
    resetIntent(): void;
    get intentInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): GoogleDialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined;
}
export declare class GoogleDialogflowCxFlowTransitionRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxFlowTransitionRoutesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow google_dialogflow_cx_flow}
*/
export declare class GoogleDialogflowCxFlow extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_flow";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_flow google_dialogflow_cx_flow} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxFlowConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxFlowConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    get transitionRouteGroups(): string[];
    set transitionRouteGroups(value: string[]);
    resetTransitionRouteGroups(): void;
    get transitionRouteGroupsInput(): string[] | undefined;
    private _eventHandlers;
    get eventHandlers(): GoogleDialogflowCxFlowEventHandlersList;
    putEventHandlers(value: GoogleDialogflowCxFlowEventHandlers[] | cdktf.IResolvable): void;
    resetEventHandlers(): void;
    get eventHandlersInput(): cdktf.IResolvable | GoogleDialogflowCxFlowEventHandlers[] | undefined;
    private _nluSettings;
    get nluSettings(): GoogleDialogflowCxFlowNluSettingsOutputReference;
    putNluSettings(value: GoogleDialogflowCxFlowNluSettings): void;
    resetNluSettings(): void;
    get nluSettingsInput(): GoogleDialogflowCxFlowNluSettings | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxFlowTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxFlowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxFlowTimeouts | undefined;
    private _transitionRoutes;
    get transitionRoutes(): GoogleDialogflowCxFlowTransitionRoutesList;
    putTransitionRoutes(value: GoogleDialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable): void;
    resetTransitionRoutes(): void;
    get transitionRoutesInput(): cdktf.IResolvable | GoogleDialogflowCxFlowTransitionRoutes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
