import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowCxIntentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#description GoogleDialogflowCxIntent#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the intent, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#display_name GoogleDialogflowCxIntent#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#id GoogleDialogflowCxIntent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
  Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#is_fallback GoogleDialogflowCxIntent#is_fallback}
    */
    readonly isFallback?: boolean | cdktf.IResolvable;
    /**
    * The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
  Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
  An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#labels GoogleDialogflowCxIntent#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The language of the following fields in intent:
  Intent.training_phrases.parts.text
  If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#language_code GoogleDialogflowCxIntent#language_code}
    */
    readonly languageCode?: string;
    /**
    * The agent to create an intent for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#parent GoogleDialogflowCxIntent#parent}
    */
    readonly parent?: string;
    /**
    * The priority of this intent. Higher numbers represent higher priorities.
  If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
  If the supplied value is negative, the intent is ignored in runtime detect intent requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#priority GoogleDialogflowCxIntent#priority}
    */
    readonly priority?: number;
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#parameters GoogleDialogflowCxIntent#parameters}
    */
    readonly parameters?: GoogleDialogflowCxIntentParameters[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#timeouts GoogleDialogflowCxIntent#timeouts}
    */
    readonly timeouts?: GoogleDialogflowCxIntentTimeouts;
    /**
    * training_phrases block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#training_phrases GoogleDialogflowCxIntent#training_phrases}
    */
    readonly trainingPhrases?: GoogleDialogflowCxIntentTrainingPhrases[] | cdktf.IResolvable;
}
export interface GoogleDialogflowCxIntentParameters {
    /**
    * The entity type of the parameter.
  Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#entity_type GoogleDialogflowCxIntent#entity_type}
    */
    readonly entityType: string;
    /**
    * The unique identifier of the parameter. This field is used by training phrases to annotate their parts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#id GoogleDialogflowCxIntent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Indicates whether the parameter represents a list of values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#is_list GoogleDialogflowCxIntent#is_list}
    */
    readonly isList?: boolean | cdktf.IResolvable;
    /**
    * Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging.
  Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#redact GoogleDialogflowCxIntent#redact}
    */
    readonly redact?: boolean | cdktf.IResolvable;
}
export declare function googleDialogflowCxIntentParametersToTerraform(struct?: GoogleDialogflowCxIntentParameters | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxIntentParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxIntentParameters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxIntentParameters | cdktf.IResolvable | undefined);
    private _entityType?;
    get entityType(): string;
    set entityType(value: string);
    get entityTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _isList?;
    get isList(): boolean | cdktf.IResolvable;
    set isList(value: boolean | cdktf.IResolvable);
    resetIsList(): void;
    get isListInput(): boolean | cdktf.IResolvable | undefined;
    private _redact?;
    get redact(): boolean | cdktf.IResolvable;
    set redact(value: boolean | cdktf.IResolvable);
    resetRedact(): void;
    get redactInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleDialogflowCxIntentParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxIntentParameters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxIntentParametersOutputReference;
}
export interface GoogleDialogflowCxIntentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#create GoogleDialogflowCxIntent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#delete GoogleDialogflowCxIntent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#update GoogleDialogflowCxIntent#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowCxIntentTimeoutsToTerraform(struct?: GoogleDialogflowCxIntentTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxIntentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowCxIntentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxIntentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleDialogflowCxIntentTrainingPhrasesParts {
    /**
    * The parameter used to annotate this part of the training phrase. This field is required for annotated parts of the training phrase.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#parameter_id GoogleDialogflowCxIntent#parameter_id}
    */
    readonly parameterId?: string;
    /**
    * The text for this part.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#text GoogleDialogflowCxIntent#text}
    */
    readonly text: string;
}
export declare function googleDialogflowCxIntentTrainingPhrasesPartsToTerraform(struct?: GoogleDialogflowCxIntentTrainingPhrasesParts | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxIntentTrainingPhrasesPartsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxIntentTrainingPhrasesParts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxIntentTrainingPhrasesParts | cdktf.IResolvable | undefined);
    private _parameterId?;
    get parameterId(): string;
    set parameterId(value: string);
    resetParameterId(): void;
    get parameterIdInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    get textInput(): string | undefined;
}
export declare class GoogleDialogflowCxIntentTrainingPhrasesPartsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxIntentTrainingPhrasesParts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxIntentTrainingPhrasesPartsOutputReference;
}
export interface GoogleDialogflowCxIntentTrainingPhrases {
    /**
    * Indicates how many times this example was added to the intent.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#repeat_count GoogleDialogflowCxIntent#repeat_count}
    */
    readonly repeatCount?: number;
    /**
    * parts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent#parts GoogleDialogflowCxIntent#parts}
    */
    readonly parts: GoogleDialogflowCxIntentTrainingPhrasesParts[] | cdktf.IResolvable;
}
export declare function googleDialogflowCxIntentTrainingPhrasesToTerraform(struct?: GoogleDialogflowCxIntentTrainingPhrases | cdktf.IResolvable): any;
export declare class GoogleDialogflowCxIntentTrainingPhrasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowCxIntentTrainingPhrases | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowCxIntentTrainingPhrases | cdktf.IResolvable | undefined);
    get id(): string;
    private _repeatCount?;
    get repeatCount(): number;
    set repeatCount(value: number);
    resetRepeatCount(): void;
    get repeatCountInput(): number | undefined;
    private _parts;
    get parts(): GoogleDialogflowCxIntentTrainingPhrasesPartsList;
    putParts(value: GoogleDialogflowCxIntentTrainingPhrasesParts[] | cdktf.IResolvable): void;
    get partsInput(): cdktf.IResolvable | GoogleDialogflowCxIntentTrainingPhrasesParts[] | undefined;
}
export declare class GoogleDialogflowCxIntentTrainingPhrasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowCxIntentTrainingPhrases[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowCxIntentTrainingPhrasesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent google_dialogflow_cx_intent}
*/
export declare class GoogleDialogflowCxIntent extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_intent";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_cx_intent google_dialogflow_cx_intent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowCxIntentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowCxIntentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isFallback?;
    get isFallback(): boolean | cdktf.IResolvable;
    set isFallback(value: boolean | cdktf.IResolvable);
    resetIsFallback(): void;
    get isFallbackInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _parameters;
    get parameters(): GoogleDialogflowCxIntentParametersList;
    putParameters(value: GoogleDialogflowCxIntentParameters[] | cdktf.IResolvable): void;
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | GoogleDialogflowCxIntentParameters[] | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowCxIntentTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowCxIntentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowCxIntentTimeouts | undefined;
    private _trainingPhrases;
    get trainingPhrases(): GoogleDialogflowCxIntentTrainingPhrasesList;
    putTrainingPhrases(value: GoogleDialogflowCxIntentTrainingPhrases[] | cdktf.IResolvable): void;
    resetTrainingPhrases(): void;
    get trainingPhrasesInput(): cdktf.IResolvable | GoogleDialogflowCxIntentTrainingPhrases[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
