import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDialogflowEntityTypeConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of this entity type to be displayed on the console.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#display_name GoogleDialogflowEntityType#display_name}
    */
    readonly displayName: string;
    /**
    * Enables fuzzy entity extraction during classification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#enable_fuzzy_extraction GoogleDialogflowEntityType#enable_fuzzy_extraction}
    */
    readonly enableFuzzyExtraction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#id GoogleDialogflowEntityType#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Indicates the kind of entity type.
  * KIND_MAP: Map entity types allow mapping of a group of synonyms to a reference value.
  * KIND_LIST: List entity types contain a set of entries that do not map to reference values. However, list entity
  types can contain references to other entity types (with or without aliases).
  * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values. Possible values: ["KIND_MAP", "KIND_LIST", "KIND_REGEXP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#kind GoogleDialogflowEntityType#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#project GoogleDialogflowEntityType#project}
    */
    readonly project?: string;
    /**
    * entities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#entities GoogleDialogflowEntityType#entities}
    */
    readonly entities?: GoogleDialogflowEntityTypeEntities[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#timeouts GoogleDialogflowEntityType#timeouts}
    */
    readonly timeouts?: GoogleDialogflowEntityTypeTimeouts;
}
export interface GoogleDialogflowEntityTypeEntities {
    /**
    * A collection of value synonyms. For example, if the entity type is vegetable, and value is scallions, a synonym
  could be green onions.
  For KIND_LIST entity types:
  * This collection must contain exactly one synonym equal to value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#synonyms GoogleDialogflowEntityType#synonyms}
    */
    readonly synonyms: string[];
    /**
    * The primary value associated with this entity entry. For example, if the entity type is vegetable, the value
  could be scallions.
  For KIND_MAP entity types:
  * A reference value to be used in place of synonyms.
  For KIND_LIST entity types:
  * A string that can contain references to other entity types (with or without aliases).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#value GoogleDialogflowEntityType#value}
    */
    readonly value: string;
}
export declare function googleDialogflowEntityTypeEntitiesToTerraform(struct?: GoogleDialogflowEntityTypeEntities | cdktf.IResolvable): any;
export declare class GoogleDialogflowEntityTypeEntitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDialogflowEntityTypeEntities | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowEntityTypeEntities | cdktf.IResolvable | undefined);
    private _synonyms?;
    get synonyms(): string[];
    set synonyms(value: string[]);
    get synonymsInput(): string[] | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleDialogflowEntityTypeEntitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDialogflowEntityTypeEntities[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDialogflowEntityTypeEntitiesOutputReference;
}
export interface GoogleDialogflowEntityTypeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#create GoogleDialogflowEntityType#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#delete GoogleDialogflowEntityType#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type#update GoogleDialogflowEntityType#update}
    */
    readonly update?: string;
}
export declare function googleDialogflowEntityTypeTimeoutsToTerraform(struct?: GoogleDialogflowEntityTypeTimeouts | cdktf.IResolvable): any;
export declare class GoogleDialogflowEntityTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDialogflowEntityTypeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDialogflowEntityTypeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type google_dialogflow_entity_type}
*/
export declare class GoogleDialogflowEntityType extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_entity_type";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dialogflow_entity_type google_dialogflow_entity_type} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDialogflowEntityTypeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDialogflowEntityTypeConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableFuzzyExtraction?;
    get enableFuzzyExtraction(): boolean | cdktf.IResolvable;
    set enableFuzzyExtraction(value: boolean | cdktf.IResolvable);
    resetEnableFuzzyExtraction(): void;
    get enableFuzzyExtractionInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _entities;
    get entities(): GoogleDialogflowEntityTypeEntitiesList;
    putEntities(value: GoogleDialogflowEntityTypeEntities[] | cdktf.IResolvable): void;
    resetEntities(): void;
    get entitiesInput(): cdktf.IResolvable | GoogleDialogflowEntityTypeEntities[] | undefined;
    private _timeouts;
    get timeouts(): GoogleDialogflowEntityTypeTimeoutsOutputReference;
    putTimeouts(value: GoogleDialogflowEntityTypeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDialogflowEntityTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
