import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDnsResponsePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the response policy, such as 'My new response policy'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#description GoogleDnsResponsePolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#id GoogleDnsResponsePolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#project GoogleDnsResponsePolicy#project}
    */
    readonly project?: string;
    /**
    * The user assigned name for this Response Policy, such as 'myresponsepolicy'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#response_policy_name GoogleDnsResponsePolicy#response_policy_name}
    */
    readonly responsePolicyName: string;
    /**
    * gke_clusters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#gke_clusters GoogleDnsResponsePolicy#gke_clusters}
    */
    readonly gkeClusters?: GoogleDnsResponsePolicyGkeClusters[] | cdktf.IResolvable;
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#networks GoogleDnsResponsePolicy#networks}
    */
    readonly networks?: GoogleDnsResponsePolicyNetworks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#timeouts GoogleDnsResponsePolicy#timeouts}
    */
    readonly timeouts?: GoogleDnsResponsePolicyTimeouts;
}
export interface GoogleDnsResponsePolicyGkeClusters {
    /**
    * The resource name of the cluster to bind this ManagedZone to.
  This should be specified in the format like
  'projects/*\/locations/*\/clusters/*'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#gke_cluster_name GoogleDnsResponsePolicy#gke_cluster_name}
    */
    readonly gkeClusterName: string;
}
export declare function googleDnsResponsePolicyGkeClustersToTerraform(struct?: GoogleDnsResponsePolicyGkeClusters | cdktf.IResolvable): any;
export declare class GoogleDnsResponsePolicyGkeClustersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDnsResponsePolicyGkeClusters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsResponsePolicyGkeClusters | cdktf.IResolvable | undefined);
    private _gkeClusterName?;
    get gkeClusterName(): string;
    set gkeClusterName(value: string);
    get gkeClusterNameInput(): string | undefined;
}
export declare class GoogleDnsResponsePolicyGkeClustersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDnsResponsePolicyGkeClusters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDnsResponsePolicyGkeClustersOutputReference;
}
export interface GoogleDnsResponsePolicyNetworks {
    /**
    * The fully qualified URL of the VPC network to bind to.
  This should be formatted like
  'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#network_url GoogleDnsResponsePolicy#network_url}
    */
    readonly networkUrl: string;
}
export declare function googleDnsResponsePolicyNetworksToTerraform(struct?: GoogleDnsResponsePolicyNetworks | cdktf.IResolvable): any;
export declare class GoogleDnsResponsePolicyNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleDnsResponsePolicyNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsResponsePolicyNetworks | cdktf.IResolvable | undefined);
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
}
export declare class GoogleDnsResponsePolicyNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleDnsResponsePolicyNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleDnsResponsePolicyNetworksOutputReference;
}
export interface GoogleDnsResponsePolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#create GoogleDnsResponsePolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#delete GoogleDnsResponsePolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy#update GoogleDnsResponsePolicy#update}
    */
    readonly update?: string;
}
export declare function googleDnsResponsePolicyTimeoutsToTerraform(struct?: GoogleDnsResponsePolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleDnsResponsePolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDnsResponsePolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDnsResponsePolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy google_dns_response_policy}
*/
export declare class GoogleDnsResponsePolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dns_response_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_dns_response_policy google_dns_response_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDnsResponsePolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDnsResponsePolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _responsePolicyName?;
    get responsePolicyName(): string;
    set responsePolicyName(value: string);
    get responsePolicyNameInput(): string | undefined;
    private _gkeClusters;
    get gkeClusters(): GoogleDnsResponsePolicyGkeClustersList;
    putGkeClusters(value: GoogleDnsResponsePolicyGkeClusters[] | cdktf.IResolvable): void;
    resetGkeClusters(): void;
    get gkeClustersInput(): cdktf.IResolvable | GoogleDnsResponsePolicyGkeClusters[] | undefined;
    private _networks;
    get networks(): GoogleDnsResponsePolicyNetworksList;
    putNetworks(value: GoogleDnsResponsePolicyNetworks[] | cdktf.IResolvable): void;
    resetNetworks(): void;
    get networksInput(): cdktf.IResolvable | GoogleDnsResponsePolicyNetworks[] | undefined;
    private _timeouts;
    get timeouts(): GoogleDnsResponsePolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleDnsResponsePolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDnsResponsePolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
