import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleDocumentAiProcessorDefaultVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_document_ai_processor_default_version#id GoogleDocumentAiProcessorDefaultVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The processor to set the version on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_document_ai_processor_default_version#processor GoogleDocumentAiProcessorDefaultVersion#processor}
    */
    readonly processor: string;
    /**
    * The version to set. Using 'stable' or 'rc' will cause the API to return the latest version in that release channel.
  Apply 'lifecycle.ignore_changes' to the 'version' field to suppress this diff.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_document_ai_processor_default_version#version GoogleDocumentAiProcessorDefaultVersion#version}
    */
    readonly version: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_document_ai_processor_default_version#timeouts GoogleDocumentAiProcessorDefaultVersion#timeouts}
    */
    readonly timeouts?: GoogleDocumentAiProcessorDefaultVersionTimeouts;
}
export interface GoogleDocumentAiProcessorDefaultVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_document_ai_processor_default_version#create GoogleDocumentAiProcessorDefaultVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_document_ai_processor_default_version#delete GoogleDocumentAiProcessorDefaultVersion#delete}
    */
    readonly delete?: string;
}
export declare function googleDocumentAiProcessorDefaultVersionTimeoutsToTerraform(struct?: GoogleDocumentAiProcessorDefaultVersionTimeouts | cdktf.IResolvable): any;
export declare class GoogleDocumentAiProcessorDefaultVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleDocumentAiProcessorDefaultVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleDocumentAiProcessorDefaultVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_document_ai_processor_default_version google_document_ai_processor_default_version}
*/
export declare class GoogleDocumentAiProcessorDefaultVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_document_ai_processor_default_version";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_document_ai_processor_default_version google_document_ai_processor_default_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleDocumentAiProcessorDefaultVersionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleDocumentAiProcessorDefaultVersionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _processor?;
    get processor(): string;
    set processor(value: string);
    get processorInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleDocumentAiProcessorDefaultVersionTimeoutsOutputReference;
    putTimeouts(value: GoogleDocumentAiProcessorDefaultVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleDocumentAiProcessorDefaultVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
