import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFilestoreBackupConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the backup with 2048 characters or less. Requests with longer descriptions will be rejected.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#description GoogleFilestoreBackup#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#id GoogleFilestoreBackup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#labels GoogleFilestoreBackup#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#location GoogleFilestoreBackup#location}
    */
    readonly location: string;
    /**
    * The resource name of the backup. The name must be unique within the specified instance.
  
  The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#name GoogleFilestoreBackup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#project GoogleFilestoreBackup#project}
    */
    readonly project?: string;
    /**
    * Name of the file share in the source Cloud Filestore instance that the backup is created from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#source_file_share GoogleFilestoreBackup#source_file_share}
    */
    readonly sourceFileShare: string;
    /**
    * The resource name of the source Cloud Filestore instance, in the format projects/{projectId}/locations/{locationId}/instances/{instanceId}, used to create this backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#source_instance GoogleFilestoreBackup#source_instance}
    */
    readonly sourceInstance: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#timeouts GoogleFilestoreBackup#timeouts}
    */
    readonly timeouts?: GoogleFilestoreBackupTimeouts;
}
export interface GoogleFilestoreBackupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#create GoogleFilestoreBackup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#delete GoogleFilestoreBackup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup#update GoogleFilestoreBackup#update}
    */
    readonly update?: string;
}
export declare function googleFilestoreBackupTimeoutsToTerraform(struct?: GoogleFilestoreBackupTimeouts | cdktf.IResolvable): any;
export declare class GoogleFilestoreBackupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFilestoreBackupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFilestoreBackupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup google_filestore_backup}
*/
export declare class GoogleFilestoreBackup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_filestore_backup";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_filestore_backup google_filestore_backup} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFilestoreBackupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFilestoreBackupConfig);
    get capacityGb(): string;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get downloadBytes(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kmsKeyName(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _sourceFileShare?;
    get sourceFileShare(): string;
    set sourceFileShare(value: string);
    get sourceFileShareInput(): string | undefined;
    private _sourceInstance?;
    get sourceInstance(): string;
    set sourceInstance(value: string);
    get sourceInstanceInput(): string | undefined;
    get sourceInstanceTier(): string;
    get state(): string;
    get storageBytes(): string;
    private _timeouts;
    get timeouts(): GoogleFilestoreBackupTimeoutsOutputReference;
    putTimeouts(value: GoogleFilestoreBackupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFilestoreBackupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
