import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseAndroidAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * (Optional) Set to 'ABANDON' to allow the AndroidApp to be untracked from terraform state
  rather than deleted upon 'terraform destroy'. This is useful because the AndroidApp may be
  serving traffic. Set to 'DELETE' to delete the AndroidApp. Defaults to 'DELETE'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#deletion_policy GoogleFirebaseAndroidApp#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * The user-assigned display name of the AndroidApp.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#display_name GoogleFirebaseAndroidApp#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#id GoogleFirebaseAndroidApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Immutable. The canonical package name of the Android app as would appear in the Google Play
  Developer Console.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#package_name GoogleFirebaseAndroidApp#package_name}
    */
    readonly packageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#project GoogleFirebaseAndroidApp#project}
    */
    readonly project?: string;
    /**
    * The SHA1 certificate hashes for the AndroidApp.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#sha1_hashes GoogleFirebaseAndroidApp#sha1_hashes}
    */
    readonly sha1Hashes?: string[];
    /**
    * The SHA256 certificate hashes for the AndroidApp.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#sha256_hashes GoogleFirebaseAndroidApp#sha256_hashes}
    */
    readonly sha256Hashes?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#timeouts GoogleFirebaseAndroidApp#timeouts}
    */
    readonly timeouts?: GoogleFirebaseAndroidAppTimeouts;
}
export interface GoogleFirebaseAndroidAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#create GoogleFirebaseAndroidApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#delete GoogleFirebaseAndroidApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app#update GoogleFirebaseAndroidApp#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseAndroidAppTimeoutsToTerraform(struct?: GoogleFirebaseAndroidAppTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseAndroidAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseAndroidAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseAndroidAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app google_firebase_android_app}
*/
export declare class GoogleFirebaseAndroidApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_android_app";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_android_app google_firebase_android_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseAndroidAppConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseAndroidAppConfig);
    get appId(): string;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _packageName?;
    get packageName(): string;
    set packageName(value: string);
    resetPackageName(): void;
    get packageNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _sha1Hashes?;
    get sha1Hashes(): string[];
    set sha1Hashes(value: string[]);
    resetSha1Hashes(): void;
    get sha1HashesInput(): string[] | undefined;
    private _sha256Hashes?;
    get sha256Hashes(): string[];
    set sha256Hashes(value: string[]);
    resetSha256Hashes(): void;
    get sha256HashesInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseAndroidAppTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseAndroidAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseAndroidAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
