import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseAppleAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#app_store_id GoogleFirebaseAppleApp#app_store_id}
    */
    readonly appStoreId?: string;
    /**
    * The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#bundle_id GoogleFirebaseAppleApp#bundle_id}
    */
    readonly bundleId?: string;
    /**
    * (Optional) Set to 'ABANDON' to allow the Apple to be untracked from terraform state
  rather than deleted upon 'terraform destroy'. This is useful because the Apple may be
  serving traffic. Set to 'DELETE' to delete the Apple. Defaults to 'DELETE'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#deletion_policy GoogleFirebaseAppleApp#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * The user-assigned display name of the App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#display_name GoogleFirebaseAppleApp#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#id GoogleFirebaseAppleApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#project GoogleFirebaseAppleApp#project}
    */
    readonly project?: string;
    /**
    * The Apple Developer Team ID associated with the App in the App Store.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#team_id GoogleFirebaseAppleApp#team_id}
    */
    readonly teamId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#timeouts GoogleFirebaseAppleApp#timeouts}
    */
    readonly timeouts?: GoogleFirebaseAppleAppTimeouts;
}
export interface GoogleFirebaseAppleAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#create GoogleFirebaseAppleApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#delete GoogleFirebaseAppleApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app#update GoogleFirebaseAppleApp#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseAppleAppTimeoutsToTerraform(struct?: GoogleFirebaseAppleAppTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseAppleAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseAppleAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseAppleAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app google_firebase_apple_app}
*/
export declare class GoogleFirebaseAppleApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_apple_app";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_apple_app google_firebase_apple_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseAppleAppConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseAppleAppConfig);
    get appId(): string;
    private _appStoreId?;
    get appStoreId(): string;
    set appStoreId(value: string);
    resetAppStoreId(): void;
    get appStoreIdInput(): string | undefined;
    private _bundleId?;
    get bundleId(): string;
    set bundleId(value: string);
    resetBundleId(): void;
    get bundleIdInput(): string | undefined;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    resetTeamId(): void;
    get teamIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseAppleAppTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseAppleAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseAppleAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
