import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The intended database state.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#desired_state GoogleFirebaseDatabaseInstance#desired_state}
    */
    readonly desiredState?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#id GoogleFirebaseDatabaseInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The globally unique identifier of the Firebase Realtime Database instance.
  Instance IDs cannot be reused after deletion.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#instance_id GoogleFirebaseDatabaseInstance#instance_id}
    */
    readonly instanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#project GoogleFirebaseDatabaseInstance#project}
    */
    readonly project?: string;
    /**
    * A reference to the region where the Firebase Realtime database resides.
  Check all [available regions](https://firebase.google.com/docs/projects/locations#rtdb-locations)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#region GoogleFirebaseDatabaseInstance#region}
    */
    readonly region: string;
    /**
    * The database type.
  Each project can create one default Firebase Realtime Database, which cannot be deleted once created.
  Creating user Databases is only available for projects on the Blaze plan.
  Projects can be upgraded using the Cloud Billing API https://cloud.google.com/billing/reference/rest/v1/projects/updateBillingInfo. Default value: "USER_DATABASE" Possible values: ["DEFAULT_DATABASE", "USER_DATABASE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#type GoogleFirebaseDatabaseInstance#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#timeouts GoogleFirebaseDatabaseInstance#timeouts}
    */
    readonly timeouts?: GoogleFirebaseDatabaseInstanceTimeouts;
}
export interface GoogleFirebaseDatabaseInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#create GoogleFirebaseDatabaseInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#delete GoogleFirebaseDatabaseInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance#update GoogleFirebaseDatabaseInstance#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseDatabaseInstanceTimeoutsToTerraform(struct?: GoogleFirebaseDatabaseInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseDatabaseInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseDatabaseInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseDatabaseInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance google_firebase_database_instance}
*/
export declare class GoogleFirebaseDatabaseInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_database_instance";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_database_instance google_firebase_database_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseDatabaseInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseDatabaseInstanceConfig);
    get databaseUrl(): string;
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    get state(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseDatabaseInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseDatabaseInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseDatabaseInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
