import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseHostingReleaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the channel to which the release belongs. If not provided, the release will
  belong to the default "live" channel
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#channel_id GoogleFirebaseHostingRelease#channel_id}
    */
    readonly channelId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#id GoogleFirebaseHostingRelease#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The deploy description when the release was created. The value can be up to 512 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#message GoogleFirebaseHostingRelease#message}
    */
    readonly message?: string;
    /**
    * Required. The ID of the site to which the release belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#site_id GoogleFirebaseHostingRelease#site_id}
    */
    readonly siteId: string;
    /**
    * The type of the release; indicates what happened to the content of the site. There is no need to specify
  'DEPLOY' or 'ROLLBACK' type if a 'version_name' is provided.
  DEPLOY: A version was uploaded to Firebase Hosting and released. Output only.
  ROLLBACK: The release points back to a previously deployed version. Output only.
  SITE_DISABLE: The release prevents the site from serving content. Firebase Hosting acts as if the site never existed Possible values: ["DEPLOY", "ROLLBACK", "SITE_DISABLE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#type GoogleFirebaseHostingRelease#type}
    */
    readonly type?: string;
    /**
    * The unique identifier for a version, in the format: sites/SITE_ID/versions/VERSION_ID.
  The content of the version specified will be actively displayed on the appropriate URL.
  The Version must belong to the same site as in the 'site_id'.
  This parameter must be empty if the 'type' of the release is 'SITE_DISABLE'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#version_name GoogleFirebaseHostingRelease#version_name}
    */
    readonly versionName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#timeouts GoogleFirebaseHostingRelease#timeouts}
    */
    readonly timeouts?: GoogleFirebaseHostingReleaseTimeouts;
}
export interface GoogleFirebaseHostingReleaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#create GoogleFirebaseHostingRelease#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release#delete GoogleFirebaseHostingRelease#delete}
    */
    readonly delete?: string;
}
export declare function googleFirebaseHostingReleaseTimeoutsToTerraform(struct?: GoogleFirebaseHostingReleaseTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseHostingReleaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseHostingReleaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseHostingReleaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release google_firebase_hosting_release}
*/
export declare class GoogleFirebaseHostingRelease extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_hosting_release";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_release google_firebase_hosting_release} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseHostingReleaseConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseHostingReleaseConfig);
    private _channelId?;
    get channelId(): string;
    set channelId(value: string);
    resetChannelId(): void;
    get channelIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    resetMessage(): void;
    get messageInput(): string | undefined;
    get name(): string;
    get releaseId(): string;
    private _siteId?;
    get siteId(): string;
    set siteId(value: string);
    get siteIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _versionName?;
    get versionName(): string;
    set versionName(value: string);
    resetVersionName(): void;
    get versionNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseHostingReleaseTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseHostingReleaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseHostingReleaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
