import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseHostingSiteConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. The [ID of a Web App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
  associated with the Hosting site.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site#app_id GoogleFirebaseHostingSite#app_id}
    */
    readonly appId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site#id GoogleFirebaseHostingSite#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site#project GoogleFirebaseHostingSite#project}
    */
    readonly project?: string;
    /**
    * Required. Immutable. A globally unique identifier for the Hosting site. This identifier is
  used to construct the Firebase-provisioned subdomains for the site, so it must also be a valid
  domain name label.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site#site_id GoogleFirebaseHostingSite#site_id}
    */
    readonly siteId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site#timeouts GoogleFirebaseHostingSite#timeouts}
    */
    readonly timeouts?: GoogleFirebaseHostingSiteTimeouts;
}
export interface GoogleFirebaseHostingSiteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site#create GoogleFirebaseHostingSite#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site#delete GoogleFirebaseHostingSite#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site#update GoogleFirebaseHostingSite#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseHostingSiteTimeoutsToTerraform(struct?: GoogleFirebaseHostingSiteTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseHostingSiteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseHostingSiteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseHostingSiteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site google_firebase_hosting_site}
*/
export declare class GoogleFirebaseHostingSite extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_hosting_site";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_site google_firebase_hosting_site} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseHostingSiteConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleFirebaseHostingSiteConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    resetAppId(): void;
    get appIdInput(): string | undefined;
    get defaultUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _siteId?;
    get siteId(): string;
    set siteId(value: string);
    resetSiteId(): void;
    get siteIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseHostingSiteTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseHostingSiteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseHostingSiteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
