import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseHostingVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#id GoogleFirebaseHostingVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Required. The ID of the site in which to create this Version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#site_id GoogleFirebaseHostingVersion#site_id}
    */
    readonly siteId: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#config GoogleFirebaseHostingVersion#config}
    */
    readonly config?: GoogleFirebaseHostingVersionConfigA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#timeouts GoogleFirebaseHostingVersion#timeouts}
    */
    readonly timeouts?: GoogleFirebaseHostingVersionTimeouts;
}
export interface GoogleFirebaseHostingVersionConfigRedirects {
    /**
    * The user-supplied glob to match against the request URL path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#glob GoogleFirebaseHostingVersion#glob}
    */
    readonly glob?: string;
    /**
    * The value to put in the HTTP location header of the response.
  The location can contain capture group values from the pattern using a : prefix to identify
  the segment and an optional * to capture the rest of the URL. For example:
  
  ```hcl
  redirects {
    glob = "/:capture*"
    status_code = 302
    location = "https://example.com/foo/:capture"
  }
  ```
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#location GoogleFirebaseHostingVersion#location}
    */
    readonly location: string;
    /**
    * The user-supplied RE2 regular expression to match against the request URL path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#regex GoogleFirebaseHostingVersion#regex}
    */
    readonly regex?: string;
    /**
    * The status HTTP code to return in the response. It must be a valid 3xx status code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#status_code GoogleFirebaseHostingVersion#status_code}
    */
    readonly statusCode: number;
}
export declare function googleFirebaseHostingVersionConfigRedirectsToTerraform(struct?: GoogleFirebaseHostingVersionConfigRedirects | cdktf.IResolvable): any;
export declare class GoogleFirebaseHostingVersionConfigRedirectsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingVersionConfigRedirects | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseHostingVersionConfigRedirects | cdktf.IResolvable | undefined);
    private _glob?;
    get glob(): string;
    set glob(value: string);
    resetGlob(): void;
    get globInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _regex?;
    get regex(): string;
    set regex(value: string);
    resetRegex(): void;
    get regexInput(): string | undefined;
    private _statusCode?;
    get statusCode(): number;
    set statusCode(value: number);
    get statusCodeInput(): number | undefined;
}
export declare class GoogleFirebaseHostingVersionConfigRedirectsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleFirebaseHostingVersionConfigRedirects[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingVersionConfigRedirectsOutputReference;
}
export interface GoogleFirebaseHostingVersionConfigRewritesRun {
    /**
    * Optional. User-provided region where the Cloud Run service is hosted. Defaults to 'us-central1' if not supplied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#region GoogleFirebaseHostingVersion#region}
    */
    readonly region?: string;
    /**
    * User-defined ID of the Cloud Run service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#service_id GoogleFirebaseHostingVersion#service_id}
    */
    readonly serviceId: string;
}
export declare function googleFirebaseHostingVersionConfigRewritesRunToTerraform(struct?: GoogleFirebaseHostingVersionConfigRewritesRunOutputReference | GoogleFirebaseHostingVersionConfigRewritesRun): any;
export declare class GoogleFirebaseHostingVersionConfigRewritesRunOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseHostingVersionConfigRewritesRun | undefined;
    set internalValue(value: GoogleFirebaseHostingVersionConfigRewritesRun | undefined);
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
}
export interface GoogleFirebaseHostingVersionConfigRewrites {
    /**
    * The function to proxy requests to. Must match the exported function name exactly.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#function GoogleFirebaseHostingVersion#function}
    */
    readonly function?: string;
    /**
    * The user-supplied glob to match against the request URL path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#glob GoogleFirebaseHostingVersion#glob}
    */
    readonly glob?: string;
    /**
    * The user-supplied RE2 regular expression to match against the request URL path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#regex GoogleFirebaseHostingVersion#regex}
    */
    readonly regex?: string;
    /**
    * run block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#run GoogleFirebaseHostingVersion#run}
    */
    readonly run?: GoogleFirebaseHostingVersionConfigRewritesRun;
}
export declare function googleFirebaseHostingVersionConfigRewritesToTerraform(struct?: GoogleFirebaseHostingVersionConfigRewrites | cdktf.IResolvable): any;
export declare class GoogleFirebaseHostingVersionConfigRewritesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingVersionConfigRewrites | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseHostingVersionConfigRewrites | cdktf.IResolvable | undefined);
    private _function?;
    get function(): string;
    set function(value: string);
    resetFunction(): void;
    get functionInput(): string | undefined;
    private _glob?;
    get glob(): string;
    set glob(value: string);
    resetGlob(): void;
    get globInput(): string | undefined;
    private _regex?;
    get regex(): string;
    set regex(value: string);
    resetRegex(): void;
    get regexInput(): string | undefined;
    private _run;
    get run(): GoogleFirebaseHostingVersionConfigRewritesRunOutputReference;
    putRun(value: GoogleFirebaseHostingVersionConfigRewritesRun): void;
    resetRun(): void;
    get runInput(): GoogleFirebaseHostingVersionConfigRewritesRun | undefined;
}
export declare class GoogleFirebaseHostingVersionConfigRewritesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleFirebaseHostingVersionConfigRewrites[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingVersionConfigRewritesOutputReference;
}
export interface GoogleFirebaseHostingVersionConfigA {
    /**
    * redirects block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#redirects GoogleFirebaseHostingVersion#redirects}
    */
    readonly redirects?: GoogleFirebaseHostingVersionConfigRedirects[] | cdktf.IResolvable;
    /**
    * rewrites block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#rewrites GoogleFirebaseHostingVersion#rewrites}
    */
    readonly rewrites?: GoogleFirebaseHostingVersionConfigRewrites[] | cdktf.IResolvable;
}
export declare function googleFirebaseHostingVersionConfigAToTerraform(struct?: GoogleFirebaseHostingVersionConfigAOutputReference | GoogleFirebaseHostingVersionConfigA): any;
export declare class GoogleFirebaseHostingVersionConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseHostingVersionConfigA | undefined;
    set internalValue(value: GoogleFirebaseHostingVersionConfigA | undefined);
    private _redirects;
    get redirects(): GoogleFirebaseHostingVersionConfigRedirectsList;
    putRedirects(value: GoogleFirebaseHostingVersionConfigRedirects[] | cdktf.IResolvable): void;
    resetRedirects(): void;
    get redirectsInput(): cdktf.IResolvable | GoogleFirebaseHostingVersionConfigRedirects[] | undefined;
    private _rewrites;
    get rewrites(): GoogleFirebaseHostingVersionConfigRewritesList;
    putRewrites(value: GoogleFirebaseHostingVersionConfigRewrites[] | cdktf.IResolvable): void;
    resetRewrites(): void;
    get rewritesInput(): cdktf.IResolvable | GoogleFirebaseHostingVersionConfigRewrites[] | undefined;
}
export interface GoogleFirebaseHostingVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#create GoogleFirebaseHostingVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version#delete GoogleFirebaseHostingVersion#delete}
    */
    readonly delete?: string;
}
export declare function googleFirebaseHostingVersionTimeoutsToTerraform(struct?: GoogleFirebaseHostingVersionTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseHostingVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseHostingVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseHostingVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version google_firebase_hosting_version}
*/
export declare class GoogleFirebaseHostingVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_hosting_version";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebase_hosting_version google_firebase_hosting_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseHostingVersionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseHostingVersionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _siteId?;
    get siteId(): string;
    set siteId(value: string);
    get siteIdInput(): string | undefined;
    get versionId(): string;
    private _config;
    get config(): GoogleFirebaseHostingVersionConfigAOutputReference;
    putConfig(value: GoogleFirebaseHostingVersionConfigA): void;
    resetConfig(): void;
    get configInput(): GoogleFirebaseHostingVersionConfigA | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseHostingVersionTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseHostingVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseHostingVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
