import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaserulesReleaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release#id GoogleFirebaserulesRelease#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Format: `projects/{project_id}/releases/{release_id}`\Firestore Rules Releases will **always** have the name 'cloud.firestore'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release#name GoogleFirebaserulesRelease#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release#project GoogleFirebaserulesRelease#project}
    */
    readonly project?: string;
    /**
    * Name of the `Ruleset` referred to by this `Release`. The `Ruleset` must exist for the `Release` to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release#ruleset_name GoogleFirebaserulesRelease#ruleset_name}
    */
    readonly rulesetName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release#timeouts GoogleFirebaserulesRelease#timeouts}
    */
    readonly timeouts?: GoogleFirebaserulesReleaseTimeouts;
}
export interface GoogleFirebaserulesReleaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release#create GoogleFirebaserulesRelease#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release#delete GoogleFirebaserulesRelease#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release#update GoogleFirebaserulesRelease#update}
    */
    readonly update?: string;
}
export declare function googleFirebaserulesReleaseTimeoutsToTerraform(struct?: GoogleFirebaserulesReleaseTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaserulesReleaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaserulesReleaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaserulesReleaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release google_firebaserules_release}
*/
export declare class GoogleFirebaserulesRelease extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebaserules_release";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firebaserules_release google_firebaserules_release} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaserulesReleaseConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaserulesReleaseConfig);
    get createTime(): string;
    get disabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _rulesetName?;
    get rulesetName(): string;
    set rulesetName(value: string);
    get rulesetNameInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleFirebaserulesReleaseTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaserulesReleaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaserulesReleaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
