import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirestoreDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The App Engine integration mode to use for this database. Possible values: ["ENABLED", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#app_engine_integration_mode GoogleFirestoreDatabase#app_engine_integration_mode}
    */
    readonly appEngineIntegrationMode?: string;
    /**
    * The concurrency control mode to use for this database. Possible values: ["OPTIMISTIC", "PESSIMISTIC", "OPTIMISTIC_WITH_ENTITY_GROUPS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#concurrency_mode GoogleFirestoreDatabase#concurrency_mode}
    */
    readonly concurrencyMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#id GoogleFirestoreDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the database. Available databases are listed at
  https://cloud.google.com/firestore/docs/locations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#location_id GoogleFirestoreDatabase#location_id}
    */
    readonly locationId: string;
    /**
    * The ID to use for the database, which will become the final
  component of the database's resource name. This value should be 4-63
  characters. Valid characters are /[a-z][0-9]-/ with first character
  a letter and the last a letter or a number. Must not be
  UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
  "(default)" database id is also valid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#name GoogleFirestoreDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#project GoogleFirestoreDatabase#project}
    */
    readonly project?: string;
    /**
    * The type of the database.
  See https://cloud.google.com/datastore/docs/firestore-or-datastore
  for information about how to choose. Possible values: ["FIRESTORE_NATIVE", "DATASTORE_MODE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#type GoogleFirestoreDatabase#type}
    */
    readonly type: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#timeouts GoogleFirestoreDatabase#timeouts}
    */
    readonly timeouts?: GoogleFirestoreDatabaseTimeouts;
}
export interface GoogleFirestoreDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#create GoogleFirestoreDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#delete GoogleFirestoreDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database#update GoogleFirestoreDatabase#update}
    */
    readonly update?: string;
}
export declare function googleFirestoreDatabaseTimeoutsToTerraform(struct?: GoogleFirestoreDatabaseTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirestoreDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirestoreDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database google_firestore_database}
*/
export declare class GoogleFirestoreDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firestore_database";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_database google_firestore_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirestoreDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirestoreDatabaseConfig);
    private _appEngineIntegrationMode?;
    get appEngineIntegrationMode(): string;
    set appEngineIntegrationMode(value: string);
    resetAppEngineIntegrationMode(): void;
    get appEngineIntegrationModeInput(): string | undefined;
    private _concurrencyMode?;
    get concurrencyMode(): string;
    set concurrencyMode(value: string);
    resetConcurrencyMode(): void;
    get concurrencyModeInput(): string | undefined;
    get createTime(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyPrefix(): string;
    private _locationId?;
    get locationId(): string;
    set locationId(value: string);
    get locationIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirestoreDatabaseTimeoutsOutputReference;
    putTimeouts(value: GoogleFirestoreDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirestoreDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
