import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirestoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * The collection being indexed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#collection GoogleFirestoreIndex#collection}
    */
    readonly collection: string;
    /**
    * The Firestore database id. Defaults to '"(default)"'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#database GoogleFirestoreIndex#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#id GoogleFirestoreIndex#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#project GoogleFirestoreIndex#project}
    */
    readonly project?: string;
    /**
    * The scope at which a query is run. Default value: "COLLECTION" Possible values: ["COLLECTION", "COLLECTION_GROUP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#query_scope GoogleFirestoreIndex#query_scope}
    */
    readonly queryScope?: string;
    /**
    * fields block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#fields GoogleFirestoreIndex#fields}
    */
    readonly fields: GoogleFirestoreIndexFields[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#timeouts GoogleFirestoreIndex#timeouts}
    */
    readonly timeouts?: GoogleFirestoreIndexTimeouts;
}
export interface GoogleFirestoreIndexFields {
    /**
    * Indicates that this field supports operations on arrayValues. Only one of 'order' and 'arrayConfig' can
  be specified. Possible values: ["CONTAINS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#array_config GoogleFirestoreIndex#array_config}
    */
    readonly arrayConfig?: string;
    /**
    * Name of the field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#field_path GoogleFirestoreIndex#field_path}
    */
    readonly fieldPath?: string;
    /**
    * Indicates that this field supports ordering by the specified order or comparing using =, <, <=, >, >=.
  Only one of 'order' and 'arrayConfig' can be specified. Possible values: ["ASCENDING", "DESCENDING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#order GoogleFirestoreIndex#order}
    */
    readonly order?: string;
}
export declare function googleFirestoreIndexFieldsToTerraform(struct?: GoogleFirestoreIndexFields | cdktf.IResolvable): any;
export declare class GoogleFirestoreIndexFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirestoreIndexFields | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirestoreIndexFields | cdktf.IResolvable | undefined);
    private _arrayConfig?;
    get arrayConfig(): string;
    set arrayConfig(value: string);
    resetArrayConfig(): void;
    get arrayConfigInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export declare class GoogleFirestoreIndexFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleFirestoreIndexFields[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirestoreIndexFieldsOutputReference;
}
export interface GoogleFirestoreIndexTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#create GoogleFirestoreIndex#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index#delete GoogleFirestoreIndex#delete}
    */
    readonly delete?: string;
}
export declare function googleFirestoreIndexTimeoutsToTerraform(struct?: GoogleFirestoreIndexTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirestoreIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreIndexTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirestoreIndexTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index google_firestore_index}
*/
export declare class GoogleFirestoreIndex extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firestore_index";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_firestore_index google_firestore_index} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirestoreIndexConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirestoreIndexConfig);
    private _collection?;
    get collection(): string;
    set collection(value: string);
    get collectionInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _queryScope?;
    get queryScope(): string;
    set queryScope(value: string);
    resetQueryScope(): void;
    get queryScopeInput(): string | undefined;
    private _fields;
    get fields(): GoogleFirestoreIndexFieldsList;
    putFields(value: GoogleFirestoreIndexFields[] | cdktf.IResolvable): void;
    get fieldsInput(): cdktf.IResolvable | GoogleFirestoreIndexFields[] | undefined;
    private _timeouts;
    get timeouts(): GoogleFirestoreIndexTimeoutsOutputReference;
    putTimeouts(value: GoogleFirestoreIndexTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirestoreIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
