import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFolderIamAuditConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_iam_audit_config#folder GoogleFolderIamAuditConfig#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_iam_audit_config#id GoogleFolderIamAuditConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Service which will be enabled for audit logging. The special value allServices covers all services.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_iam_audit_config#service GoogleFolderIamAuditConfig#service}
    */
    readonly service: string;
    /**
    * audit_log_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_iam_audit_config#audit_log_config GoogleFolderIamAuditConfig#audit_log_config}
    */
    readonly auditLogConfig: GoogleFolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
}
export interface GoogleFolderIamAuditConfigAuditLogConfig {
    /**
    * Identities that do not cause logging for this type of permission. Each entry can have one of the following values:user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com. serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_iam_audit_config#exempted_members GoogleFolderIamAuditConfig#exempted_members}
    */
    readonly exemptedMembers?: string[];
    /**
    * Permission type for which logging is to be configured. Must be one of DATA_READ, DATA_WRITE, or ADMIN_READ.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_iam_audit_config#log_type GoogleFolderIamAuditConfig#log_type}
    */
    readonly logType: string;
}
export declare function googleFolderIamAuditConfigAuditLogConfigToTerraform(struct?: GoogleFolderIamAuditConfigAuditLogConfig | cdktf.IResolvable): any;
export declare class GoogleFolderIamAuditConfigAuditLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFolderIamAuditConfigAuditLogConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFolderIamAuditConfigAuditLogConfig | cdktf.IResolvable | undefined);
    private _exemptedMembers?;
    get exemptedMembers(): string[];
    set exemptedMembers(value: string[]);
    resetExemptedMembers(): void;
    get exemptedMembersInput(): string[] | undefined;
    private _logType?;
    get logType(): string;
    set logType(value: string);
    get logTypeInput(): string | undefined;
}
export declare class GoogleFolderIamAuditConfigAuditLogConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleFolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFolderIamAuditConfigAuditLogConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_iam_audit_config google_folder_iam_audit_config}
*/
export declare class GoogleFolderIamAuditConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_folder_iam_audit_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_iam_audit_config google_folder_iam_audit_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFolderIamAuditConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFolderIamAuditConfigConfig);
    get etag(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _auditLogConfig;
    get auditLogConfig(): GoogleFolderIamAuditConfigAuditLogConfigList;
    putAuditLogConfig(value: GoogleFolderIamAuditConfigAuditLogConfig[] | cdktf.IResolvable): void;
    get auditLogConfigInput(): cdktf.IResolvable | GoogleFolderIamAuditConfigAuditLogConfig[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
