import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFolderOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#constraint GoogleFolderOrganizationPolicy#constraint}
    */
    readonly constraint: string;
    /**
    * The resource name of the folder to set the policy for. Its format is folders/{folder_id}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#folder GoogleFolderOrganizationPolicy#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#id GoogleFolderOrganizationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Version of the Policy. Default version is 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#version GoogleFolderOrganizationPolicy#version}
    */
    readonly version?: number;
    /**
    * boolean_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#boolean_policy GoogleFolderOrganizationPolicy#boolean_policy}
    */
    readonly booleanPolicy?: GoogleFolderOrganizationPolicyBooleanPolicy;
    /**
    * list_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#list_policy GoogleFolderOrganizationPolicy#list_policy}
    */
    readonly listPolicy?: GoogleFolderOrganizationPolicyListPolicy;
    /**
    * restore_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#restore_policy GoogleFolderOrganizationPolicy#restore_policy}
    */
    readonly restorePolicy?: GoogleFolderOrganizationPolicyRestorePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#timeouts GoogleFolderOrganizationPolicy#timeouts}
    */
    readonly timeouts?: GoogleFolderOrganizationPolicyTimeouts;
}
export interface GoogleFolderOrganizationPolicyBooleanPolicy {
    /**
    * If true, then the Policy is enforced. If false, then any configuration is acceptable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#enforced GoogleFolderOrganizationPolicy#enforced}
    */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare function googleFolderOrganizationPolicyBooleanPolicyToTerraform(struct?: GoogleFolderOrganizationPolicyBooleanPolicyOutputReference | GoogleFolderOrganizationPolicyBooleanPolicy): any;
export declare class GoogleFolderOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFolderOrganizationPolicyBooleanPolicy | undefined;
    set internalValue(value: GoogleFolderOrganizationPolicyBooleanPolicy | undefined);
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleFolderOrganizationPolicyListPolicyAllow {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#all GoogleFolderOrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#values GoogleFolderOrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function googleFolderOrganizationPolicyListPolicyAllowToTerraform(struct?: GoogleFolderOrganizationPolicyListPolicyAllowOutputReference | GoogleFolderOrganizationPolicyListPolicyAllow): any;
export declare class GoogleFolderOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFolderOrganizationPolicyListPolicyAllow | undefined;
    set internalValue(value: GoogleFolderOrganizationPolicyListPolicyAllow | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleFolderOrganizationPolicyListPolicyDeny {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#all GoogleFolderOrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#values GoogleFolderOrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function googleFolderOrganizationPolicyListPolicyDenyToTerraform(struct?: GoogleFolderOrganizationPolicyListPolicyDenyOutputReference | GoogleFolderOrganizationPolicyListPolicyDeny): any;
export declare class GoogleFolderOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFolderOrganizationPolicyListPolicyDeny | undefined;
    set internalValue(value: GoogleFolderOrganizationPolicyListPolicyDeny | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface GoogleFolderOrganizationPolicyListPolicy {
    /**
    * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#inherit_from_parent GoogleFolderOrganizationPolicy#inherit_from_parent}
    */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#suggested_value GoogleFolderOrganizationPolicy#suggested_value}
    */
    readonly suggestedValue?: string;
    /**
    * allow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#allow GoogleFolderOrganizationPolicy#allow}
    */
    readonly allow?: GoogleFolderOrganizationPolicyListPolicyAllow;
    /**
    * deny block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#deny GoogleFolderOrganizationPolicy#deny}
    */
    readonly deny?: GoogleFolderOrganizationPolicyListPolicyDeny;
}
export declare function googleFolderOrganizationPolicyListPolicyToTerraform(struct?: GoogleFolderOrganizationPolicyListPolicyOutputReference | GoogleFolderOrganizationPolicyListPolicy): any;
export declare class GoogleFolderOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFolderOrganizationPolicyListPolicy | undefined;
    set internalValue(value: GoogleFolderOrganizationPolicyListPolicy | undefined);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable;
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    get suggestedValue(): string;
    set suggestedValue(value: string);
    resetSuggestedValue(): void;
    get suggestedValueInput(): string | undefined;
    private _allow;
    get allow(): GoogleFolderOrganizationPolicyListPolicyAllowOutputReference;
    putAllow(value: GoogleFolderOrganizationPolicyListPolicyAllow): void;
    resetAllow(): void;
    get allowInput(): GoogleFolderOrganizationPolicyListPolicyAllow | undefined;
    private _deny;
    get deny(): GoogleFolderOrganizationPolicyListPolicyDenyOutputReference;
    putDeny(value: GoogleFolderOrganizationPolicyListPolicyDeny): void;
    resetDeny(): void;
    get denyInput(): GoogleFolderOrganizationPolicyListPolicyDeny | undefined;
}
export interface GoogleFolderOrganizationPolicyRestorePolicy {
    /**
    * May only be set to true. If set, then the default Policy is restored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#default GoogleFolderOrganizationPolicy#default}
    */
    readonly default: boolean | cdktf.IResolvable;
}
export declare function googleFolderOrganizationPolicyRestorePolicyToTerraform(struct?: GoogleFolderOrganizationPolicyRestorePolicyOutputReference | GoogleFolderOrganizationPolicyRestorePolicy): any;
export declare class GoogleFolderOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFolderOrganizationPolicyRestorePolicy | undefined;
    set internalValue(value: GoogleFolderOrganizationPolicyRestorePolicy | undefined);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleFolderOrganizationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#create GoogleFolderOrganizationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#delete GoogleFolderOrganizationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#read GoogleFolderOrganizationPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy#update GoogleFolderOrganizationPolicy#update}
    */
    readonly update?: string;
}
export declare function googleFolderOrganizationPolicyTimeoutsToTerraform(struct?: GoogleFolderOrganizationPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleFolderOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFolderOrganizationPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFolderOrganizationPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy google_folder_organization_policy}
*/
export declare class GoogleFolderOrganizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_folder_organization_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_folder_organization_policy google_folder_organization_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFolderOrganizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFolderOrganizationPolicyConfig);
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _booleanPolicy;
    get booleanPolicy(): GoogleFolderOrganizationPolicyBooleanPolicyOutputReference;
    putBooleanPolicy(value: GoogleFolderOrganizationPolicyBooleanPolicy): void;
    resetBooleanPolicy(): void;
    get booleanPolicyInput(): GoogleFolderOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy;
    get listPolicy(): GoogleFolderOrganizationPolicyListPolicyOutputReference;
    putListPolicy(value: GoogleFolderOrganizationPolicyListPolicy): void;
    resetListPolicy(): void;
    get listPolicyInput(): GoogleFolderOrganizationPolicyListPolicy | undefined;
    private _restorePolicy;
    get restorePolicy(): GoogleFolderOrganizationPolicyRestorePolicyOutputReference;
    putRestorePolicy(value: GoogleFolderOrganizationPolicyRestorePolicy): void;
    resetRestorePolicy(): void;
    get restorePolicyInput(): GoogleFolderOrganizationPolicyRestorePolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleFolderOrganizationPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleFolderOrganizationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFolderOrganizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
