import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGameServicesGameServerConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * A unique id for the deployment config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#config_id GoogleGameServicesGameServerConfig#config_id}
    */
    readonly configId: string;
    /**
    * A unique id for the deployment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#deployment_id GoogleGameServicesGameServerConfig#deployment_id}
    */
    readonly deploymentId: string;
    /**
    * The description of the game server config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#description GoogleGameServicesGameServerConfig#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#id GoogleGameServicesGameServerConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels associated with this game server config. Each label is a
  key-value pair.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#labels GoogleGameServicesGameServerConfig#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of the Deployment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#location GoogleGameServicesGameServerConfig#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#project GoogleGameServicesGameServerConfig#project}
    */
    readonly project?: string;
    /**
    * fleet_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#fleet_configs GoogleGameServicesGameServerConfig#fleet_configs}
    */
    readonly fleetConfigs: GoogleGameServicesGameServerConfigFleetConfigs[] | cdktf.IResolvable;
    /**
    * scaling_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#scaling_configs GoogleGameServicesGameServerConfig#scaling_configs}
    */
    readonly scalingConfigs?: GoogleGameServicesGameServerConfigScalingConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#timeouts GoogleGameServicesGameServerConfig#timeouts}
    */
    readonly timeouts?: GoogleGameServicesGameServerConfigTimeouts;
}
export interface GoogleGameServicesGameServerConfigFleetConfigs {
    /**
    * The fleet spec, which is sent to Agones to configure fleet.
  The spec can be passed as inline json but it is recommended to use a file reference
  instead. File references can contain the json or yaml format of the fleet spec. Eg:
  
  * fleet_spec = jsonencode(yamldecode(file("fleet_configs.yaml")))
  * fleet_spec = file("fleet_configs.json")
  
  The format of the spec can be found :
  'https://agones.dev/site/docs/reference/fleet/'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#fleet_spec GoogleGameServicesGameServerConfig#fleet_spec}
    */
    readonly fleetSpec: string;
    /**
    * The name of the FleetConfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#name GoogleGameServicesGameServerConfig#name}
    */
    readonly name?: string;
}
export declare function googleGameServicesGameServerConfigFleetConfigsToTerraform(struct?: GoogleGameServicesGameServerConfigFleetConfigs | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerConfigFleetConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGameServicesGameServerConfigFleetConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerConfigFleetConfigs | cdktf.IResolvable | undefined);
    private _fleetSpec?;
    get fleetSpec(): string;
    set fleetSpec(value: string);
    get fleetSpecInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class GoogleGameServicesGameServerConfigFleetConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGameServicesGameServerConfigFleetConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGameServicesGameServerConfigFleetConfigsOutputReference;
}
export interface GoogleGameServicesGameServerConfigScalingConfigsSchedules {
    /**
    * The duration for the cron job event. The duration of the event is effective
  after the cron job's start time.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#cron_job_duration GoogleGameServicesGameServerConfig#cron_job_duration}
    */
    readonly cronJobDuration?: string;
    /**
    * The cron definition of the scheduled event. See
  https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
  defined by the realm.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#cron_spec GoogleGameServicesGameServerConfig#cron_spec}
    */
    readonly cronSpec?: string;
    /**
    * The end time of the event.
  
  A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#end_time GoogleGameServicesGameServerConfig#end_time}
    */
    readonly endTime?: string;
    /**
    * The start time of the event.
  
  A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#start_time GoogleGameServicesGameServerConfig#start_time}
    */
    readonly startTime?: string;
}
export declare function googleGameServicesGameServerConfigScalingConfigsSchedulesToTerraform(struct?: GoogleGameServicesGameServerConfigScalingConfigsSchedules | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerConfigScalingConfigsSchedulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGameServicesGameServerConfigScalingConfigsSchedules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerConfigScalingConfigsSchedules | cdktf.IResolvable | undefined);
    private _cronJobDuration?;
    get cronJobDuration(): string;
    set cronJobDuration(value: string);
    resetCronJobDuration(): void;
    get cronJobDurationInput(): string | undefined;
    private _cronSpec?;
    get cronSpec(): string;
    set cronSpec(value: string);
    resetCronSpec(): void;
    get cronSpecInput(): string | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export declare class GoogleGameServicesGameServerConfigScalingConfigsSchedulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGameServicesGameServerConfigScalingConfigsSchedules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGameServicesGameServerConfigScalingConfigsSchedulesOutputReference;
}
export interface GoogleGameServicesGameServerConfigScalingConfigsSelectors {
    /**
    * Set of labels to group by.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#labels GoogleGameServicesGameServerConfig#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
}
export declare function googleGameServicesGameServerConfigScalingConfigsSelectorsToTerraform(struct?: GoogleGameServicesGameServerConfigScalingConfigsSelectors | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerConfigScalingConfigsSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGameServicesGameServerConfigScalingConfigsSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerConfigScalingConfigsSelectors | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class GoogleGameServicesGameServerConfigScalingConfigsSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGameServicesGameServerConfigScalingConfigsSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGameServicesGameServerConfigScalingConfigsSelectorsOutputReference;
}
export interface GoogleGameServicesGameServerConfigScalingConfigs {
    /**
    * Fleet autoscaler spec, which is sent to Agones.
  Example spec can be found :
  https://agones.dev/site/docs/reference/fleetautoscaler/
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#fleet_autoscaler_spec GoogleGameServicesGameServerConfig#fleet_autoscaler_spec}
    */
    readonly fleetAutoscalerSpec: string;
    /**
    * The name of the ScalingConfig
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#name GoogleGameServicesGameServerConfig#name}
    */
    readonly name: string;
    /**
    * schedules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#schedules GoogleGameServicesGameServerConfig#schedules}
    */
    readonly schedules?: GoogleGameServicesGameServerConfigScalingConfigsSchedules[] | cdktf.IResolvable;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#selectors GoogleGameServicesGameServerConfig#selectors}
    */
    readonly selectors?: GoogleGameServicesGameServerConfigScalingConfigsSelectors[] | cdktf.IResolvable;
}
export declare function googleGameServicesGameServerConfigScalingConfigsToTerraform(struct?: GoogleGameServicesGameServerConfigScalingConfigs | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerConfigScalingConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGameServicesGameServerConfigScalingConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerConfigScalingConfigs | cdktf.IResolvable | undefined);
    private _fleetAutoscalerSpec?;
    get fleetAutoscalerSpec(): string;
    set fleetAutoscalerSpec(value: string);
    get fleetAutoscalerSpecInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schedules;
    get schedules(): GoogleGameServicesGameServerConfigScalingConfigsSchedulesList;
    putSchedules(value: GoogleGameServicesGameServerConfigScalingConfigsSchedules[] | cdktf.IResolvable): void;
    resetSchedules(): void;
    get schedulesInput(): cdktf.IResolvable | GoogleGameServicesGameServerConfigScalingConfigsSchedules[] | undefined;
    private _selectors;
    get selectors(): GoogleGameServicesGameServerConfigScalingConfigsSelectorsList;
    putSelectors(value: GoogleGameServicesGameServerConfigScalingConfigsSelectors[] | cdktf.IResolvable): void;
    resetSelectors(): void;
    get selectorsInput(): cdktf.IResolvable | GoogleGameServicesGameServerConfigScalingConfigsSelectors[] | undefined;
}
export declare class GoogleGameServicesGameServerConfigScalingConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGameServicesGameServerConfigScalingConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGameServicesGameServerConfigScalingConfigsOutputReference;
}
export interface GoogleGameServicesGameServerConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#create GoogleGameServicesGameServerConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config#delete GoogleGameServicesGameServerConfig#delete}
    */
    readonly delete?: string;
}
export declare function googleGameServicesGameServerConfigTimeoutsToTerraform(struct?: GoogleGameServicesGameServerConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleGameServicesGameServerConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGameServicesGameServerConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGameServicesGameServerConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config google_game_services_game_server_config}
*/
export declare class GoogleGameServicesGameServerConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_game_services_game_server_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_game_services_game_server_config google_game_services_game_server_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGameServicesGameServerConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGameServicesGameServerConfigConfig);
    private _configId?;
    get configId(): string;
    set configId(value: string);
    get configIdInput(): string | undefined;
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _fleetConfigs;
    get fleetConfigs(): GoogleGameServicesGameServerConfigFleetConfigsList;
    putFleetConfigs(value: GoogleGameServicesGameServerConfigFleetConfigs[] | cdktf.IResolvable): void;
    get fleetConfigsInput(): cdktf.IResolvable | GoogleGameServicesGameServerConfigFleetConfigs[] | undefined;
    private _scalingConfigs;
    get scalingConfigs(): GoogleGameServicesGameServerConfigScalingConfigsList;
    putScalingConfigs(value: GoogleGameServicesGameServerConfigScalingConfigs[] | cdktf.IResolvable): void;
    resetScalingConfigs(): void;
    get scalingConfigsInput(): cdktf.IResolvable | GoogleGameServicesGameServerConfigScalingConfigs[] | undefined;
    private _timeouts;
    get timeouts(): GoogleGameServicesGameServerConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleGameServicesGameServerConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGameServicesGameServerConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
