import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeBackupBackupPlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * The source cluster from which Backups will be created via this BackupPlan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#cluster GoogleGkeBackupBackupPlan#cluster}
    */
    readonly cluster: string;
    /**
    * This flag indicates whether this BackupPlan has been deactivated.
  Setting this field to True locks the BackupPlan such that no further updates will be allowed
  (except deletes), including the deactivated field itself. It also prevents any new Backups
  from being created via this BackupPlan (including scheduled Backups).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#deactivated GoogleGkeBackupBackupPlan#deactivated}
    */
    readonly deactivated?: boolean | cdktf.IResolvable;
    /**
    * User specified descriptive string for this BackupPlan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#description GoogleGkeBackupBackupPlan#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#id GoogleGkeBackupBackupPlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Description: A set of custom labels supplied by the user.
  A list of key->value pairs.
  Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#labels GoogleGkeBackupBackupPlan#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The region of the Backup Plan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#location GoogleGkeBackupBackupPlan#location}
    */
    readonly location: string;
    /**
    * The full name of the BackupPlan Resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#name GoogleGkeBackupBackupPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#project GoogleGkeBackupBackupPlan#project}
    */
    readonly project?: string;
    /**
    * backup_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#backup_config GoogleGkeBackupBackupPlan#backup_config}
    */
    readonly backupConfig?: GoogleGkeBackupBackupPlanBackupConfig;
    /**
    * backup_schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#backup_schedule GoogleGkeBackupBackupPlan#backup_schedule}
    */
    readonly backupSchedule?: GoogleGkeBackupBackupPlanBackupSchedule;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#retention_policy GoogleGkeBackupBackupPlan#retention_policy}
    */
    readonly retentionPolicy?: GoogleGkeBackupBackupPlanRetentionPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#timeouts GoogleGkeBackupBackupPlan#timeouts}
    */
    readonly timeouts?: GoogleGkeBackupBackupPlanTimeouts;
}
export interface GoogleGkeBackupBackupPlanBackupConfigEncryptionKey {
    /**
    * Google Cloud KMS encryption key. Format: projects/*\/locations/*\/keyRings/*\/cryptoKeys/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#gcp_kms_encryption_key GoogleGkeBackupBackupPlan#gcp_kms_encryption_key}
    */
    readonly gcpKmsEncryptionKey: string;
}
export declare function googleGkeBackupBackupPlanBackupConfigEncryptionKeyToTerraform(struct?: GoogleGkeBackupBackupPlanBackupConfigEncryptionKeyOutputReference | GoogleGkeBackupBackupPlanBackupConfigEncryptionKey): any;
export declare class GoogleGkeBackupBackupPlanBackupConfigEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupBackupPlanBackupConfigEncryptionKey | undefined;
    set internalValue(value: GoogleGkeBackupBackupPlanBackupConfigEncryptionKey | undefined);
    private _gcpKmsEncryptionKey?;
    get gcpKmsEncryptionKey(): string;
    set gcpKmsEncryptionKey(value: string);
    get gcpKmsEncryptionKeyInput(): string | undefined;
}
export interface GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNames {
    /**
    * The name of a Kubernetes Resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#name GoogleGkeBackupBackupPlan#name}
    */
    readonly name: string;
    /**
    * The namespace of a Kubernetes Resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#namespace GoogleGkeBackupBackupPlan#namespace}
    */
    readonly namespace: string;
}
export declare function googleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNamesToTerraform(struct?: GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNames | cdktf.IResolvable): any;
export declare class GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNames | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNames | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
}
export declare class GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNamesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNames[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNamesOutputReference;
}
export interface GoogleGkeBackupBackupPlanBackupConfigSelectedApplications {
    /**
    * namespaced_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#namespaced_names GoogleGkeBackupBackupPlan#namespaced_names}
    */
    readonly namespacedNames: GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNames[] | cdktf.IResolvable;
}
export declare function googleGkeBackupBackupPlanBackupConfigSelectedApplicationsToTerraform(struct?: GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsOutputReference | GoogleGkeBackupBackupPlanBackupConfigSelectedApplications): any;
export declare class GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupBackupPlanBackupConfigSelectedApplications | undefined;
    set internalValue(value: GoogleGkeBackupBackupPlanBackupConfigSelectedApplications | undefined);
    private _namespacedNames;
    get namespacedNames(): GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNamesList;
    putNamespacedNames(value: GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNames[] | cdktf.IResolvable): void;
    get namespacedNamesInput(): cdktf.IResolvable | GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsNamespacedNames[] | undefined;
}
export interface GoogleGkeBackupBackupPlanBackupConfigSelectedNamespaces {
    /**
    * A list of Kubernetes Namespaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#namespaces GoogleGkeBackupBackupPlan#namespaces}
    */
    readonly namespaces: string[];
}
export declare function googleGkeBackupBackupPlanBackupConfigSelectedNamespacesToTerraform(struct?: GoogleGkeBackupBackupPlanBackupConfigSelectedNamespacesOutputReference | GoogleGkeBackupBackupPlanBackupConfigSelectedNamespaces): any;
export declare class GoogleGkeBackupBackupPlanBackupConfigSelectedNamespacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupBackupPlanBackupConfigSelectedNamespaces | undefined;
    set internalValue(value: GoogleGkeBackupBackupPlanBackupConfigSelectedNamespaces | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    get namespacesInput(): string[] | undefined;
}
export interface GoogleGkeBackupBackupPlanBackupConfig {
    /**
    * If True, include all namespaced resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#all_namespaces GoogleGkeBackupBackupPlan#all_namespaces}
    */
    readonly allNamespaces?: boolean | cdktf.IResolvable;
    /**
    * This flag specifies whether Kubernetes Secret resources should be included
  when they fall into the scope of Backups.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#include_secrets GoogleGkeBackupBackupPlan#include_secrets}
    */
    readonly includeSecrets?: boolean | cdktf.IResolvable;
    /**
    * This flag specifies whether volume data should be backed up when PVCs are
  included in the scope of a Backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#include_volume_data GoogleGkeBackupBackupPlan#include_volume_data}
    */
    readonly includeVolumeData?: boolean | cdktf.IResolvable;
    /**
    * encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#encryption_key GoogleGkeBackupBackupPlan#encryption_key}
    */
    readonly encryptionKey?: GoogleGkeBackupBackupPlanBackupConfigEncryptionKey;
    /**
    * selected_applications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#selected_applications GoogleGkeBackupBackupPlan#selected_applications}
    */
    readonly selectedApplications?: GoogleGkeBackupBackupPlanBackupConfigSelectedApplications;
    /**
    * selected_namespaces block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#selected_namespaces GoogleGkeBackupBackupPlan#selected_namespaces}
    */
    readonly selectedNamespaces?: GoogleGkeBackupBackupPlanBackupConfigSelectedNamespaces;
}
export declare function googleGkeBackupBackupPlanBackupConfigToTerraform(struct?: GoogleGkeBackupBackupPlanBackupConfigOutputReference | GoogleGkeBackupBackupPlanBackupConfig): any;
export declare class GoogleGkeBackupBackupPlanBackupConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupBackupPlanBackupConfig | undefined;
    set internalValue(value: GoogleGkeBackupBackupPlanBackupConfig | undefined);
    private _allNamespaces?;
    get allNamespaces(): boolean | cdktf.IResolvable;
    set allNamespaces(value: boolean | cdktf.IResolvable);
    resetAllNamespaces(): void;
    get allNamespacesInput(): boolean | cdktf.IResolvable | undefined;
    private _includeSecrets?;
    get includeSecrets(): boolean | cdktf.IResolvable;
    set includeSecrets(value: boolean | cdktf.IResolvable);
    resetIncludeSecrets(): void;
    get includeSecretsInput(): boolean | cdktf.IResolvable | undefined;
    private _includeVolumeData?;
    get includeVolumeData(): boolean | cdktf.IResolvable;
    set includeVolumeData(value: boolean | cdktf.IResolvable);
    resetIncludeVolumeData(): void;
    get includeVolumeDataInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionKey;
    get encryptionKey(): GoogleGkeBackupBackupPlanBackupConfigEncryptionKeyOutputReference;
    putEncryptionKey(value: GoogleGkeBackupBackupPlanBackupConfigEncryptionKey): void;
    resetEncryptionKey(): void;
    get encryptionKeyInput(): GoogleGkeBackupBackupPlanBackupConfigEncryptionKey | undefined;
    private _selectedApplications;
    get selectedApplications(): GoogleGkeBackupBackupPlanBackupConfigSelectedApplicationsOutputReference;
    putSelectedApplications(value: GoogleGkeBackupBackupPlanBackupConfigSelectedApplications): void;
    resetSelectedApplications(): void;
    get selectedApplicationsInput(): GoogleGkeBackupBackupPlanBackupConfigSelectedApplications | undefined;
    private _selectedNamespaces;
    get selectedNamespaces(): GoogleGkeBackupBackupPlanBackupConfigSelectedNamespacesOutputReference;
    putSelectedNamespaces(value: GoogleGkeBackupBackupPlanBackupConfigSelectedNamespaces): void;
    resetSelectedNamespaces(): void;
    get selectedNamespacesInput(): GoogleGkeBackupBackupPlanBackupConfigSelectedNamespaces | undefined;
}
export interface GoogleGkeBackupBackupPlanBackupSchedule {
    /**
    * A standard cron string that defines a repeating schedule for
  creating Backups via this BackupPlan.
  If this is defined, then backupRetainDays must also be defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#cron_schedule GoogleGkeBackupBackupPlan#cron_schedule}
    */
    readonly cronSchedule?: string;
    /**
    * This flag denotes whether automatic Backup creation is paused for this BackupPlan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#paused GoogleGkeBackupBackupPlan#paused}
    */
    readonly paused?: boolean | cdktf.IResolvable;
}
export declare function googleGkeBackupBackupPlanBackupScheduleToTerraform(struct?: GoogleGkeBackupBackupPlanBackupScheduleOutputReference | GoogleGkeBackupBackupPlanBackupSchedule): any;
export declare class GoogleGkeBackupBackupPlanBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupBackupPlanBackupSchedule | undefined;
    set internalValue(value: GoogleGkeBackupBackupPlanBackupSchedule | undefined);
    private _cronSchedule?;
    get cronSchedule(): string;
    set cronSchedule(value: string);
    resetCronSchedule(): void;
    get cronScheduleInput(): string | undefined;
    private _paused?;
    get paused(): boolean | cdktf.IResolvable;
    set paused(value: boolean | cdktf.IResolvable);
    resetPaused(): void;
    get pausedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeBackupBackupPlanRetentionPolicy {
    /**
    * Minimum age for a Backup created via this BackupPlan (in days).
  Must be an integer value between 0-90 (inclusive).
  A Backup created under this BackupPlan will not be deletable
  until it reaches Backup's (create time + backup_delete_lock_days).
  Updating this field of a BackupPlan does not affect existing Backups.
  Backups created after a successful update will inherit this new value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#backup_delete_lock_days GoogleGkeBackupBackupPlan#backup_delete_lock_days}
    */
    readonly backupDeleteLockDays?: number;
    /**
    * The default maximum age of a Backup created via this BackupPlan.
  This field MUST be an integer value >= 0 and <= 365. If specified,
  a Backup created under this BackupPlan will be automatically deleted
  after its age reaches (createTime + backupRetainDays).
  If not specified, Backups created under this BackupPlan will NOT be
  subject to automatic deletion. Updating this field does NOT affect
  existing Backups under it. Backups created AFTER a successful update
  will automatically pick up the new value.
  NOTE: backupRetainDays must be >= backupDeleteLockDays.
  If cronSchedule is defined, then this must be <= 360 * the creation interval.]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#backup_retain_days GoogleGkeBackupBackupPlan#backup_retain_days}
    */
    readonly backupRetainDays?: number;
    /**
    * This flag denotes whether the retention policy of this BackupPlan is locked.
  If set to True, no further update is allowed on this policy, including
  the locked field itself.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#locked GoogleGkeBackupBackupPlan#locked}
    */
    readonly locked?: boolean | cdktf.IResolvable;
}
export declare function googleGkeBackupBackupPlanRetentionPolicyToTerraform(struct?: GoogleGkeBackupBackupPlanRetentionPolicyOutputReference | GoogleGkeBackupBackupPlanRetentionPolicy): any;
export declare class GoogleGkeBackupBackupPlanRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupBackupPlanRetentionPolicy | undefined;
    set internalValue(value: GoogleGkeBackupBackupPlanRetentionPolicy | undefined);
    private _backupDeleteLockDays?;
    get backupDeleteLockDays(): number;
    set backupDeleteLockDays(value: number);
    resetBackupDeleteLockDays(): void;
    get backupDeleteLockDaysInput(): number | undefined;
    private _backupRetainDays?;
    get backupRetainDays(): number;
    set backupRetainDays(value: number);
    resetBackupRetainDays(): void;
    get backupRetainDaysInput(): number | undefined;
    private _locked?;
    get locked(): boolean | cdktf.IResolvable;
    set locked(value: boolean | cdktf.IResolvable);
    resetLocked(): void;
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeBackupBackupPlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#create GoogleGkeBackupBackupPlan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#delete GoogleGkeBackupBackupPlan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan#update GoogleGkeBackupBackupPlan#update}
    */
    readonly update?: string;
}
export declare function googleGkeBackupBackupPlanTimeoutsToTerraform(struct?: GoogleGkeBackupBackupPlanTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeBackupBackupPlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupBackupPlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupBackupPlanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan google_gke_backup_backup_plan}
*/
export declare class GoogleGkeBackupBackupPlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_backup_backup_plan";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_gke_backup_backup_plan google_gke_backup_backup_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeBackupBackupPlanConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeBackupBackupPlanConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _deactivated?;
    get deactivated(): boolean | cdktf.IResolvable;
    set deactivated(value: boolean | cdktf.IResolvable);
    resetDeactivated(): void;
    get deactivatedInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get protectedPodCount(): number;
    get uid(): string;
    private _backupConfig;
    get backupConfig(): GoogleGkeBackupBackupPlanBackupConfigOutputReference;
    putBackupConfig(value: GoogleGkeBackupBackupPlanBackupConfig): void;
    resetBackupConfig(): void;
    get backupConfigInput(): GoogleGkeBackupBackupPlanBackupConfig | undefined;
    private _backupSchedule;
    get backupSchedule(): GoogleGkeBackupBackupPlanBackupScheduleOutputReference;
    putBackupSchedule(value: GoogleGkeBackupBackupPlanBackupSchedule): void;
    resetBackupSchedule(): void;
    get backupScheduleInput(): GoogleGkeBackupBackupPlanBackupSchedule | undefined;
    private _retentionPolicy;
    get retentionPolicy(): GoogleGkeBackupBackupPlanRetentionPolicyOutputReference;
    putRetentionPolicy(value: GoogleGkeBackupBackupPlanRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): GoogleGkeBackupBackupPlanRetentionPolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeBackupBackupPlanTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeBackupBackupPlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeBackupBackupPlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
