import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareDatasetIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member#dataset_id GoogleHealthcareDatasetIamMember#dataset_id}
    */
    readonly datasetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member#id GoogleHealthcareDatasetIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member#member GoogleHealthcareDatasetIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member#role GoogleHealthcareDatasetIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member#condition GoogleHealthcareDatasetIamMember#condition}
    */
    readonly condition?: GoogleHealthcareDatasetIamMemberCondition;
}
export interface GoogleHealthcareDatasetIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member#description GoogleHealthcareDatasetIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member#expression GoogleHealthcareDatasetIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member#title GoogleHealthcareDatasetIamMember#title}
    */
    readonly title: string;
}
export declare function googleHealthcareDatasetIamMemberConditionToTerraform(struct?: GoogleHealthcareDatasetIamMemberConditionOutputReference | GoogleHealthcareDatasetIamMemberCondition): any;
export declare class GoogleHealthcareDatasetIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareDatasetIamMemberCondition | undefined;
    set internalValue(value: GoogleHealthcareDatasetIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member google_healthcare_dataset_iam_member}
*/
export declare class GoogleHealthcareDatasetIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_dataset_iam_member";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_healthcare_dataset_iam_member google_healthcare_dataset_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareDatasetIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareDatasetIamMemberConfig);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleHealthcareDatasetIamMemberConditionOutputReference;
    putCondition(value: GoogleHealthcareDatasetIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleHealthcareDatasetIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
