import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIamAccessBoundaryPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name of the rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#display_name GoogleIamAccessBoundaryPolicy#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#id GoogleIamAccessBoundaryPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#name GoogleIamAccessBoundaryPolicy#name}
    */
    readonly name: string;
    /**
    * The attachment point is identified by its URL-encoded full resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#parent GoogleIamAccessBoundaryPolicy#parent}
    */
    readonly parent: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#rules GoogleIamAccessBoundaryPolicy#rules}
    */
    readonly rules: GoogleIamAccessBoundaryPolicyRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#timeouts GoogleIamAccessBoundaryPolicy#timeouts}
    */
    readonly timeouts?: GoogleIamAccessBoundaryPolicyTimeouts;
}
export interface GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition {
    /**
    * Description of the expression. This is a longer text which describes the expression,
  e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#description GoogleIamAccessBoundaryPolicy#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#expression GoogleIamAccessBoundaryPolicy#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting,
  e.g. a file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#location GoogleIamAccessBoundaryPolicy#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
  This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#title GoogleIamAccessBoundaryPolicy#title}
    */
    readonly title?: string;
}
export declare function googleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityConditionToTerraform(struct?: GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityConditionOutputReference | GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition): any;
export declare class GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition | undefined;
    set internalValue(value: GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRule {
    /**
    * A list of permissions that may be allowed for use on the specified resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#available_permissions GoogleIamAccessBoundaryPolicy#available_permissions}
    */
    readonly availablePermissions?: string[];
    /**
    * The full resource name of a Google Cloud resource entity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#available_resource GoogleIamAccessBoundaryPolicy#available_resource}
    */
    readonly availableResource?: string;
    /**
    * availability_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#availability_condition GoogleIamAccessBoundaryPolicy#availability_condition}
    */
    readonly availabilityCondition?: GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition;
}
export declare function googleIamAccessBoundaryPolicyRulesAccessBoundaryRuleToTerraform(struct?: GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleOutputReference | GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRule): any;
export declare class GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRule | undefined;
    set internalValue(value: GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRule | undefined);
    private _availablePermissions?;
    get availablePermissions(): string[];
    set availablePermissions(value: string[]);
    resetAvailablePermissions(): void;
    get availablePermissionsInput(): string[] | undefined;
    private _availableResource?;
    get availableResource(): string;
    set availableResource(value: string);
    resetAvailableResource(): void;
    get availableResourceInput(): string | undefined;
    private _availabilityCondition;
    get availabilityCondition(): GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityConditionOutputReference;
    putAvailabilityCondition(value: GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition): void;
    resetAvailabilityCondition(): void;
    get availabilityConditionInput(): GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition | undefined;
}
export interface GoogleIamAccessBoundaryPolicyRules {
    /**
    * The description of the rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#description GoogleIamAccessBoundaryPolicy#description}
    */
    readonly description?: string;
    /**
    * access_boundary_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#access_boundary_rule GoogleIamAccessBoundaryPolicy#access_boundary_rule}
    */
    readonly accessBoundaryRule?: GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRule;
}
export declare function googleIamAccessBoundaryPolicyRulesToTerraform(struct?: GoogleIamAccessBoundaryPolicyRules | cdktf.IResolvable): any;
export declare class GoogleIamAccessBoundaryPolicyRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIamAccessBoundaryPolicyRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIamAccessBoundaryPolicyRules | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _accessBoundaryRule;
    get accessBoundaryRule(): GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRuleOutputReference;
    putAccessBoundaryRule(value: GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRule): void;
    resetAccessBoundaryRule(): void;
    get accessBoundaryRuleInput(): GoogleIamAccessBoundaryPolicyRulesAccessBoundaryRule | undefined;
}
export declare class GoogleIamAccessBoundaryPolicyRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIamAccessBoundaryPolicyRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIamAccessBoundaryPolicyRulesOutputReference;
}
export interface GoogleIamAccessBoundaryPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#create GoogleIamAccessBoundaryPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#delete GoogleIamAccessBoundaryPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy#update GoogleIamAccessBoundaryPolicy#update}
    */
    readonly update?: string;
}
export declare function googleIamAccessBoundaryPolicyTimeoutsToTerraform(struct?: GoogleIamAccessBoundaryPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleIamAccessBoundaryPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamAccessBoundaryPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIamAccessBoundaryPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy google_iam_access_boundary_policy}
*/
export declare class GoogleIamAccessBoundaryPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_access_boundary_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_access_boundary_policy google_iam_access_boundary_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIamAccessBoundaryPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIamAccessBoundaryPolicyConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _rules;
    get rules(): GoogleIamAccessBoundaryPolicyRulesList;
    putRules(value: GoogleIamAccessBoundaryPolicyRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | GoogleIamAccessBoundaryPolicyRules[] | undefined;
    private _timeouts;
    get timeouts(): GoogleIamAccessBoundaryPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleIamAccessBoundaryPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIamAccessBoundaryPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
