import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIamDenyPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name of the rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#display_name GoogleIamDenyPolicy#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#id GoogleIamDenyPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#name GoogleIamDenyPolicy#name}
    */
    readonly name: string;
    /**
    * The attachment point is identified by its URL-encoded full resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#parent GoogleIamDenyPolicy#parent}
    */
    readonly parent: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#rules GoogleIamDenyPolicy#rules}
    */
    readonly rules: GoogleIamDenyPolicyRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#timeouts GoogleIamDenyPolicy#timeouts}
    */
    readonly timeouts?: GoogleIamDenyPolicyTimeouts;
}
export interface GoogleIamDenyPolicyRulesDenyRuleDenialCondition {
    /**
    * Description of the expression. This is a longer text which describes the expression,
  e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#description GoogleIamDenyPolicy#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#expression GoogleIamDenyPolicy#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting,
  e.g. a file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#location GoogleIamDenyPolicy#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
  This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#title GoogleIamDenyPolicy#title}
    */
    readonly title?: string;
}
export declare function googleIamDenyPolicyRulesDenyRuleDenialConditionToTerraform(struct?: GoogleIamDenyPolicyRulesDenyRuleDenialConditionOutputReference | GoogleIamDenyPolicyRulesDenyRuleDenialCondition): any;
export declare class GoogleIamDenyPolicyRulesDenyRuleDenialConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamDenyPolicyRulesDenyRuleDenialCondition | undefined;
    set internalValue(value: GoogleIamDenyPolicyRulesDenyRuleDenialCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleIamDenyPolicyRulesDenyRule {
    /**
    * The permissions that are explicitly denied by this rule. Each permission uses the format '{service-fqdn}/{resource}.{verb}',
  where '{service-fqdn}' is the fully qualified domain name for the service. For example, 'iam.googleapis.com/roles.list'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#denied_permissions GoogleIamDenyPolicy#denied_permissions}
    */
    readonly deniedPermissions?: string[];
    /**
    * The identities that are prevented from using one or more permissions on Google Cloud resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#denied_principals GoogleIamDenyPolicy#denied_principals}
    */
    readonly deniedPrincipals?: string[];
    /**
    * Specifies the permissions that this rule excludes from the set of denied permissions given by deniedPermissions.
  If a permission appears in deniedPermissions and in exceptionPermissions then it will not be denied.
  The excluded permissions can be specified using the same syntax as deniedPermissions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#exception_permissions GoogleIamDenyPolicy#exception_permissions}
    */
    readonly exceptionPermissions?: string[];
    /**
    * The identities that are excluded from the deny rule, even if they are listed in the deniedPrincipals.
  For example, you could add a Google group to the deniedPrincipals, then exclude specific users who belong to that group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#exception_principals GoogleIamDenyPolicy#exception_principals}
    */
    readonly exceptionPrincipals?: string[];
    /**
    * denial_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#denial_condition GoogleIamDenyPolicy#denial_condition}
    */
    readonly denialCondition?: GoogleIamDenyPolicyRulesDenyRuleDenialCondition;
}
export declare function googleIamDenyPolicyRulesDenyRuleToTerraform(struct?: GoogleIamDenyPolicyRulesDenyRuleOutputReference | GoogleIamDenyPolicyRulesDenyRule): any;
export declare class GoogleIamDenyPolicyRulesDenyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamDenyPolicyRulesDenyRule | undefined;
    set internalValue(value: GoogleIamDenyPolicyRulesDenyRule | undefined);
    private _deniedPermissions?;
    get deniedPermissions(): string[];
    set deniedPermissions(value: string[]);
    resetDeniedPermissions(): void;
    get deniedPermissionsInput(): string[] | undefined;
    private _deniedPrincipals?;
    get deniedPrincipals(): string[];
    set deniedPrincipals(value: string[]);
    resetDeniedPrincipals(): void;
    get deniedPrincipalsInput(): string[] | undefined;
    private _exceptionPermissions?;
    get exceptionPermissions(): string[];
    set exceptionPermissions(value: string[]);
    resetExceptionPermissions(): void;
    get exceptionPermissionsInput(): string[] | undefined;
    private _exceptionPrincipals?;
    get exceptionPrincipals(): string[];
    set exceptionPrincipals(value: string[]);
    resetExceptionPrincipals(): void;
    get exceptionPrincipalsInput(): string[] | undefined;
    private _denialCondition;
    get denialCondition(): GoogleIamDenyPolicyRulesDenyRuleDenialConditionOutputReference;
    putDenialCondition(value: GoogleIamDenyPolicyRulesDenyRuleDenialCondition): void;
    resetDenialCondition(): void;
    get denialConditionInput(): GoogleIamDenyPolicyRulesDenyRuleDenialCondition | undefined;
}
export interface GoogleIamDenyPolicyRules {
    /**
    * The description of the rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#description GoogleIamDenyPolicy#description}
    */
    readonly description?: string;
    /**
    * deny_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#deny_rule GoogleIamDenyPolicy#deny_rule}
    */
    readonly denyRule?: GoogleIamDenyPolicyRulesDenyRule;
}
export declare function googleIamDenyPolicyRulesToTerraform(struct?: GoogleIamDenyPolicyRules | cdktf.IResolvable): any;
export declare class GoogleIamDenyPolicyRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIamDenyPolicyRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIamDenyPolicyRules | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _denyRule;
    get denyRule(): GoogleIamDenyPolicyRulesDenyRuleOutputReference;
    putDenyRule(value: GoogleIamDenyPolicyRulesDenyRule): void;
    resetDenyRule(): void;
    get denyRuleInput(): GoogleIamDenyPolicyRulesDenyRule | undefined;
}
export declare class GoogleIamDenyPolicyRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIamDenyPolicyRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIamDenyPolicyRulesOutputReference;
}
export interface GoogleIamDenyPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#create GoogleIamDenyPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#delete GoogleIamDenyPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy#update GoogleIamDenyPolicy#update}
    */
    readonly update?: string;
}
export declare function googleIamDenyPolicyTimeoutsToTerraform(struct?: GoogleIamDenyPolicyTimeouts | cdktf.IResolvable): any;
export declare class GoogleIamDenyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamDenyPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIamDenyPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy google_iam_deny_policy}
*/
export declare class GoogleIamDenyPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_deny_policy";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_iam_deny_policy google_iam_deny_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIamDenyPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIamDenyPolicyConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _rules;
    get rules(): GoogleIamDenyPolicyRulesList;
    putRules(value: GoogleIamDenyPolicyRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | GoogleIamDenyPolicyRules[] | undefined;
    private _timeouts;
    get timeouts(): GoogleIamDenyPolicyTimeoutsOutputReference;
    putTimeouts(value: GoogleIamDenyPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIamDenyPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
