import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIdentityPlatformConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether anonymous users will be auto-deleted after a period of 30 days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config#autodelete_anonymous_users GoogleIdentityPlatformConfig#autodelete_anonymous_users}
    */
    readonly autodeleteAnonymousUsers?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config#id GoogleIdentityPlatformConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config#project GoogleIdentityPlatformConfig#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config#timeouts GoogleIdentityPlatformConfig#timeouts}
    */
    readonly timeouts?: GoogleIdentityPlatformConfigTimeouts;
}
export interface GoogleIdentityPlatformConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config#create GoogleIdentityPlatformConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config#delete GoogleIdentityPlatformConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config#update GoogleIdentityPlatformConfig#update}
    */
    readonly update?: string;
}
export declare function googleIdentityPlatformConfigTimeoutsToTerraform(struct?: GoogleIdentityPlatformConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config google_identity_platform_config}
*/
export declare class GoogleIdentityPlatformConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_identity_platform_config google_identity_platform_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIdentityPlatformConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleIdentityPlatformConfigConfig);
    private _autodeleteAnonymousUsers?;
    get autodeleteAnonymousUsers(): boolean | cdktf.IResolvable;
    set autodeleteAnonymousUsers(value: boolean | cdktf.IResolvable);
    resetAutodeleteAnonymousUsers(): void;
    get autodeleteAnonymousUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleIdentityPlatformConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleIdentityPlatformConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIdentityPlatformConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
