import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleKmsCryptoKeyVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the cryptoKey associated with the CryptoKeyVersions.
  Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}''
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version#crypto_key GoogleKmsCryptoKeyVersion#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version#id GoogleKmsCryptoKeyVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The current state of the CryptoKeyVersion. Possible values: ["PENDING_GENERATION", "ENABLED", "DISABLED", "DESTROYED", "DESTROY_SCHEDULED", "PENDING_IMPORT", "IMPORT_FAILED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version#state GoogleKmsCryptoKeyVersion#state}
    */
    readonly state?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version#timeouts GoogleKmsCryptoKeyVersion#timeouts}
    */
    readonly timeouts?: GoogleKmsCryptoKeyVersionTimeouts;
}
export interface GoogleKmsCryptoKeyVersionAttestationCertChains {
}
export declare function googleKmsCryptoKeyVersionAttestationCertChainsToTerraform(struct?: GoogleKmsCryptoKeyVersionAttestationCertChains): any;
export declare class GoogleKmsCryptoKeyVersionAttestationCertChainsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleKmsCryptoKeyVersionAttestationCertChains | undefined;
    set internalValue(value: GoogleKmsCryptoKeyVersionAttestationCertChains | undefined);
    get caviumCerts(): string;
    get googleCardCerts(): string;
    get googlePartitionCerts(): string;
}
export declare class GoogleKmsCryptoKeyVersionAttestationCertChainsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleKmsCryptoKeyVersionAttestationCertChainsOutputReference;
}
export interface GoogleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptions {
}
export declare function googleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsToTerraform(struct?: GoogleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptions): any;
export declare class GoogleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptions | undefined;
    set internalValue(value: GoogleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptions | undefined);
    get ekmConnectionKeyPath(): string;
    get externalKeyUri(): string;
}
export declare class GoogleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsOutputReference;
}
export interface GoogleKmsCryptoKeyVersionAttestation {
}
export declare function googleKmsCryptoKeyVersionAttestationToTerraform(struct?: GoogleKmsCryptoKeyVersionAttestation): any;
export declare class GoogleKmsCryptoKeyVersionAttestationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleKmsCryptoKeyVersionAttestation | undefined;
    set internalValue(value: GoogleKmsCryptoKeyVersionAttestation | undefined);
    private _certChains;
    get certChains(): GoogleKmsCryptoKeyVersionAttestationCertChainsList;
    get content(): string;
    private _externalProtectionLevelOptions;
    get externalProtectionLevelOptions(): GoogleKmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsList;
    get format(): string;
}
export declare class GoogleKmsCryptoKeyVersionAttestationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleKmsCryptoKeyVersionAttestationOutputReference;
}
export interface GoogleKmsCryptoKeyVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version#create GoogleKmsCryptoKeyVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version#delete GoogleKmsCryptoKeyVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version#update GoogleKmsCryptoKeyVersion#update}
    */
    readonly update?: string;
}
export declare function googleKmsCryptoKeyVersionTimeoutsToTerraform(struct?: GoogleKmsCryptoKeyVersionTimeouts | cdktf.IResolvable): any;
export declare class GoogleKmsCryptoKeyVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleKmsCryptoKeyVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleKmsCryptoKeyVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version google_kms_crypto_key_version}
*/
export declare class GoogleKmsCryptoKeyVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_crypto_key_version";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_crypto_key_version google_kms_crypto_key_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleKmsCryptoKeyVersionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleKmsCryptoKeyVersionConfig);
    get algorithm(): string;
    private _attestation;
    get attestation(): GoogleKmsCryptoKeyVersionAttestationList;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    get generateTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get protectionLevel(): string;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleKmsCryptoKeyVersionTimeoutsOutputReference;
    putTimeouts(value: GoogleKmsCryptoKeyVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleKmsCryptoKeyVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
